    
    @extends('employer.layouts.app')

@section('title','Shortlisted Candidate List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Shortlisted Candidates List </h1>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                    <div style="text-align: right;">
                    <a href="{{ route('EmployeeList') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Employees</a>
</div><br/>
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                            <table class="table table-striped table-hover" id="dataTable">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Candidate Name</th>
                                    <th>Address</th>
                                    <th>Mobile Number</th>
                                    <th>Email Id</th>
                                    <th>Highest Qualification</th>
                                    <th>Shortlisted Job Vacancy</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach ($shortlisted as $key=>$candidate)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{$candidate->user->name}}</td>
                                    <td>{{ $candidate->user->building_name }}</br>{{ $candidate->user->landmark }}
                                    </br>{{ $candidate->user->postOffice }}</br>{{ $candidate->user->pincode }}</td>
                                    <td>{{$candidate->user->mobile_number}}</td>
                                    <td>{{$candidate->user->email}}</td>
                                    <td>{{$candidate->user->highest_qualification }}</td>
                                    <td>{{$candidate->GetJob->name}}</td>
                                    <td>    
                                        <a href="{{ url('employer/shortlisted-candidate-details') }}/{{ base64_encode($candidate->GetJob->id) }}/{{ base64_encode($candidate->user->id) }}" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                    <i class="fas fa-eye"></i>                                       
                                    </td>
                                    </tr>
                            @endforeach 
                            </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection