@extends('employer.layouts.app')
@section('title','View Applied Candidate')
@section('content')
<!-- Begin Page Content -->
<div class="container-fluid">     

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $Candidate->name }}'s Details</h1>
     <a href="{{ route('ShortListedCandidateList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Shortlisted Candidates List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">
             <div style="text-align: right;">
                    
                <span class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-sm text-white-50"></i>Profile Status: 
                    @foreach($statuses as $val)
                        @if($val['id'] == $Candidate->profile_status)
                            {{ $val['name'] }}
                        @endif
                    @endforeach
                </span>
                    
            </div><br/>
                 <!--form--> 
                 
                <form id="notify-candidate" action="{{ route('SendNotificationToCandidate') }}" method="post">
                      @csrf
                    <div class="row">
                    <div class="col-md-12">
                            <p><h4><span>Personal Details</span></h4></p>
                        </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Candidate Name</b></label><br>
                                 {{ $Candidate->name  }}<input type="hidden" name="id" value="{{ $Candidate->id  }}">
                             </div>
                         </div>

                         <div class="col-md-6" type="hidden" hidden>
                            <div class="form-group">
                                <label for="">Employer ID<span style="color:red">*</span></label>
                                <input id="employerID" type="text" class="form-control" name="employerID" value="{{ auth()->user()->id }}">
                            </div>
                        </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email ID</b></label><br>
                                <input class="form-control" readonly="readonly" name="can_email" id="can_email" type="text" value="{{ $Candidate->email }}">
                                <input type="hidden" name="can_name" value="{{ $Candidate->name  }}">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Mobile Number</b></label><br>
                                {{ $Candidate->mobile_number }}
                             </div>
                        </div> 

                             @if ($Candidate->phone_number)
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for=""><b>Phone Number</b></label><br>
                                        {{ $Candidate->phone_number }}
                                    </div>
                                </div> 
                             @endif
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>DOB</b></label><br>
                                {{ date('d-m-Y', strtotime($Candidate->dob)) }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Gender</b></label><br>
                                {{ $Candidate->gender }}
                             </div>
                         </div>
                 
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Highest Qualification</b></label><br>
                                 {{ $Candidate->highest_qualification }}
                             </div>
                         </div>

                         @if ($Candidate->AdditionalCertificates)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=""><b>Additional Certificates</b></label><br>
                                    {{ $Candidate->AdditionalCertificates }}<input type="hidden" name="employer" value="{{ auth()->user()->name  }}">
                                </div>
                            </div>
                         @endif

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Building Name</b></label><br>
                                 {{ $Candidate->building_name }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Landmark</b></label><br>
                                 {{ $Candidate->landmark }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Post Office</b></label><br>
                                 {{ $Candidate->postOffice }}
                             </div>
                         </div>
                  
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>PIN Code</b></label><br>
                                 {{ $Candidate->pincode }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Religion</b></label><br>
                                 {{ $Candidate->religion }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Category</b></label><br>
                                {{ $Candidate->category }}
                             </div>
                         </div>

                         <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Candidate CV</label>

                                    <br>

                                     @if($Candidate->document_upload) 

                                     <a href="{{ asset('storage/CVupload/'.$Candidate->document_upload)}}" target="_blank" >Click Here to view the candidate CV</a>

                                    @endif
                             </div>
                         </div>

                         <div class="col-md-12">
                            <p><h4><span>PIA Details</span></h4></p>
                        </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>PIA</b></label><br>
                                {{ $Candidate->Training->ProgramImplementationAgency->agency_name }}<input type="hidden" name="pia_mail" value="{{ $Candidate->Training->ProgramImplementationAgency->email }}">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Attended</b></label><br>
                                {{ $Candidate->Training->training_name }}<input type="hidden" name="training" value="{{ $Candidate->Training->training_name }}">
                             </div>
                         </div>

                         <div class="col-md-12">
                             <div class="form-group">
                                <label for=""><b>Skills</b></label><br>
                                <div class="form-group">
                                    @foreach($Candidate->Training->SkillList as $key=>$skill)
                                     @if($key==0)
                                     {{ $skill->Skill->name }}
                                     @else
                                     ,{{ $skill->Skill->name }}
                                     @endif
                                     @endforeach
                                 </div>                                
                             </div>
                         </div>

                         <div class="col-md-12">
                            <p><h4><span>Employment Process</span></h4></p>
                        </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Applied Job</b></label><br>
                                 @foreach($Applied_Job as $key=>$applied_job)
                                 <input value="{{ $applied_job->GetJob->name }}" type="text" id="Job" class="form-control" name="Job" readonly="readonly">
                                 <input value="{{ $applied_job->GetJob->id }}" type="hidden" id="job_id" class="form-control" name="job_id" hidden>
                                @endforeach

                             </div>
                         </div>

                        <div class="col-md-6">             
                            <div class="form-group">
                                <label for="">Employment Status</label>
                                <div class="form-group">
                                    <select id="empstatusdropdown" name="EmpStatus" class="form-control">
                                    <option value="">Choose Employment Status </option>
                                        <option value="5">Placed</option>
                                        <option value="18">Rejected</option>
                                    </select>
                                    <span style="color:red" id="employment_status_error"></span>
                                </div>    
                            </div>
                        </div>   
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Message to Candidate</label>
                                <textarea id="candidate_message"  class="form-control" maxlength="150" name="candidate_message" ></textarea>
                                <span id="candidate_message_error" style="color:red"></span>
                            </div>
                        </div>
                            
                    </div>
                    <div class="row">
                        <div class="col-12 text-right">
                            <hr>
                                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>

                </form>

            </div>
             <!-- Card Body -->
        </div>
    </div>
     <!-- Add -->
</div>

</div>
<!-- /.container-fluid -->

@endsection