@extends('employer.layouts.app')

@section('title','Ongoing Courses List')

@section('content')

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Ongoing Courses </h1>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <!--<label for="">Sector</label><br>-->
                <div class="form-group">
                    <select id ="sectordropdown" name="SectorID" class="form-control">
                        <option value="0">Choose Sector</option>
                            @foreach($Sector as $sector)
                                <option value="{{ $sector->id }}">{{ $sector->name }}</option>
                            @endforeach
                    </select>
                    <span id="sector_error" style="color:red"></span>
                </div>    
            </div>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <!--<th>Sl.No</th>-->
                                        <th>Name of course</th>
                                        <th>Program Implementing Agency</th>
                                        <th>Number of students</th>
                                        <th>Course End date</th>
                                    </tr>
                                </thead>
                                <tbody id="tBody">
                                    @if (isset($data['trainigs']))

                                        @foreach ($data['trainigs'] as $key=>$trainig)
                                            <tr>
                                               <!-- <td>{{$key+1}}</td>-->
                                                <td>{{$trainig->training_name}}</td>
                                                <td>{{$trainig->agency_name}}</td>
                                                <td>{{$trainig->total_students}}</td>
                                                <td>{{\Carbon\Carbon::parse($trainig->end_date)->format('d-m-Y')}}</td>
                                            </tr>
                                        @endforeach 
                                    @endif  
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection