@extends('employer.layouts.app')
@section('title','View Candidate')
@section('content')
<!-- Begin Page Content -->
<div class="container-fluid">     

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $Candidate->name }}'s Details</h1>
     <a href="{{ route('CandidateInterestListEmp') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Candidates List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">
                 <!--form--> 
                 
                <form id="send-notification" action="{{ route('SendJobNotification') }}" method="post">
                      @csrf
                    <div class="row">
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Candidate Name</b></label><br>
                                 {{ $Candidate->name  }}<input type="hidden" name="id" value="{{ $Candidate->id  }}">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email ID</b></label><br>
                                {{ $Candidate->email }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Contact Number</b></label><br>
                                {{ $Candidate->mobile_number }}
                             </div>
                         </div>  <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>DOB</b></label><br>
                                {{ $Candidate->dob }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Gender</b></label><br>
                                {{ $Candidate->gender }}
                             </div>
                         </div>
                 
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Highest Qualification</b></label><br>
                                 {{ $Candidate->highest_qualification }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                <label for=""><b>Skills</b></label><br>
                                <div class="form-group">
                                    @foreach($Candidate->Training->SkillList as $key=>$skill)
                                     @if($key==0)
                                     {{ $skill->Skill->name }}
                                     @else
                                     ,{{ $skill->Skill->name }}
                                     @endif
                                     @endforeach
                                 </div>                                
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Additional Certificates</b></label><br>
                                {{ $Candidate->AdditionalCertificates }}
                             </div>
                         </div>
                  
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Address</b></label><br>
                                 {{ $Candidate->building_name }}</br>{{ $Candidate->landmark }}
                                </br>{{ $Candidate->postOffice }}</br>{{ $Candidate->pincode }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Religion</b></label><br>
                                 {{ $Candidate->religion }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Category</b></label><br>
                                {{ $Candidate->category }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>PIA</b></label><br>
                                {{ $Candidate->Training->ProgramImplementationAgency->agency_name }}<input type="hidden" name="pia_mail" value="{{ $Candidate->Training->ProgramImplementationAgency->email }}">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Attended</b></label><br>
                                {{ $Candidate->Training->training_name }}<input type="hidden" name="training" value="{{ $Candidate->Training->training_name }}">
                             </div>
                         </div>
                         <!--<div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Status</b></label><br>
                                 @if($Candidate->status==1) 
                                       Open
                                @elseif($Candidate->status==2)   
                                        Joined
                                @else
                                        Completed
                                @endif
                                 
                             </div>
                         </div> -->

                         <div class="col-md-6">             
                            <div class="form-group">
                                <label for="">Employment Status</label>
                                <div class="form-group">
                                    <select id="empstatusdropdown" name="EmpStatus" class="form-control" required>
                                    <option value="">Choose Employment Status </option>
                                        <option value="1">Shortlist</option>
                                        <option value="2">Reject</option>
                                    </select>
                                </div>    
                            </div>
                        </div>                      
                            
                    </div>
                    <div class="row">
                        <div class="col-12 text-right">
                            <hr>
                                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>

                </form>

            </div>
             <!-- Card Body -->
        </div>
    </div>
     <!-- Add -->
</div>

</div>
<!-- /.container-fluid -->

@endsection