    
    @extends('employer.layouts.app')

@section('title','Employee List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Employee List </h1>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                    <div style="text-align: right;">
                    <a href="{{ route('ShortListedCandidateList') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Shortlisted Candidates</a>

                    </div><br/>
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                            <table class="table table-striped table-hover" id="dataTable">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Employee Name</th>
                                    <th>Address</th>
                                    <th>Mobile Number</th>
                                    <th>Email Id</th>
                                    <th>Highest Qualification</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach ($employees as $key=>$employee)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{$employee->user->name}}</td>
                                    <td>{{ $employee->user->building_name }}</br>{{ $employee->user->landmark }}
                                    </br>{{ $employee->user->postOffice }}</br>{{ $employee->user->pincode }}</td>
                                    <td>{{$employee->user->mobile_number}}</td>
                                    <td>{{$employee->user->email}}</td>
                                    <td>{{$employee->user->highest_qualification }}</td>
                                    <td>                                        
                                        <a href="{{ route('EmployeeDetails',['employee'=>base64_encode($employee->user->id)]) }}" class='btn btn-info btn-circle btn-sm'>
                                            <i class="fas fa-eye"></i>
                                        </a></td>
                                    </tr>
                            @endforeach 
                            </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection