@extends('employer.layouts.app')
@section('title','View Applied Candidate')
@section('content')
<!-- Begin Page Content -->
<div class="container-fluid">     

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $Employee->user->name }}'s Details</h1>
     <a href="{{ route('ShortListedCandidateList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Shortlisted Candidates List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">
                <div style="text-align: right;">
                    
                    <span class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                        class="fas fa-sm text-white-50"></i>Profile Status: 
                        @foreach($statuses as $val)
                            @if($val['id'] == $Employee->user->profile_status)
                                {{ $val['name'] }}
                            @endif
                        @endforeach
                    </span>
                        
                </div><br/>
                 <!--form--> 
                 
                <form id="update-employee" action="{{ route('UpdateEmployee') }}" method="post">
                      @csrf
                    <div class="row">
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Employee Name</b></label><br>
                                 {{ $Employee->user->name  }}<input type="hidden" name="id" value="{{ $Employee->user->id  }}">
                             </div>
                         </div>

                         <div class="col-md-6" type="hidden" hidden>
                            <div class="form-group">
                                <label for="">Employer ID<span style="color:red">*</span></label>
                                <input id="employerID" type="text" class="form-control" name="employerID" value="{{ auth()->user()->id }}">
                            </div>
                        </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email ID</b></label><br>
                                <input class="form-control" readonly="readonly" name="can_email" id="can_email" type="text" value="{{ $Employee->user->email }}">
                                <input type="hidden" name="can_name" value="{{ $Employee->user->name  }}">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Contact Number</b></label><br>
                                {{ $Employee->user->mobile_number }}
                             </div>
                        </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Gender</b></label><br>
                                {{ $Employee->user->gender }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Job Role</b></label><br>
                                 @if (isset($Employee->GetJob))
                                 <input value="{{ $Employee->GetJob->name }}" type="text" id="Job" class="form-control" name="Job" readonly="readonly">
                                 <input value="{{ $Employee->GetJob->id }}" type="hidden" id="job_id" class="form-control" name="job_id" hidden>
                                 @endif
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Job Location</b></label><br>
                                {{ $Employee->location }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Salary</b></label><br>
                                {{ $Employee->salary }}
                             </div>
                         </div>

                        <div class="col-md-6">             
                            <div class="form-group">
                                <label for="">Employment Status</label>
                                <div class="form-group">
                                    <select id="empstatusdropdown" name="EmpStatus" class="form-control" required>
                                    <option value="">Choose Employment Status </option>
                                        <option value="16">Resigned</option>
                                        <option value="17">Terminated</option>
                                    </select>
                                </div>    
                            </div>
                        </div>   
                        
                    </div>
                    <div class="row">
                        <div class="col-12 text-right">
                            <hr>
                                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <button type="reset" class="btn btn-default"><a href="{{ route('EmployeeList')}}">Cancel</a></button>
                        </div>
                    </div>

                </form>

            </div>
             <!-- Card Body -->
        </div>
    </div>
     <!-- Add -->
</div>

</div>
<!-- /.container-fluid -->

@endsection