@extends('employer.layouts.app')

@section('title','Candidates List')
  
@section('content')

    <!-- Begin Page Content -->
<div class="container-fluid">

      <!-- Page Heading -->
      <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Candidate List </h1>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <!--<label for="">Sector</label><br>-->
                <div class="form-group">
                    <select id ="Skill" name="Skill" class="form-control">
                        <option value="">Choose Skill</option>
                            @foreach($Skills as $skill)
                                <option value="{{ $skill->id }}">{{ $skill->name }}</option>
                            @endforeach
                    </select>
                </div>    
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <!--<label for="">Sector</label><br>-->
                <div class="form-group">
                    <select id ="qualification" name="qualification" class="form-control">
                        <option value="0">Choose Qualification</option>
                        <option value=" 8th">8th</option>
                        <option value="SSLC">SSLC</option>
                        <option value="12th">12th</option>
                        <option value="Diploma">Diploma</option>
                        <option value="UG">UG</option>
                        <option value="PG">PG</option>
                        <option value="PG Diploma">PG Diploma</option>                         
                    </select>
                </div>    
            </div>
        </div>

        <div class="row">
        <!-- list -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">

                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover canTable" id="dataTable">
                            <thead>
                                <tr>

                                    <th>Candidate Name</th>
                                    <th>Address</th>
                                    <th>Mobile Number</th>
                                    <th>Email Id</th>
                                    <th>Highest Qualification</th>
                                    <th>Training Programme</th>
                                </tr>
                            </thead>
                            <tbody id="tBody">
                                    @if (isset($data['candidates']))

                                        @foreach ($data['candidates'] as $key=>$candidate)
                                            <tr>
                                                <td>{{$candidate->name}}</td>
                                                <td>{{ $candidate->building_name }}</br>{{ $candidate->landmark }}
                                                </br>{{ $candidate->postOffice }}</br>{{ $candidate->pincode }}</td>
                                                <td>{{$candidate->mobile_number}}</td>
                                                <td>{{$candidate->email}}</td>
                                                <td>{{$candidate->highest_qualification}}</td>
                                                @if($candidate->Training)
                                                <td><a href = "{{ route('EmployerviewTrainingProgramme',['Training'=>base64_encode($candidate->Training->id)]) }}" target="_blank" > {{$candidate->Training->training_name}}</td>
                                                @endif
                                            </tr>
                                        @endforeach 
                                    @endif  
                                </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->         

@endsection