@extends('employer.layouts.app')
  
@section('content')
<div class="row">
        <!-- list -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">
                <div
                    class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Candidate Interest Overview</h6>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Candidate Name</th>
                                    <th>Address</th>
                                    <th>Mobile Number</th>
                                    <th>Email Id</th>
                                    <th>Skills</th>
                                    <th>Highest Qualification</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach ($candidates as $key=>$candidate)
                                <tr>
                                    <td>{{$candidate->id}}</td>
                                    <td>{{$candidate->name}}</td>
                                    <td>{{ $candidate->building_name }}</br>{{ $candidate->landmark }}
                                    </br>{{ $candidate->postOffice }}</br>{{ $candidate->pincode }}</td>
                                    <td>{{$candidate->mobile_number}}</td>
                                    <td>{{$candidate->email}}</td>
                                    <td>
                                    @foreach($candidate->Training->SkillList as $key=>$skill)
                                     @if($key==0)
                                     {{ $skill->Skill->name }}
                                     @else
                                     ,{{ $skill->Skill->name }}
                                     @endif
                                     @endforeach
                                    </td>
                                    
                                    <td>{{$candidate->category}}</td>
                                    <td><a href="{{ url('/employer/candidateinterestdetview') }}/{!! base64_encode($candidate->id)!!}">View More</a></td>
                                </tr>
                            @endforeach 
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->
  
           

@endsection