@extends('employer.layouts.app')
  
@section('content')
<div class="row">
        <!-- list -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">
                <div
                    class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Applied Candidate List</h6>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="dataTable">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Candidate Name</th>
                                    <th>Address</th>
                                    <th>Mobile Number</th>
                                    <th>Email Id</th>
                                    <th>Highest Qualification</th>
                                    <th>Applied Job Vacancy</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach ($candidates as $key=>$candidate)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{$candidate->Candidate->name}}</td>
                                    <td>{{ $candidate->Candidate->building_name }}</br>{{ $candidate->Candidate->landmark }}
                                    </br>{{ $candidate->Candidate->postOffice }}</br>{{ $candidate->Candidate->pincode }}</td>
                                    <td>{{$candidate->Candidate->mobile_number}}</td>
                                    <td>{{$candidate->Candidate->email}}</td>
                                    <td>{{ $candidate->Candidate->highest_qualification }}</td>
                                    <td>{{ $candidate->Job->name }}</td>
                                    <td>
                                        <a href="{{ url('employer/appliedcandidatedetailview') }}/{{ base64_encode($candidate->Job->id) }}/{{ base64_encode($candidate->Candidate->id) }}" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                    </td>
                            
                                </tr>
                            @endforeach 
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->
  
           

@endsection