  


<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" />
    <meta name="description" content="Kudumbashree">
    <meta name="author" content="Kudumbashree">
    <title>@yield('title')</title>

    <!-- Custom fonts for this template-->
    <link href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
    <link href="{{ asset('vendor/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="{{ asset('css/kudumbashree.css') }}" rel="stylesheet">

    <!--<link rel="stylesheet" href="{{ asset('plugins/multiselect/dist/css/bootstrap-multiselect.css') }}" type="text/css"/>-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css" type="text/css"/>

   


</head>

<body id="page-top">


    <!-- Page Wrapper -->
    <div id="wrapper">

                     <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

            <!-- Sidebar - Brand -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{ route('employer-dashboard') }}">
                <img src="{{ asset('img/logo.png') }}" title="Kudumbashree" class="img-responsive">
            </a>

            <!-- Divider -->
            <hr class="sidebar-divider my-0">

            <!-- Nav Item - Dashboard -->
            <li class="nav-item active">
                <a class="nav-link" href="{{ route('employer-dashboard') }}">
                <i class="fas fa-fw fa-home"></i>
                    <span>Dashboard</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="{{ route('JobVacanciesList') }}">
                <i class="fas fa-fw fa-adjust"></i>
                    <span>Job Vacancies</span></a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link" href="{{ route('employercourseList') }}">
                <i class="fas fa-fw fa-list-alt"></i>
                    <span>Training Program</span></a>
            </li>

            </li>
              <!-- Nav Item - Pages Collapse Menu -->
              <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseOne"
                    aria-expanded="true" aria-controls="collapseOne">
                    <i class="fas fa-fw fa-briefcase"></i>
                    <span>Placements</span>
                </a>
                <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('ongoingCourseList') }}">Ongoing Courses</a>
                        <a class="collapse-item" href="{{ route('completedTrainingList') }}">Completed Trainings</a>
                    </div>
                </div>
            </li>


            </li>
              <!-- Nav Item - Pages Collapse Menu -->
              <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTwo"
                    aria-expanded="true" aria-controls="collapseTwo">
                    <i class="fas fa-fw fa-users"></i>
                    <span>Candidates</span>
                </a>
                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('CandidateList') }}">Candidate List</a>
                        <a class="collapse-item" href="{{ route('AppliedCandidateList') }}">Applied Candidate List</a>
                    </div>
                </div>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="{{ route('ShortListedCandidateList') }}">
                <i class="fas fa-fw fa-clone"></i>
                    <span>Recruitment</span></a>
            </li>
            
           

          
           <!-- <li class="nav-item">
                <a class="nav-link" href="{{ route('CandidateInterestListEmp') }}">
                <i class="fas fa-fw fa-file-alt"></i>
                    <span>Candidates Interest Listing</span></a>
                    
            </li>-->
           <!-- <li class="nav-item">
                <a class="nav-link" href="#">
                <i class="fas fa-fw fa-bell"></i>
                    <span>Announcements</span></a>
            </li>-->

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>

        </ul>
            <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

                       <!-- Topbar -->
                       <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

<!-- Sidebar Toggle (Topbar) -->
<button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
    <i class="fa fa-bars"></i>
</button>

<!-- Topbar Search -->
<!--<form
    class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
    <div class="input-group">
        <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..."
            aria-label="Search" aria-describedby="basic-addon2">
        <div class="input-group-append">
            <button class="btn btn-primary" type="button">
                <i class="fas fa-search fa-sm"></i>
            </button>
        </div>
    </div>
</form>-->

<!-- Topbar Navbar -->
<ul class="navbar-nav ml-auto">

    <!-- Nav Item - Search Dropdown (Visible Only XS) -->
    <li class="nav-item dropdown no-arrow d-sm-none">
        <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-search fa-fw"></i>
        </a>
        <!-- Dropdown - Messages -->
        <!--<div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
            aria-labelledby="searchDropdown">
            <form class="form-inline mr-auto w-100 navbar-search">
                <div class="input-group">
                    <input type="text" class="form-control bg-light border-0 small"
                        placeholder="Search for..." aria-label="Search"
                        aria-describedby="basic-addon2">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="button">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>-->
    </li>

    <!-- Nav Item - Alerts -->
    <!--<li class="nav-item dropdown no-arrow mx-1">
        <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-bell fa-fw"></i>
           
            <span class="badge badge-primary badge-counter">3+</span>
        </a>
       
        <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
            aria-labelledby="alertsDropdown">
            <h6 class="dropdown-header">
                Alerts Center
            </h6>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-primary">
                        <i class="fas fa-file-alt text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 12, 2019</div>
                    <span class="font-weight-bold">A new monthly report is ready to download!</span>
                </div>
            </a>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-success">
                        <i class="fas fa-donate text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 7, 2019</div>
                    $290.29 has been deposited into your account!
                </div>
            </a>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-warning">
                        <i class="fas fa-exclamation-triangle text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 2, 2019</div>
                    Spending Alert: We've noticed unusually high spending for your account.
                </div>
            </a>
            <a class="dropdown-item text-center small text-gray-500" href="#">Show All Alerts</a>
        </div>
    </li>-->
    <!--alert-->

    <div class="topbar-divider d-none d-sm-block"></div>

    <!-- Nav Item - User Information -->
    <li class="nav-item dropdown no-arrow">
        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <span class="mr-2 d-none d-lg-inline text-gray-600 small">{{ auth()->user()->name }} (@if(auth()->user()->user_role_id==1)
            Super admin
            @elseif(auth()->user()->user_role_id==2)
            District admin
            @elseif(auth()->user()->user_role_id==3)
            Block admin
            @elseif(auth()->user()->user_role_id==4)
            PIA
            @elseif(auth()->user()->user_role_id==5)
            Employer
            @elseif(auth()->user()->user_role_id==6)
            Candidates
            @endif
            )</span>
            <img class="img-profile rounded-circle" src="{{ asset('img/undraw_profile.svg') }}">
        </a>
        <!-- Dropdown - User Information -->
        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
            aria-labelledby="userDropdown">
            <a class="dropdown-item" href="{{ route('employer-profile') }}">
                <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                Profile
            </a>
            <a class="dropdown-item" href="#">
                <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                Settings
            </a>
            <div class="dropdown-divider"></div>
            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                Logout
            </a>
        </div>
    </li>

</ul>

</nav>

             @yield('content')

       

          <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Kudumbashree {{ date('Y') }}</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    

    

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">To continue to log out, please select the logout button.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="{{ url('/logout') }}">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
<script src="{{ asset('vendor/jquery/jquery.min.js') }}"></script>

     
   
    <script src="{{ asset('js/demo/datatables-demo.js') }}"></script>

 

    


    <script src="{{ asset('vendor/datatables/jquery.dataTables.js') }}"></script>

    <script>

        $(document).ready(function()
        {
            $("dataTable").DataTable();
        });
    </script>

    <script src="{{ asset('vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ asset('vendor/jquery-easing/jquery.easing.min.js') }}"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{ asset('js/kudumbashree.js') }}"></script>

    <!-- Page level plugins -->
    <script src="{{ asset('vendor/chart.js/Chart.min.js') }}"></script>

    <!-- Page level custom scripts -->
    <script src="{{ asset('js/demo/chart-area-demo.js') }}"></script>
    <script src="{{ asset('js/demo/chart-pie-demo.js') }}"></script>

    <script src="{{ asset('js/sweetalert.js') }}"></script>

    <!--<script type="text/javascript" src="{{ asset('plugins/multiselect/dist/js/bootstrap-multiselect.js') }}"></script>-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script>
    <script>
        $(document).ready(function () {
            $('#skill').multiselect({
                nonSelectedText: 'Select Skill',
                enableFiltering: true,
                enableCaseInsensitiveFiltering: true,
                buttonWidth: '400px'
            });

        });
    </script>
<!--<script>

    $(document).ready(function()
    {
        $(".multiselect").multiselect();
    });
-->
</script>

    <script>

        $(document).ready(function()
        {

            
            $(document).on("change","#country",function()
            {
                var country=$(this).val();

                if(country!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadStates') }}",
                        type:"POST",
                        data:{country:country},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var states=response.states;

                                $("#state").html("");

                                $("#state").append("<option value=''>Choose State</option>");

                                states.forEach(function(state)
                                {
                                    $("#state").append("<option value='"+state.id+"'>"+state.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#state",function()
            {
                var state=$(this).val();

                if(state!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadDistricts') }}",
                        type:"POST",
                        data:{state:state},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var districts=response.districts;

                                $("#district").html("");

                                $("#district").append("<option value=''>Choose District</option>");

                                districts.forEach(function(district)
                                {
                                    $("#district").append("<option value='"+district.id+"'>"+district.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#district",function()
            {
                var district=$(this).val();

                if(district!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadBlocks') }}",
                        type:"POST",
                        data:{district:district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var blocks=response.blocks;

                                $("#block").html("");

                                $("#block").append("<option value=''>Choose Block</option>");

                                blocks.forEach(function(block)
                                {
                                    $("#block").append("<option value='"+block.id+"'>"+block.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });
            
          

            $(document).on("click",".deactivate-job",function()
            {
                var job=$(this).data('job-id');

                Swal.fire({
                    title: "Are you sure to deactivate Job Vacancy?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivateJobVacancy') }}",
                            type:"POST",
                            data:{job:job},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "The job vacancy was successfully removed.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {

                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Job Vacancy is safe", "", "info");
                    }
                });
            });

            $(document).on("submit","#update-employee",function(e)
            {
               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('UpdateEmployee') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("Employee Details Updated Succesfully!",response.message,"success");

                            $("#update-employee")[0].reset();

                            window.location.href = response.redirect;

                           
                            $("#ajax-loader").hide();
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

        });

    </script>

<script>

$(document).ready(function()
{
    $(document).on("keyup","#vacancy_name",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Provide a valid Job Vacancy Name";
        }

        else if(length>80){

            message+="Maximum of 80 characters allowed"

        }
        else{
            message="";

            $("#vacancy_name").removeClass("error");

        }

        $("#vacancy_name_error").html(message);



    });

    $(document).on("keyup","#vacancy_code",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Provide atleast one character as Job Code";
        }

        else if(length>10){

            message+="Maximum of 10 characters allowed"

        } else{
            message="";

            $("#vacancy_code").removeClass("error");

        }

        $("#code_error").html(message);



    });

    $(document).on("keyup","#location",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Provide a valid Location";
        }

        else if(length>200){

            message+="Maximum of 50 characters allowed"

        } else{
            message="";

            $("#location").removeClass("error");

        }

        $("#location_error").html(message);

    });

    $(document).on("keyup","#qualification",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Provide a valid Qualification";
        }

        else if(length>200){

            message+="Maximum of 50 characters allowed"

        } else{
            message="";

            $("#qualification").removeClass("error");

        }

        $("#qualification_error").html(message);

    });

    $(document).on("keyup","#salary",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Provide a valid salary range";
        }

        else if(length>200){

            message+="Maximum of 50 characters allowed"

        } else{
            message="";

            $("#salary").removeClass("error");

        }

        $("#salary_error").html(message);

    });

    // $(document).on("keyup","#salary",function(e)
    // {

    //     var length=$(this).val().length;

    //     var salary = $("#salary").val();

    //     var regsal = "^\d{1,10}(?:\.\d{0,2})?([-]\d{1,10}(?:\.\d{0,2})?)?$";

    //     var message="";

    //     if(length<1)
    //     {
    //         message+="Provide a valid salary range";
    //     }

    //     else if(length>200){

    //         message+="Maximum of 50 characters allowed"

    //     } 
    //     else{
    //             message="";

    //             $("#salary").removeClass("error");
    //         }

        
    //     $("#salary_error").html(message);

    // });



    $(document).on("keyup","#description",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Provide a valid description";
        }

        else if(length>200){

            message+="Maximum of 200 characters allowed"

        } else{
            message="";

            $("#description").removeClass("error");

        }

        $("#description_error").html(message);

    });

});


</script>

<script>
        $(document).ready(function () {

            $("#skill").on("change blur", function() {
    var selectedOptions = $(this).find(":selected");

    if (selectedOptions.length > 0) {
        // Option selected
        $("#skill_error").html('');
        $(".multiselect").removeClass("error");
    } else {
        // No option selected
        $("#skill_error").html('Please select the Skill');
        $(".multiselect").addClass("error");
    }
});
        });
    </script>

<script>
    function validateImage() {
        var input = document.getElementById('job_doc');
        var errorText = document.getElementById('errorMessage');

        // Check if a file is selected
        if (!input.files || !input.files[0]) {
            errorText.innerText = 'Please select an image.';
            return;
        }

        var file = input.files[0];

        // Check image dimensions
        var fileInput = this;
        var img = new Image();
        img.src = URL.createObjectURL(file);

        img.onload = function () {
            if (img.width > 1600 || img.height > 1600) {
                errorText.innerText = 'Image dimensions must be a maximum of 1600 x 1600 pixels.';
                errorText.style.color = 'red';
                fileInput.value = '';
            } else {
                // Check image file size
                if (file.size > 2 * 1024 * 1024) {
                    errorText.innerText = 'Image size must be a maximum of 2MB.';
                    errorText.style.color = 'red';
                    fileInput.value = '';
                } else {
                    // Reset error message if validation passes
                    errorText.innerText = '';
                }
            }
        };
    }

    // Prevent form submission for testing
    document.getElementById('imageUploadForm').addEventListener('submit', function (event) {
        event.preventDefault();
        alert('Form submitted successfully!');
    });
</script>



<script>

    $(document).ready(function()
    {
        //alert("hi");
        document.getElementById('job_doc').addEventListener('change', function() {
        var fileInput = this;
        var errorMessage = document.getElementById('errorMessage');

        // Check if a file is selected
        if (fileInput.files.length > 0) {
            var fileSize = fileInput.files[0].size; // Size in bytes
            var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

        if (fileSize > maxSize) {
            errorMessage.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
            errorMessage.style.color = 'red';
            // Clear the selected file
            fileInput.value = '';
        } else {
            errorMessage.textContent = 'Only Jpeg documents of maximum size of 2MB allowed';
            errorMessage.style.color = '#858796'; // Reset to default color
        }
        } else {
            errorMessage.textContent = 'Only Jpeg documents of maximum size of 2MB allowed';
            errorMessage.style.color = '#858796'; // Reset to default color if no file selected
        }
    });

});


</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#submit_job_details",function(e) {
            var employer = $("#employer").val();
            var vacancy_name = $("#vacancy_name").val();
            var job_code =$("#vacancy_code").val();
            var job_location = $("#location").val();
            var qualification = $("#qualification").val();
            var Skill = $("#skill").val();
            var salary = $("#salary").val();
            var description = $("#description").val();

            if (!vacancy_name|| !job_code|| !job_location|| !qualification|| !Skill || Skill.length === 0|| !salary || !description)
            {
                if(!vacancy_name)
                {
                    $("#vacancy_name_error").html("Please enter the Job Vacancy Name");
                    $("#vacancy_name").addClass("error");

                }
                else{
                    $("#vacancy_name_error").html("");
                    $("#vacancy_name").removeClass("error");
                }

                if(!job_code)
                {
                    $("#code_error").html("Please enter valid Job Code");
                    $("#vacancy_code").addClass("error");
                }
                else{
                    $("#code_error").html("");
                    $("#vacancy_code").removeClass("error");
                }

                if(!job_location)
                {
                    $("#location_error").html("Please enter the Job Location");
                    $("#location").addClass("error");
                }
                else{
                    $("#location_error").html("");
                    $("#location").removeClass("error");
                }

                if(!qualification)
                {
                    $("#qualification_error").html("Please enter the qualification");
                    $("#qualification").addClass("error");
                }
                else{
                    $("#qualification_error").html("");
                    $("#qualification").removeClass("error");
                }

                
                if(!Skill || Skill.length === 0)
                {
                    $("#skill_error").html("Please select the Skills");
                    $(".multiselect").addClass("error");
                }
                else{
                    $("#skill_error").html("");
                    $(".multiselect").removeClass("error");
                }

                if(!salary)
                {
                    $("#salary_error").html("Please enter a valid salary which must be numeric or a numeric range!");
                    $("#salary").addClass("error");
                }
                else{
                    $("#salary_error").html("");
                    $("#salary").removeClass("error");
                }

                if(!description)
                {
                    $("#description_error").html("Please enter a valid description");
                    $("#description").addClass("error");
                }
                else{
                    $("#description_error").html("");
                    $("#description").removeClass("error");
                } 

                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#plwait").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);

            formData.append('attachment',$(this)[0].files);

            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('submitJobVacancyDetails') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Job Vacancy was successfully created.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_job_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_job_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#plwait").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#plwait").hide();
                }
            });
        });
    });
    
</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#update_job_details",function(e) {
            var employer = $("#employer").val();
            var vacancy_name = $("#vacancy_name").val();
            var job_code =$("#vacancy_code").val();
            var job_location = $("#location").val();
            var qualification = $("#qualification").val();
            var Skill = $("#skill").val();
            var salary = $("#salary").val();
            var description = $("#description").val();

            if (!vacancy_name|| !job_code|| !job_location|| !qualification|| !Skill || Skill.length === 0|| !salary || !description)
            {
                if(!vacancy_name)
                {
                    $("#vacancy_name_error").html("Please enter the Job Vacancy Name");
                    $("#vacancy_name").addClass("error");

                }
                else{
                    $("#vacancy_name_error").html("");
                    $("#vacancy_name").removeClass("error");
                }

                if(!job_code)
                {
                    $("#code_error").html("Please enter valid Job Code");
                    $("#vacancy_code").addClass("error");
                }
                else{
                    $("#code_error").html("");
                    $("#vacancy_code").removeClass("error");
                }

                if(!job_location)
                {
                    $("#location_error").html("Please enter a valid Job Location");
                    $("#location").addClass("error");
                }
                else{
                    $("#location_error").html("");
                    $("#location").removeClass("error");
                }

                if(!qualification)
                {
                    $("#qualification_error").html("Please enter the qualification");
                    $("#qualification").addClass("error");
                }
                else{
                    $("#qualification_error").html("");
                    $("#qualification").removeClass("error");
                }

                
                if(!Skill || Skill.length === 0)
                {
                    $("#skill_error").html("Please select the Skills");
                    $(".multiselect").addClass("error");
                }
                else{
                    $("#skill_error").html("");
                    $(".multiselect").removeClass("error");
                }

                if(!salary)
                {
                    $("#salary_error").html("Please enter a valid salary which must be numeric or a numeric range!");
                    $("#salary").addClass("error");
                }
                else{
                    $("#salary_error").html("");
                    $("#salary").removeClass("error");
                }

                if(!description)
                {
                    $("#description_error").html("Please enter a valid description");
                    $("#description").addClass("error");
                }
                else{
                    $("#description_error").html("");
                    $("#description").removeClass("error");
                } 

                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#plwait").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);

            formData.append('attachment',$(this)[0].files);

            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('updateJobVacancyDetails') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Job Vacancy was successfully updated.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#update_job_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#update_job_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#plwait").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#plwait").hide();
                }
            });
        });
    });
    
</script>

<script>                
        $('#sectordropdown').on('change blur', function () {
        //alert("Hi");
            var idSector = this.value;
            var secid = $('#sectordropdown').val();
            if (idSector==secid) { 
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-trainings/" + idSector,
                    data: { idSector: idSector },
                    success: function (data) { 
                            //alert("hi");
                            $("#dataTable").DataTable().destroy();
                            var trHTML = ''; 
                            $("#tBody").empty();    
                            var baseurl = "{{ url("employer/ongoing-course-list") }}"; 

                            $.each(data.data.trainigs, function (key, value) {    
                            //alert("Hi");         
                                var i = parseInt(key)+1;                
                                trHTML +=
                                    '<tr><td>'
                                    + value.training_name
                                    + '</td><td>'
                                    + value.agency_name
                                    + '</td><td>'
                                    + value.total_students
                                    + '</td><td>'
                                    + value.end_date 
                                    + '</td></tr>';
                            
                             });
                            $('#tBody').append(trHTML);
                            $("#dataTable").DataTable();
                            
                        },
                });
            } else {
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-trainings/" + idSector,
                    data: { idSector: idSector },
                    success: function (data) { 
                            //alert("hi");
                            $("#dataTable").DataTable().destroy();
                            var trHTML = ''; 
                            $("#tBody").empty();    
                            var baseurl = "{{ url("employer/ongoing-course-list") }}"; 

                            $.each(data.data.trainigs, function (key, value) {    
                            //alert("Hi");         
                                var i = parseInt(key)+1;                
                                trHTML +=
                                    '<tr><td>'
                                    + value.training_name
                                    + '</td><td>'
                                    + value.agency_name
                                    + '</td><td>'
                                    + value.total_students
                                    + '</td><td>'
                                    + value.end_date 
                                    + '</td></tr>';
                            
                             });
                            $('#tBody').append(trHTML);
                            $("#dataTable").DataTable();
                            
                        },
   
                    });


                }
    

            });

</script>

<script>

    $(document).ready(function()
    {
        $(document).on("submit","#change_password_form",function(e)
        {
            e.preventDefault();

            var old_password=$("#old_password").val();
            var new_password=$("#new_password").val();
            var confirm_password=$("#confirm_password").val();

            var form_data=new FormData($(this)[0]);

            
            if(old_password)
            {

                
                var old_password=$("#old_password").val();

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token()}}"},
                    url:"{{ route('checkCurrentPassword') }}",
                    type:"POST",
                    data:{password:old_password},
                    dataType:"JSON",
                    success:function(response)
                    {
                        if(response.password_match_status==0)
                        {
                            $("#old_password_error").html("Current password is invalid");
                            $("#old_password").addClass("error");

                        }

                        else{

                            $("#old_password_error").html("");
                            $("#old_password").removeClass("error");

                        }
                    },
                    error:function()
                    {

                    }
                });

            }

            if(!old_password || !new_password || !confirm_password)
            {
                Swal.fire("error","Please fill all mandatory fields","error");

                if(!old_password)
                {
                    $("#old_password_error").html("Enter old password");
                    $("#old_password").addClass("error");
                }

                if(!new_password)
                {
                    $("#new_password_error").html("Enter new password");
                    $("#new_password").addClass("error");
                }

                if(!confirm_password)
                {
                    $("#confirm_password_error").html("Enter confirm password");
                    $("#confirm_password").addClass("error");
                }

               
            }
            

            else if(old_password && confirm_password && new_password){

                if(confirm_password!=new_password){
                        
                            $("#confirm_password_error").html("New password and confirm password do not match");


                    }

                    else if(old_password==new_password){
                    $("#confirm_password_error").html("New password cannot be the same as the old password!");
                    $("#new_password").addClass("error");

                }else if(old_password==confirm_password){
                    $("#confirm_password_error").html("Confirm password cannot be the same as the old password!");
                    $("#confirm_password").addClass("error");

                }

                else{

                    $.ajax({

                        url:"{{ route('changePassword') }}",
                        type:"POST",
                        data:form_data,
                        dataType:"JSON",
                        processData:false,
                        contentType:false,
                        success:function(response)
                        {
                            if(response.status=="success")
                            {
                                Swal.fire("Success",response.message,"success").then(function(result)
                                {
                                    if(result.isConfirmed)
                                    {
                                        window.location.reload();
                                    }
                                });

                                
                            }

                            else{

                                Swal.fire("Error",response.message,"error");


                            }
                        },
                        error:function()
                        {
                            Swal.fire("error","Smething went wrong","error");
                        }
                    });


                }


            }

        });

        $(document).on("keyup","#old_password",function()
        {
            $("#old_password").removeClass("error");
            $("#old_password_error").html("");
        });

        $(document).on("keyup","#new_password",function()
        {
            $("#new_password").removeClass("error");
            $("#new_password_error").html("");
        });

        $(document).on("keyup","#confirm_password",function()
        {
            $("#confirm_password").removeClass("error");
            $("#confirm_password_error").html("");
        });
    });


</script>

<script>

function togglePasswordVisibilityOldPassword()
{
    var old_password=document.getElementById("old_password");

    if(old_password.type=="text")
    {
        $("#old_password").attr("type","password");
    }

    else{

        $("#old_password").attr("type","text");
    }
}

function togglePasswordVisibilityNewPassword()
{
    var new_password=document.getElementById("new_password");

    if(new_password.type=="text")
    {
        $("#new_password").attr("type","password");
    }

    else{

        $("#new_password").attr("type","text");
    }
}

function togglePasswordVisibilityConfirmPassword()
{
    var confirm_password=document.getElementById("confirm_password");

    if(confirm_password.type=="text")
    {
        $("#confirm_password").attr("type","password");
    }

    else{

        $("#confirm_password").attr("type","text");
    }
}


</script>

<script>

$(document).ready(function()
{
$("#jobvacancydropdown").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#job_error").html('Please select a Job Vacancy');
    } else {
        $("#job_error").html('');
        $("#jobvacancydropdown").removeClass("error");
    }
  });

  $("#empstatusdropdown").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#employment_status_error").html('Please select the Employment Status');
    } else {
        $("#employment_status_error").html('');
        $("#empstatusdropdown").removeClass("error");
    }
  });

  $(document).on("keyup","#candidate_message",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the message to Candidate";
        }

        else if(length>300){

            message+="Maximum 300 characters allowed"

        }
        else{
                message="";

                $("#candidate_message").removeClass("error");
            }


        $("#candidate_message_error").html(message);



    });
  
});

</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#send-notification",function(e) {
            var EmpStatus = $("#empstatusdropdown").val();
            var candidate_message = $("#candidate_message").val();
            var Job =$("#jobvacancydropdown").val();

            if (!EmpStatus|| !candidate_message|| !Job)
            {
                if(!EmpStatus)
                {
                    $("#employment_status_error").html("Please select the Employment Status");
                    $("#empstatusdropdown").addClass("error");

                }
                else{
                    $("#employment_status_error").html("");
                    $("#empstatusdropdown").removeClass("error");
                }

                if(!candidate_message)
                {
                    $("#candidate_message_error").html("Please enter message to candidate");
                    $("#candidate_message").addClass("error");
                }
                else{
                    $("#candidate_message_error").html("");
                    $("#candidate_message").removeClass("error");
                }

                if(!Job)
                {
                    $("#job_error").html("Please Select a Job Vacancy");
                    $("#jobvacancydropdown").addClass("error");
                }
                else{
                    $("#job_error").html("");
                    $("#jobvacancydropdown").removeClass("error");
                }


                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#ajax-loader").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);


            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('SendJobNotification') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Candidate Notification Sent.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#send-notification")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#send-notification")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#ajax-loader").hide();
                    }
                },
                error:function(response) {
                    if(response.status == 400){
                        Swal.fire("wrong","Job Application Exists! Please choose another Job.","error");
                    } else{
                        Swal.fire("wrong","Something Went Wrong","error");
                    $("#ajax-loader").hide();

                    }
                }

            });
        });
    });
    
</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#notify-applied-candidate",function(e) {
            var EmpStatus = $("#empstatusdropdown").val();
            var candidate_message = $("#candidate_message").val();

            if (!EmpStatus|| !candidate_message)
            {
                if(!EmpStatus)
                {
                    $("#employment_status_error").html("Please select the Employment Status");
                    $("#empstatusdropdown").addClass("error");

                }
                else{
                    $("#employment_status_error").html("");
                    $("#empstatusdropdown").removeClass("error");
                }

                if(!candidate_message)
                {
                    $("#candidate_message_error").html("Please enter message to candidate");
                    $("#candidate_message").addClass("error");
                }
                else{
                    $("#candidate_message_error").html("");
                    $("#candidate_message").removeClass("error");
                }

                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#ajax-loader").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);


            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('SendNotificationToAppliedCandidate') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Candidate Notification Sent.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#notify-applied-candidate")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#notify-applied-candidate")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#ajax-loader").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#ajax-loader").hide();
                }
            });
        });
    });
    
</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#notify-candidate",function(e) {
            var EmpStatus = $("#empstatusdropdown").val();
            var candidate_message = $("#candidate_message").val();

            if (!EmpStatus|| !candidate_message)
            {
                if(!EmpStatus)
                {
                    $("#employment_status_error").html("Please select the Employment Status");
                    $("#empstatusdropdown").addClass("error");

                }
                else{
                    $("#employment_status_error").html("");
                    $("#empstatusdropdown").removeClass("error");
                }

                if(!candidate_message)
                {
                    $("#candidate_message_error").html("Please enter message to candidate");
                    $("#candidate_message").addClass("error");
                }
                else{
                    $("#candidate_message_error").html("");
                    $("#candidate_message").removeClass("error");
                }


                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#ajax-loader").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);


            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('SendNotificationToCandidate') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Candidate Notification Sent.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#notify-candidate")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#notify-candidate")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#ajax-loader").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#ajax-loader").hide();
                }
            });
        });
    });
    
</script>

<script>                
        $('#qualification').on('change blur', function () {
        //alert("Hi");
            var idQualification = this.value;
            var qualid = $('#qualification').val();
            if (idQualification==qualid) { 
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-candidate-list/" + idQualification,
                    data: { idQualification: idQualification },
                    success: function (data) { 
                            //alert("hi");
                            $("#dataTable").DataTable().destroy();
                            var trHTML = ''; 
                            $("#tBody").empty();    
                            var baseurl = "{{ url("employer/view-course") }}"; 

                            $.each(data.data.candidates, function (key, value) {    
                            //alert("Hi");         
                                var i = parseInt(key)+1;                
                                trHTML +=
                                    '<tr><td>'
                                    + value.name
                                    + '</td><td>'
                                    + value.building_name + value.landmark + value.postOffice + value.pincode
                                    + '</td><td>'
                                    + value.mobile_number
                                    + '</td><td>'
                                    + value.email
                                    + '</td><td>'
                                    + value.highest_qualification 
                                    +'</td><td>' 
                                    + "<a href='" + baseurl + '/' + btoa(value.training.id) + "' target='_blank'>" + value.training.training_name +  "</a>"
                                    + '</td></tr>';
                            
                             });
                            $('#tBody').append(trHTML);
                            $("#dataTable").DataTable();
                        },
                });
            } else {
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-candidate-list/" + idQualification,
                    data: { idQualification: idQualification },
                    success: function (data) { 
                            //alert("hi");
                            $("#dataTable").DataTable().destroy();
                            var trHTML = ''; 
                            $("#tBody").empty();    
                            var baseurl = "{{ url("employer/view-course") }}"; 

                            $.each(data.data.candidates, function (key, value) {    
                            //alert("Hi");         
                                var i = parseInt(key)+1;                
                                trHTML +=
                                    '<tr><td>'
                                    + value.name
                                    + '</td><td>'
                                    + value.building_name + value.landmark + value.postOffice + value.pincode
                                    + '</td><td>'
                                    + value.mobile_number
                                    + '</td><td>'
                                    + value.email
                                    + '</td><td>'
                                    + value.highest_qualification 
                                    +'</td><td>' 
                                    + "<a href='" + baseurl + '/' + btoa(value.training.id) + "' target='_blank'>" + value.training.training_name +  "</a>"
                                    + '</td></tr>';
                            
                             });
                            $('#tBody').append(trHTML);
                            $("#dataTable").DataTable();
                        },
   
                    });

                }  

            });

</script>

<script>                
        $('#Skill').on('change blur', function () {
        //alert("Hi");
            var idSkill = this.value;
            var skillid = $('#Skill').val();
            if (idSkill==skillid) { 
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-candidate-list-on-skills/" + idSkill,
                    data: { idSkill: idSkill },
                    success: function (data) { 
                            //alert("hi");
                            $("#dataTable").DataTable().destroy();
                            var trHTML = ''; 
                            $("#tBody").empty();    
                            var baseurl = "{{ url("employer/view-course") }}"; 

                            $.each(data.data.candidates, function (key, value) {    
                            //alert("Hi");         
                                var i = parseInt(key)+1;                
                                trHTML +=
                                    '<tr><td>'
                                    + value.name
                                    + '</td><td>'
                                    + value.building_name + value.landmark + value.postOffice + value.pincode
                                    + '</td><td>'
                                    + value.mobile_number
                                    + '</td><td>'
                                    + value.email
                                    + '</td><td>'
                                    + value.highest_qualification 
                                    +'</td><td>' 
                                    + "<a href='" + baseurl + '/' + btoa(value.training.id) + "' target='_blank'>" + value.training.training_name +  "</a>"
                                    + '</td></tr>';
                            
                             });
                            $('#tBody').append(trHTML);
                            $("#dataTable").DataTable();
                        },
                });
            } else {
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-candidate-list/" + idQualification,
                    data: { idQualification: idQualification },
                    success: function (data) { 
                            //alert("hi");
                            $("#dataTable").DataTable().destroy();
                            var trHTML = ''; 
                            $("#tBody").empty();    
                            var baseurl = "{{ url("employer/view-course") }}"; 

                            $.each(data.data.candidates, function (key, value) {    
                            //alert("Hi");         
                                var i = parseInt(key)+1;                
                                trHTML +=
                                    '<tr><td>'
                                    + value.name
                                    + '</td><td>'
                                    + value.building_name + value.landmark + value.postOffice + value.pincode
                                    + '</td><td>'
                                    + value.mobile_number
                                    + '</td><td>'
                                    + value.email
                                    + '</td><td>'
                                    + value.highest_qualification 
                                    +'</td><td>' 
                                    + "<a href='" + baseurl + '/' + btoa(value.training.id) + "' target='_blank'>" + value.training.training_name +  "</a>"
                                    + '</td></tr>';
                            
                             });
                            $('#tBody').append(trHTML);
                            $("#dataTable").DataTable();
                        },
   
                    });

                }  

            });

</script>

    

</body>

</html>