    
    @extends('candidates.layouts.app')

@section('title','Job Alerts')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Job Alerts </h1>
            
        </div>

        <div class="row">



      
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">

                 
            <!-- list -->
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Alert</th>
                                        <th>Job Title</th>
                                        <th>Job Description</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($job_alerts as $key=>$alert)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $alert->description  }}</td>
                                        <td>{{ $alert->Job->name }}</td>
                                        <td>
                                        {{   $alert->Job->description }}
                                       
                                        
                                        
                                        </td>
                                        
                                        <td>

                                            <a href="{{ route('candidateViewJobAlert',['notification'=>base64_encode($alert->id)]) }}" class="btn btn-info btn-circle btn-sm" title="View Job Alert">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                           
                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection