  
  @extends('candidates.layouts.app')

  
  
  @section('title','Training Training Courses')

  @section('content')
  
  <!-- Main Content -->

<!-- End of Topbar -->

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <!-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                class="fas fa-download fa-sm text-white-50"></i> Generate Report</a>
    </div> -->

    <!-- Content Row -->
    <div class="row">

        <!-- Total Count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/register.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['totalJobOpenings']))
   {{ $data['totalJobOpenings']}}@endif </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Total job openings</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- PIAs -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/tick.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['latestJobOpenings']))
   {{ $data['latestJobOpenings']}}@endif   </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Latest Job Openings</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Employers registered -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/recruitment.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['appliedJobs']))
   {{ $data['appliedJobs']}}@endif </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Applied jobs</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- Content Row -->

    <div class="row">
        <!-- list -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4">
                <div
                    class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">List of latest job openings</h6>
                    <a href="{{ route('candidateJobs') }}" class="font-weight-bold text-primary">View All >>></a>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Name of job Role</th>
                                    <th>Employer</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if (isset($data['listJobOpenings']))
                            @foreach ($data['listJobOpenings'] as $Job)
                                <tr>
                                    <td>{{$Job->job_name}}</td>
                                    <td>{{$Job->employer_name}}</td>
                                    <td>{{$Job->job_location}}</td>
                                </tr>
                            @endforeach 
                            @endif  
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->
            </div>
        </div>
        <!-- list -->
    </div>

</div>

@endsection