  


<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" />
    <meta name="description" content="Kudumbashree">
    <meta name="author" content="Kudumbashree">
    <title>@yield('title')</title>

    <!-- Custom fonts for this template-->
    <link href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
    <link href="{{ asset('vendor/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="{{ asset('css/kudumbashree.css') }}" rel="stylesheet">

   


</head>

<body id="page-top">


    <!-- Page Wrapper -->
    <div id="wrapper">

                     <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

            <!-- Sidebar - Brand -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{ route('candidates-dashboard') }}">
                <img src="{{ asset('img/logo.png') }}" title="Kudumbashree" class="img-responsive">
            </a>

            <!-- Divider -->
            <hr class="sidebar-divider my-0">

            <!-- Nav Item - Dashboard -->
            <li class="nav-item active">
                <a class="nav-link" href="{{ route('candidates-dashboard') }}">
                <i class="fas fa-fw fa-home"></i>
                    <span>Dashboard</span></a>
            </li>
            <!-- <li class="nav-item">
                <a class="nav-link" href="#">
                <i class="fas fa-fw fa-file-alt"></i>
                    <span>Courses</span></a>
            </li> -->
           
            <!-- Nav Item - Pages Collapse Menu -->

           
            <li class="nav-item">
                <a class="nav-link" href="{{ route('candidateJobs') }}">
                <i class="fas fa-fw fa-briefcase"></i>
                    <span>Jobs</span></a>
            </li>
         
           

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>

        </ul>
            <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

                       <!-- Topbar -->
                       <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

<!-- Sidebar Toggle (Topbar) -->
<button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
    <i class="fa fa-bars"></i>
</button>

<!-- Topbar Search -->
<!--<form
    class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
    <div class="input-group">
        <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..."
            aria-label="Search" aria-describedby="basic-addon2">
        <div class="input-group-append">
            <button class="btn btn-primary" type="button">
                <i class="fas fa-search fa-sm"></i>
            </button>
        </div>
    </div>
</form>-->

<!-- Topbar Navbar -->
<ul class="navbar-nav ml-auto">

    <!-- Nav Item - Search Dropdown (Visible Only XS) -->
    <li class="nav-item dropdown no-arrow d-sm-none">
        <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-search fa-fw"></i>
        </a>
        <!-- Dropdown - Messages -->
        <!--<div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
            aria-labelledby="searchDropdown">
            <form class="form-inline mr-auto w-100 navbar-search">
                <div class="input-group">
                    <input type="text" class="form-control bg-light border-0 small"
                        placeholder="Search for..." aria-label="Search"
                        aria-describedby="basic-addon2">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="button">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>-->
    </li>

    <!-- Nav Item - Alerts -->
    <!--<li class="nav-item dropdown no-arrow mx-1">
        <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-bell fa-fw"></i>
           
            <span class="badge badge-primary badge-counter">3+</span>
        </a>
       
        <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
            aria-labelledby="alertsDropdown">
            <h6 class="dropdown-header">
                Alerts Center
            </h6>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-primary">
                        <i class="fas fa-file-alt text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 12, 2019</div>
                    <span class="font-weight-bold">A new monthly report is ready to download!</span>
                </div>
            </a>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-success">
                        <i class="fas fa-donate text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 7, 2019</div>
                    $290.29 has been deposited into your account!
                </div>
            </a>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-warning">
                        <i class="fas fa-exclamation-triangle text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 2, 2019</div>
                    Spending Alert: We've noticed unusually high spending for your account.
                </div>
            </a>
            <a class="dropdown-item text-center small text-gray-500" href="#">Show All Alerts</a>
        </div>
    </li>-->
    <!--alert-->

    <div class="topbar-divider d-none d-sm-block"></div>

    @if(isset($data['notifications']))

                  <!-- Nav Item - Alerts -->
    <li class="nav-item dropdown no-arrow mx-1">
                <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-bell fa-fw"></i>
                    <!-- Counter - Alerts -->
                    <span class="badge badge-primary badge-counter">{{ $data['total_notifications'] }}</span>
                </a>

               
                <!-- Dropdown - Alerts -->
                <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
                    aria-labelledby="alertsDropdown">
                    <h6 class="dropdown-header">
                        Job Alerts
                    </h6>

                    @foreach($data['notifications'] as $notification)
                    <a class="dropdown-item d-flex align-items-center" target="blank" href="{{ route('candidateViewJobAlert',['notification'=>base64_encode($notification->id)]) }}"> 
                        <div class="mr-3">
                            
                                @if($notification->Job->attachment)
                                    <div style="overflow:hidden" class="bg-primary icon-circle">
                                     <img class="img img-responsive"  src="{{ asset('storage/job_vacancy_docs/'.$notification->Job->attachment)}}">
                                    </div>
                                @else
                                    <div class="icon-circle bg-primary">
                                        <i class="fas fa-file-alt text-white"></i>
                                    </div>
                                @endif
                            
                        </div>
                        <div>
                            <div class="small text-gray-500">{{ date('M d, Y') }}</div>
                           <span class="font-weight-bold">{{ $notification->description }}</span>
                        </div>
                    </a>

                    @endforeach
              
                    <a class="dropdown-item text-center small text-gray-500" href="{{ route('candidateJobAlerts') }}">Show All Alerts</a>
                </div>

              
    </li>
            <!--alert-->


    @else

    <li class="nav-item dropdown no-arrow mx-1">
                <a class="nav-link dropdown-toggle" href="{{ route('candidateJobAlerts') }}" id="alertsDropdown" role="button"
                     >
                    <i class="fas fa-bell fa-fw"></i>
                    <!-- Counter - Alerts -->
                   <!-- <span class="badge badge-primary badge-counter"></span>-->
                </a>

               
                <!-- Dropdown - Alerts -->
               
              
    </li>

    @endif

    <!-- Nav Item - User Information -->
    <li class="nav-item dropdown no-arrow">
        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <span class="mr-2 d-none d-lg-inline text-gray-600 small">{{ auth()->user()->name }} (@if(auth()->user()->user_role_id==1)
            Super admin
            @elseif(auth()->user()->user_role_id==2)
            District admin
            @elseif(auth()->user()->user_role_id==3)
            Block admin
            @elseif(auth()->user()->user_role_id==4)
            PIA

            @elseif(auth()->user()->user_role_id==5)
            Employer
            @elseif(auth()->user()->user_role_id==6)
            Candidates
            @endif
           
            )</span>
            <img class="img-profile rounded-circle" src="{{ asset('img/undraw_profile.svg') }}">
        </a>
        
        <!-- Dropdown - User Information -->
        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
            aria-labelledby="userDropdown">
           <a class="dropdown-item" href="{{ route('candidate-profile') }}">
                <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                Profile
            </a> <!--
            <a class="dropdown-item" href="#">
                <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                Settings
            </a>-->
            <div class="dropdown-divider"></div>
            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                Logout
            </a>
        </div>
    </li>

</ul>

</nav>

             @yield('content')

       

          <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Kudumbashree {{ date('Y') }}</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    

    

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">To continue to log out, please select the logout button.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="{{ url('/logout') }}">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
<script src="{{ asset('vendor/jquery/jquery.min.js') }}"></script>

     
   
    <script src="{{ asset('js/demo/datatables-demo.js') }}"></script>

 

    


    <script src="{{ asset('vendor/datatables/jquery.dataTables.js') }}"></script>

    <script>

        $(document).ready(function()
        {
            $("dataTable").DataTable();
        });
    </script>

    <script src="{{ asset('vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ asset('vendor/jquery-easing/jquery.easing.min.js') }}"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{ asset('js/kudumbashree.js') }}"></script>

    <!-- Page level plugins -->
    <script src="{{ asset('vendor/chart.js/Chart.min.js') }}"></script>

    <!-- Page level custom scripts -->
    <script src="{{ asset('js/demo/chart-area-demo.js') }}"></script>
    <script src="{{ asset('js/demo/chart-pie-demo.js') }}"></script>

    <script src="{{ asset('js/sweetalert.js') }}"></script>

    <script>

        $(document).ready(function()
        {

            
            $(document).on("change","#country",function()
            {
                var country=$(this).val();

                if(country!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadStates') }}",
                        type:"POST",
                        data:{country:country},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var states=response.states;

                                $("#state").html("");

                                $("#state").append("<option value=''>Choose State</option>");

                                states.forEach(function(state)
                                {
                                    $("#state").append("<option value='"+state.id+"'>"+state.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#state",function()
            {
                var state=$(this).val();

                if(state!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadDistricts') }}",
                        type:"POST",
                        data:{state:state},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var districts=response.districts;

                                $("#district").html("");

                                $("#district").append("<option value=''>Choose District</option>");

                                districts.forEach(function(district)
                                {
                                    $("#district").append("<option value='"+district.id+"'>"+district.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#district",function()
            {
                var district=$(this).val();

                if(district!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadBlocks') }}",
                        type:"POST",
                        data:{district:district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var blocks=response.blocks;

                                $("#block").html("");

                                $("#block").append("<option value=''>Choose Block</option>");

                                blocks.forEach(function(block)
                                {
                                    $("#block").append("<option value='"+block.id+"'>"+block.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("submit","#submit_pia_details",function(e)
            {

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                form_data.append('attachment',$(this)[0].files);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('submitPIADetails') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("PIA added",response.message,"success");

                            $("#submit_pia_details")[0].reset();

                           
                            $("#ajax-loader").hide();
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            
            $(document).on("submit","#update_pia_details",function(e)
            {

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                form_data.append('attachment',$(this)[0].files);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('updatePIADetails') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("PIA updated",response.message,"success");

                            $("#update_pia_details")[0].reset();

                            location.reload();

                           
                            $("#ajax-loader").hide();
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            $(document).on("click",".deactivate-pia",function()
            {
                var pia=$(this).data('pia-id');

                Swal.fire({
                    title: "Are you sure to deactivate agency?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivatePIA') }}",
                            type:"POST",
                            data:{pia:pia},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire("Decativated",response.message, "success");
                                location.reload();
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Agency is safe", "", "info");
                    }
                });
            });
        });

    </script>

    <script>

        $(document).ready(function()
        {
            $(document).on("click",".apply-job",function()
            {
                var job=$(this).data('job');

               

                Swal.fire({
                    title: "Are you sure to apply for this job?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('candidateApplyJob') }}",
                            type:"POST",
                            data:{job:job},
                            dataType:"JSON",
                            success:function(response)
                            {

                                $("#plwait").hide();
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "Job application submitted successfully",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_admin_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Job Application cancelled", "", "info");
                    }
                });

           
            });
        });


    </script>

<script>

$(document).ready(function()
{
    $(document).on("submit","#change_password_form",function(e)
    {
        e.preventDefault();

        var old_password=$("#old_password").val();
        var new_password=$("#new_password").val();
        var confirm_password=$("#confirm_password").val();

        var form_data=new FormData($(this)[0]);

        
        if(old_password)
            {

                
                var old_password=$("#old_password").val();

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token()}}"},
                    url:"{{ route('checkCurrentPassword') }}",
                    type:"POST",
                    data:{password:old_password},
                    dataType:"JSON",
                    success:function(response)
                    {
                        if(response.password_match_status==0)
                        {
                            $("#old_password_error").html("Current password is invalid");
                            $("#old_password").addClass("error");

                        }

                        else{

                            $("#old_password_error").html("");
                            $("#old_password").removeClass("error");

                        }
                    },
                    error:function()
                    {

                    }
                });

            }

        if(!old_password || !new_password || !confirm_password)
        {
            Swal.fire("error","Please fill all mandatory fields","error");

            if(!old_password)
            {
                $("#old_password_error").html("Enter old password");
                $("#old_password").addClass("error");
            }

            if(!new_password)
            {
                $("#new_password_error").html("Enter new password");
                $("#new_password").addClass("error");
            }

            if(!confirm_password)
            {
                $("#confirm_password_error").html("Enter confirm password");
                $("#confirm_password").addClass("error");
            }

           
        }
        

        else if(old_password && confirm_password && new_password){

            if(confirm_password!=new_password){
                    
                    $("#confirm_password_error").html("New password and confirm password do not match");


            }else if(old_password==new_password){
                $("#confirm_password_error").html("New password cannot be the same as the old password!");
                $("#new_password").addClass("error");

            }else if(old_password==confirm_password){
                $("#confirm_password_error").html("Confirm password cannot be the same as the old password!");
                $("#confirm_password").addClass("error");

            }
            else{

                $.ajax({

                    url:"{{ route('changePassword') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("Success",response.message,"success").then(function(result)
                            {
                                if(result.isConfirmed)
                                {
                                    window.location.reload();
                                }
                            });

                            
                        }

                        else{

                            Swal.fire("Error",response.message,"error");


                        }
                    },
                    error:function()
                    {
                        Swal.fire("error","Something went wrong","error");
                    }
                });


            }


        }

    });

    $(document).on("keyup","#old_password",function()
    {
        $("#old_password").removeClass("error");
        $("#old_password_error").html("");
    });

    $(document).on("keyup","#new_password",function()
    {
        $("#new_password").removeClass("error");
        $("#new_password_error").html("");
    });

    $(document).on("keyup","#confirm_password",function()
    {
        $("#confirm_password").removeClass("error");
        $("#confirm_password_error").html("");
    });
});


</script>

<script>



function togglePasswordVisibilityOldPassword()
{
var old_password=document.getElementById("old_password");

if(old_password.type=="text")
{
    $("#old_password").attr("type","password");
}

else{

    $("#old_password").attr("type","text");
}
}

function togglePasswordVisibilityNewPassword()
{
var new_password=document.getElementById("new_password");

if(new_password.type=="text")
{
    $("#new_password").attr("type","password");
}

else{

    $("#new_password").attr("type","text");
}
}

function togglePasswordVisibilityConfirmPassword()
{
var confirm_password=document.getElementById("confirm_password");

if(confirm_password.type=="text")
{
    $("#confirm_password").attr("type","password");
}

else{

    $("#confirm_password").attr("type","text");
}
}


</script>
    
<script>

$(document).on("click",".deactivate-candidate",function()
            {
                var candidate=$(this).data('candidate');
                //alert(candidate);

                Swal.fire({
                    title: "Are you sure to delete the profile?",
                    showDenyButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('DeactivateCandidateProfile') }}",
                            type:"GET",
                            data:{candidate:candidate},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "Account has been deleted successfully!",  
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
         
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Your Acccount is safe", "", "info");
                    }
                });
            });

</script>

</body>

</html>