    
    @extends('candidates.layouts.app')

@section('title','Applied Jobs')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Jobs Applied </h1>
           
            <a href="{{ route('candidateJobs') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Jobs</a>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">

                  
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Job</th>
                                        <th>Job Code</th>
                                        <th>Skills</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($jobs as $key=>$job)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $job->Job->name  }}</td>
                                        <td>{{ $job->Job->code }}</td>
                                        <td>
                                            @foreach($job->Job->SkillList as $key=>$skill)

                                                @if($key==0)

                                                {{ $skill->Skill->name }}

                                                @else

                                                ,{{ $skill->Skill->name }}

                                                @endif

                                            @endforeach
                                        </td>
                                        <td>{{ $job->Job->description }}</td>
                                        <td>

                                           {{ $job->application_status}}<br>

                                           @if($job->application_status == "Applied")
                                           
                                           {{ date('d M Y h:i:s a',strtotime($job->applied_at)) }}<br>
                                           @endif

                                           @if($job->application_status == "Shortlisted")

                                           {{ date('d M Y h:i:s a',strtotime($job->shortlisted_at)) }}<br>

                                           @endif

                                           @if($job->application_status == "Placed")

                                            {{ date('d M Y h:i:s a',strtotime($job->placed_at)) }}<br>

                                            @endif

                                           @if($job->application_status == "Rejected")

                                           {{ date('d M Y h:i:s a',strtotime($job->rejected_at)) }}                            
                                        
                                           @endif

                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection