@extends('admin.layouts.app')

@section('title','Course Master List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Skills List </h1>
            <a href="{{ route('createSkill') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> New Skill</a>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Skill</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($Skills as $key=>$skill)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $skill->name  }}</td>
                                                                             
                                        <td>

                                            <!-- <a href="{{ route('viewSkill',['Skill'=>base64_encode($skill->id)]) }}" class="btn btn-info btn-circle btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a> -->

                                               
                                                   @if($skill->is_active==1)
                                                        <a href="{{ route('editSkill',['Skill'=>base64_encode($skill->id)]) }}" class="btn btn-success btn-circle btn-sm">
                                                            <i class="fas fa-pen"></i>
                                                        </a>

                                                    @endif

                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection