@extends('admin.layouts.app')

@section('title','Sector List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">SectorList </h1>
            <a href="{{ route('adminAddSector') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> New Sector</a>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Sector Name</th>
                                        <th>Sector Code</th>
                                       
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($sector_details as $key=>$sector)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $sector->name  }}</td>
                                        <td>{{ $sector->code  }}</td>
                                        
                                        <td>

                                    
                                           
                                            <a href="{{ route('adminEditSector',['sector'=>base64_encode($sector->id)]) }}" class="btn btn-success btn-circle btn-sm">
                                                <i class="fas fa-pen"></i>
                                            </a>
                                            
                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection