   
   @extends('admin.layouts.app')


@section('title','Add Sector')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Add Sector</h1>
     <a href="{{ route('sectorList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i>Sector List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="update_sector_details" action="post" method="{{ route('adminAddSector') }}">
                     <div class="row">

                       @csrf

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Sector Name<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" value="{{ $sector->name }}" name="sector_name" id="sector_name"
                                     placeholder="Name" maxlength="80">
                                 <span id="sector_name_error" style="color:red"></span>
                             </div>
                         </div>

                         <input  type="hidden" name="sector" value="{{ base64_encode($sector->id) }}">


                    </div>
                    <div class="row">

                      

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Code<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="sector_code" value="{{ $sector->code }}" id="sector_code"
                                     placeholder="Code" maxlength="3">
                                 <span id="sector_code_error" style="color:red"></span>
                             </div>
                         </div>


                    </div>
                     <div class="row">
                         <div class="col-md-6">
                             <hr>
                             <span style="color:red" id="response_message"></span>
                             <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in
                         progress</div>
                             <button type="submit" class="btn btn-primary">Submit</button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection