    
@extends('admin.layouts.app')

@section('title','Training Report')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Training Report</h1>
        
        </div>

        <div class="row">



       

            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                    
 <!--form-->
            <form  id="generate_report" target="_blank" action="{{ route('generateTrainingProgramReport') }}">
                    <div class="row justify-content-center">
                    @csrf
                                <div class="col-md-4">

                                        <div class="form-group">
                                            <label for="district_filter">District<span style="color:red;">*</span></label>
                                            <select id="district_filter" name="district_filter" class="form-control">

                                                <option value="">All Districts</option>

                                                @foreach($districts as $key=>$district)

                                                    <option value="{{ $district->id }}">{{ $district->name }}</option>
                                                @endforeach

                                            </select>

                                        </div>
                                    </div>

                           <!-- <div class="form-group">-->

                                    <div class="col-md-4">

                                        <div class="form-group">
                                            <label for="pia_filter">PIA<span style="color:red;">*</span></label>
                                            <select id="pia_filter" name="pia_filter" class="form-control">

                                                <option value="">All PIAs</option>

                                                @foreach($pia_list as $key=>$pia)

                                                    <option value="{{ $pia->id }}">{{ $pia->agency_name }}</option>
                                                @endforeach

                                            </select>
                                        </div>
                                    </div>

                               
                        </div>
                        <div class="row justify-content-center">
                                    <div class="col-md-8">

                                        <div class="form-group">
                                            <label for="course_master_filter">Course<span style="color:red;">*</span></label>
                                            <select id="course_master_filter" name="course_master_filter" class="form-control">

                                                <option value="">All Courses</option>

                                                @foreach($course_masters as $key=>$course_master)

                                                    <option value="{{ $course_master->id }}">{{ $course_master->tradename }}</option>
                                                @endforeach

                                                </select>

                                        </div>
                                    </div>

                            <!-- </div>-->

                        </div>
                        <hr>
                        <div class="row">

                                        <div class="col-md-push-1 col-12 text-center">


                                            <div class="form-group">

                                            
                                                <button type="submit" class="btn btn-primary text-right" style="" name = "action" value = "generate_traning_pdf_report" id="generate_traning_pdf_report">Generate PDF Report</button>
                                                <button type="submit" class="btn btn-primary text-right" style="" name = "action"  value = "generate_traning__csv_report" id="generate_traning__csv_report">Generate CSV Report</button>
                                            </div>

                                        </div>


                         </div>
            </form>
            </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

</div>
<script>
$(document).ready(function(){
    $(document).ready(function()
      {
           $(document).on("change","#generate_report #district_filter",function()
           {

               var district=$(this).val();

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('getPiaCourseByDistrict') }}",
                        type:"POST",
                        data:{"district":district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var pias=response.pias;
                                var courses=response.courses;

                                $("#pia_filter").html("");
                                $("#course_master_filter").html("");

                                $("#pia_filter").append("<option value=''>All Pias</option>");
                                $("#course_master_filter").append("<option value=''>All Courses</option>");

                                pias.forEach(function(pia)
                                {
                                    $("#pia_filter").append("<option value='"+pia.id+"'>"+pia.agency_name+"</option>");
                                });
                                courses.forEach(function(course)
                                {
                                    $("#course_master_filter").append("<option value='"+course.id+"'>"+course.training_name+"</option>");
                                });
                           }
                        }
                    });


           });
      });
});
</script>
@endsection