    
@extends('admin.layouts.app')

@section('title','PIA Report')

@section('content')

           
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h4 mb-0 text-gray-800">Reports</h1>
                    </div>

                    <div class="row">

                       @if(Session::has('error'))

                          <div class="alert alert-danger">

                             {{ Session::get('error') }}

                           </div>

                           

                       @endif
                        <!-- Add -->
                        <div class="col-xl-12 col-lg-7">
                            <div class="card shadow mb-4">
                                <!-- Card Body -->
                                <div class="card-body">

                                    <!--form-->
                                    <form  id="generate_report" target="_blank" action="{{ route('adminPiaReportGenerateReport') }}">
                                        
                                        <div class="row justify-content-center">

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="">PIA</label>
                                                    <select class="form-control" id="pia_filter" name="pia_filter">
                                                        <option value="">All PIAS</option>
                                                        @foreach($pia_list as $key=>$pia)
                                                            <option value="{{ base64_encode($pia->id) }}">{{ $pia->agency_name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="">Sector</label>
                                                    <select class="form-control" id="sector_filter" name="sector_filter">
                                                        <option value="">All Sectors</option>
                                                        @foreach($sectors as $sector)
                                                        <option value="{{ base64_encode($sector->id) }}">{{ $sector->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
             
                                        <div class="row justify-content-center">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    <label for="">Course</label>
                                                    <select class="form-control" id="course_filter" name="course_filter">
                                                        <option value="">All Courses</option>
                                                        @foreach($course_masters as $course_master)
                                                        <option value="{{ base64_encode($course_master->id) }}">{{ $course_master->tradename }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="report_type">
                                        <div class="row">
                                            <div class="col-12 text-right">
                                                <hr>
                                                <button type="submit" class="btn btn-primary generate-report"  id="pdf_report"><i
                                                    class="fas fa-fw fa-file-pdf fa-sm text-white-50"></i> Generate PDF</button>
                                                    <button type="submit" class="btn btn-primary generate-report" id="csv_report"><i
                                                    class="fas fa-download fa-sm text-white-50"></i> Generate CSV</button>
                                            </div>
                                        </div>

                                    </form>
                                    <!--form-->

                                </div>
                                <!-- Card Body -->
                            </div>
                        </div>
                        <!-- Add -->
                    </div>

                </div>

           @endsection