   
   @extends('admin.layouts.app')


@section('title','View PIA')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $pia->agency_name }} Details</h1>
     <a href="{{ route('piaList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> PIA List</a>
                     
 </div>

 <div class="row">
     <!-- Add -->
     
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
         
             <!-- Card Body -->
             <div class="card-body">
             
                 <!--form-->
                
                     <div class="row">
                    
                     <div class="row">
                     <div class="col-md-12">
                             <div class="form-group">
                             <a href="{{ url()->previous() }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Back to List</a>
</div>
</div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Agency Name</b></label><br>
                                 {{ $pia->agency_name  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Building Number</b></label><br>
                                {{ $pia->building_number }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Street Name</b></label><br>
                                {{ $pia->street_name  }}
                             </div>
                         </div>
                        

                       

                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>State</b></label><br>
                                 <div class="form-group">
                                    {{ $pia->State->name }}
                                 </div>
                                 
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>District</b></label><br>
                                 <div class="form-group">
                                    {{ $pia->District->name }}
                                 </div>
                                 
                             </div>
                         </div>

                        
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Phone Number</b></label><br>
                                {{ $pia->phone_number }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Mobile Number</b></label><br>
                                {{ $pia->mobile_number }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>PAN Number</b></label><br>
                                 {{ $pia->pan_number }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Post Office</b></label><br>
                                 {{ $pia->post_office }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Pincode</b></label><br>
                                 {{ $pia->pincode }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Course Assigned Location</b></label><br>
                                 {{ $pia->course_assigned_location }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email Id</b></label><br>
                                {{ $pia->email }}
                             </div>
                         </div>

                         @if($pia->attachment)

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Supporting Document</b></label><br>
                                
                                    
                                   
                                     <a href="{{ asset('storage/pia_docs/'.$pia->attachment)}}" target="_blank" >Click Here to view document</a>
                                   
                             </div>
                         </div>

                         @endif

                         <div class="col-md-12">
                             <div class="form-group">
                                 <label for=""><b>Sector</b></label><br>
                                 <div class="form-group">

                                     @foreach($pia->Sectors as $key=>$sector)

                                     @if($key==0)
                                     {{ $sector->Sector->name }}
                                     @else
                                     ,{{ $sector->Sector->name  }}
                                     @endif
                                     @endforeach
                                 </div>
                                 
                             </div>
                         </div>
                         <div class="col-md-12">
    <div class="form-group">
        <label for=""><b>Trade</b></label><br>
        <div class="form-group">
            @if($pia->Trade_names())
                {{ $pia->Trade_names() }}
            @else
                <p>No trades available.</p>
            @endif
        </div>
    </div>
</div>





                     </div>
                    
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection