    
    @extends('admin.layouts.app')

    @section('title','PIA List')

    @section('content')


     

        <!-- Begin Page Content -->
        <div class="container-fluid">


            <!-- Page Heading -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h4 mb-0 text-gray-800">PIA List </h1>
                <a href="{{ route('createPIA') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                        class="fas fa-add fa-sm text-white-50"></i> Create New</a>
            </div>

            <div class="row">



          
                <div class="col-xl-12 col-lg-7">
                    <div class="card shadow mb-4 min_500">
                        <!-- Card Body -->
                        <div class="card-body">

                      @if(auth()->user()->user_role_id==1)  <a href="{{ route('adminBlockedPiaList') }}" class="d-none d-sm-inline-block btn btn-sm btn-danger shadow-sm"><i
                        class="fas fa-add fa-sm text-white-50"></i>Blocked PIA List</a><br><br>@endif
                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in
                            progress</div>
                <!-- list -->
                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="dataTable">
                                    <thead>
                                        <tr>
                                            <th>Sl.No</th>
                                            <th>Agency</th>
                                            <th>Email</th>
                                            <th>District</th>
                                           
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                    @foreach($pia_list as $key=>$pia)
                                        <tr>
                                            <td>{{ ($key+1) }}</td>
                                            <td>{{ $pia->agency_name  }}</td>
                                            <td>{{ $pia->email }}</td>
                                            <td>
                                            {{   $pia->District->name }}
                                           
                                            
                                            
                                            </td>
                                            
                                            <td>

                                                <a href="{{ route('viewPIA',['pia'=>base64_encode($pia->id)]) }}" class="btn btn-info btn-circle btn-sm" title="View PIA">
                                                    <i class="fas fa-eye"></i>
                                                </a>

                                                @if(auth()->user()->user_role_id==1)
                                                   @if($pia->is_active==1)
                                                    <a href="{{ route('editPIA',['pia'=>base64_encode($pia->id)]) }}" class="btn btn-success btn-circle btn-sm" title="Edit PIA">
                                                        <i class="fas fa-pen"></i>
                                                    </a>

                                                    @endif
                                                @if($pia->is_active==1)
                                                        <a href="#" class="deactivate-pia" data-pia-id="{{ base64_encode($pia->id ) }}" title="Deactivate PIA">

                                                        <img src="{{ asset('img/CLOSE.svg') }}">

                                                        </a>

                                                @elseif($pia->is_active==11)

                                                <a href="#" class="reactivate-pia" data-pia-id="{{ base64_encode($pia->id ) }}" title="Reactivate PIA">
                                                <img src="{{ asset('img/ACTIVATE.svg') }}">
                                                        </a>

                                                @endif

                                                @elseif(auth()->user()->user_role_id==3)

                                                   @if(auth()->user()->id==$pia->created_by)

                                                   <a href="{{ route('editPIA',['pia'=>base64_encode($pia->id)]) }}" class="btn btn-success btn-circle btn-sm" title="Edit PIA">
                                                        <i class="fas fa-pen"></i>
                                                    </a>

                                                    @if($pia->is_active==1)
                                                    <a href="#" class="deactivate-pia" data-pia-id="{{ base64_encode($pia->id ) }}" title="Deactivate PIA">

                                                        <img src="{{ asset('img/CLOSE.svg') }}">

                                                    </a>
                                                    @endif


                                                   @endif

                                               
                                                @elseif(auth()->user()->user_role_id==2)

                                                    @if(auth()->user()->id==$pia->created_by)

                                                    <a href="{{ route('editPIA',['pia'=>base64_encode($pia->id)]) }}" class="btn btn-success btn-circle btn-sm" title="Edit PIA">
                                                        <i class="fas fa-pen"></i>
                                                    </a>
                                                    @if($pia->is_active==1)
                                                    <a href="#" class="deactivate-pia" data-pia-id="{{ base64_encode($pia->id ) }}" title="Deactivate PIA">

                                                        <img src="{{ asset('img/CLOSE.svg') }}">

                                                        </a>
                                                    @endif

                                                    @endif

                                                @endif
                                            </td>
                                        </tr>

                                    @endforeach
                                       
                                        
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- Card Body -->
                    </div>
                </div>
                <!-- list -->
            </div>

        </div>
        <!-- /.container-fluid -->

    <!--</div>-->

    @endsection