   
   @extends('admin.layouts.app')


   @section('title','Add PIA')


   @section('content')
   
  

<!-- Begin Page Content -->
<div class="container-fluid">

           

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h4 mb-0 text-gray-800">Add Program Implementation Agency</h1>
        <a href="{{ route('piaList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                        class="fas fa-add fa-sm text-white-50"></i> PIA List</a>
    </div>

    <div class="row">
        <!-- Add -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">
                <!-- Card Body -->
                <div class="card-body">

                    <!--form-->
                    <form id="submit_pia_details" action="post" method="{{ route('submitPIADetails') }}">
                        <div class="row">

                          @csrf

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Agency Name<span style="color:red">*</span></label>
                                    <input type="text" class="form-control" name="agency_name" id="agency_name"
                                        placeholder="Agency Name" maxlength="50">
                                    <span id="agency_name_error" style="color:red"></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Building Number/Name<span style="color:red">*</span></label>
                                    <input type="text" id="building_number" maxlength="50" name="building_number" class="form-control" placeholder="Building Number" >
                                    <span id="building_number_error" style="color:red;"></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Street, Landmark<span style="color:red">*</span></label>
                                    <input type="text" id="street_name" maxlength="50" name="street_name" class="form-control" placeholder="Street Name">
                                    <span id="street_name_error" style="color:red;"></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Sector<span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                        
                                        <select name="sector[]" class="chosen-select" id="sectordropdown" title="Select Sector" multiple >
                                            <!--<option value="">Choose Sector</option>-->
                                            @foreach($sectors as $sector)
                                                <option value="{{ $sector->id }}">{{ $sector->name }}</option>
                                            @endforeach
                                        </select>
                                            
                                        <span id="sectordropdown_error" style="color:red;"></span>
                                    </div>
                                    
                                </div>
                            </div>
                             <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Trade<span style="color:red;">*</span></label><br>
                                <div class="form-group">
                                    <select name="trade[]" class="chosen-select" id="Tradedropdown"  title="Select Trade" multiple>
                                        <option value="">Select Sector First</option>
                                    </select>
                                    <span id="tradedropdown_error" style="color:red;"></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Course Assigned Location<span style="color:red">*</span></label>
                                    <input type="text" class="form-control" name="course_assigned_location" id="course_assigned_location"
                                        placeholder="Course Assigned Location" maxlength="250">
                                    <span id="course_assigned_location_error" style="color:red"></span>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">State<span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                        <select name="state" class="form-control" id="state" >
                                            <option value="">Choose State</option>

                                            @foreach($states as $state)
                                                <option value="{{ $state->id }}">{{ $state->name }}</option>
                                            @endforeach
                                        </select>
                                        <span id="state_error" style="color:red;"></span>
                                    </div>
                                    
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">District<span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                        <select name="district" class="form-control" id="district" >
                                            <option value="">Choose District</option>
                                        </select>
                                        <span id="district_error" style="color:red;"></span>
                                    </div>
                                    
                                </div>
                            </div>

                            

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Phone Number</label>
                                    <input type="tex" class="form-control" maxlength="12" id="phone_number" name="phone_number" placeholder="Phone Number" maxlength="12" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                    <span id="phone_number_error" style="color:red"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Mobile Number<span style="color:red">*</span></label>
                                
                                    <input type="text" id="mobile_number" class="form-control"  name="mobile_number"  placeholder="Mobile Number" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                    <span style="color:red" id="mobile_number_error"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">PAN Number<span style="color:red">*</span></label>
                                    <input type="text" id="pan_number" class="form-control" name="pan_number" 
                                        placeholder="PAN Number" maxlength="10">

                                    <span id="pan_number_error" style="color:red"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Post Office<span style="color:red">*</span></label>
                                    <input type="text" id="post_office" maxlength="25" name="post_office" class="form-control"  placeholder="Post Office" >
                                    <span id="post_office_error" style="color:red"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Pincode<span style="color:red">*</span></label>
                                    <input type="text" id="pincode" class="form-control" maxlength="6" name="pincode" 
                                        placeholder="PINCODE"  oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                    <span id="pincode_error" style="color:red"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Email Id<span style="color:red">*</span></label>
                                    <input type="email" class="form-control" name="email" id="email"
                                        placeholder="Email Id" maxlength="50">
                                        <span id="email_error" style="color:red"></span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Supporting Document</label>
                                    <input type="file" class="form-control" id="pia_doc" name="attachment" accept=".pdf" >
                                    <small>(Max size: 2 MB)</small>
                                    <br>
                                        <span id="errorMessage">Only Pdf documents of maximum size of 2MB allowed</span>
                                        
                                </div>
                            </div>

                            



                        </div>
                        <div class="row">
                            <div class="col-12 text-right">
                                <hr>
                                <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in
                            progress</div>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>

                    </form>
                    <!--form-->

                </div>
                <!-- Card Body -->
            </div>
        </div>
        <!-- Add -->
    </div>

</div>
<!-- /.container-fluid -->


<script>
    $(document).ready(function () {
        
        $('#Tradedropdown').multiselect({
            nonSelectedText: 'Select Trade',
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            buttonWidth: '100%'
        });

       
        $('#sectordropdown').on('change', function () {
            var sectorIds = $(this).val(); 

            if (sectorIds) {
                $.ajax({
                    url: "{{ route('getTradesBySector') }}",
                    type: "GET",
                    data: { sector_ids: sectorIds },
                    success: function (data) {
                        $('#Tradedropdown').empty(); 
                        if (data.length > 0) {
                            $.each(data, function (index, trade) {
                                $('#Tradedropdown').append(
                                    `<option value="${trade.id}">${trade.tradename}</option>`
                                );
                            });
                            $('#Tradedropdown').multiselect('rebuild'); 
                        } else {
                            $('#Tradedropdown').append(
                                '<option value="">No Trades Available</option>'
                            );
                            $('#Tradedropdown').multiselect('rebuild'); 
                        }
                    },
                    error: function () {
                        alert('Error fetching trades. Please try again.');
                    }
                });
            } else {
                $('#Tradedropdown').html('<option value="">Select Sector First</option>');
                $('#Tradedropdown').multiselect('rebuild');
            }
        });
    });
</script>


@endsection