    
    @extends('admin.layouts.app')

@section('title','Admin List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">List of ongoing courses</h1>
            <a href="{{ route('dashboard') }}" class="font-weight-bold text-primary"><<< Back</a>
        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                           
                        <table class="table table-striped table-hover" id="dataTable">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Name of Course</th>
                                    <th>District</th>
                                    <th>PIA</th>
                                    <th>No.of students Joined</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if (isset($data['trainigs']))
                            @foreach ($data['trainigs'] as $key=>$trainig)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{$trainig->training_name}}</td>
                                    <td>{{$trainig->district_name}}</td>
                                    <td>{{$trainig->agency_name}}</td>
                                    <td>{{$trainig->total_students}}</td>
                                </tr>
                            @endforeach 
                            @endif  
                            </tbody>
                        </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection