  
  @extends('admin.layouts.app')

  
  
  @section('title','Training Training Courses')

  @section('content')
  
  <!-- Main Content -->

<!-- End of Topbar -->

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <!-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                class="fas fa-download fa-sm text-white-50"></i> Generate Report</a>
    </div> -->

    <!-- Content Row -->
    <div class="row">

        <!-- Total Count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/CandidatesRegistered.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark"> @if (isset($data['candidatesCount']))
   {{ $data['candidatesCount']}}@endif </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No.of Candidates - registered</div>
                        </div> 
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/CourseCompleted.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['candidatesCountCompleted']))
   {{ $data['candidatesCountCompleted']}}@endif   </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No.of Candidates - Course Completed</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/CandidatesPlaced.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['candidatesCountPlaced']))
   {{ $data['candidatesCountPlaced']}}@endif  </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No.of Candidates - placed</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

                <!-- Courses count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/TrainingProgramTotal.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['trainig_total_count']))
   {{ $data['trainig_total_count']}}@endif   </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No.of Training Programs - Total</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Courses count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/TrainingProgrmOngoing.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['trainig_ongoing_count']))
   {{ $data['trainig_ongoing_count']}}@endif </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No.of Training Programs - On going</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Courses count -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/TrainingProgramCompleted.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['trainig_completed_count']))
   {{ $data['trainig_completed_count']}}@endif   </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No.of Training Programs - Completed</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- PIAs -->
        <div class="col-xl-6 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/PIASOverall.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['piasCount']))
   {{ $data['piasCount']}}@endif   </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No. of PIAs {{( isset($data['widget_info_district']) )? "( overall )":""}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Employers registered -->
        <div class="col-xl-6 col-md-6 mb-4">
            <div class="card shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col-4">
                            <img src="{{ asset('img/EmployersRegistered.svg') }}" height="60">
                        </div>
                        <div class="col mr-2 text-center">
                            <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['employersCount']))
   {{ $data['employersCount']}}@endif   </div>
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            No. of Employers - registered {{( isset($data['widget_info_district']) )? "( overall )":""}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- Content Row -->

    <div class="row">
        <!-- list -->
        <div class="@if (auth()->user()->user_role_id == 1) {{'col-xl-6'}} @endif col-lg-12">
            <div class="card shadow mb-4" style="min-height:94%">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">

                    <h6 class="m-0 font-weight-bold text-primary">List of ongoing courses</h6>
                    <a href="{{ route('training_list') }}" class="font-weight-bold text-primary">View All >>></a>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Name of Course</th>
                                    <th>District</th>
                                    <th>PIA</th>
                                    <th>No.of students Joined</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if (isset($data['trainigs']))
                            @foreach ($data['trainigs'] as $key=>$trainig)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{$trainig->training_name}}</td>
                                    <td>{{$trainig->district_name}}</td>
                                    <td>{{$trainig->agency_name}}</td>
                                    <td>{{$trainig->total_students}}</td>
                                </tr>
                            @endforeach 
                            @endif  
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->
            </div>
        </div>
        <!-- list -->
        @if (auth()->user()->user_role_id == 1)
         <canvas id="students_chart" class="col-xl-6 col-lg-12 card shadow mb-4" width="700" height="370"></canvas>
         @endif
    </div>


</div>
@if (auth()->user()->user_role_id == 1)
<script>
    aDatasets1 = [@foreach ($data['month_user_registered'] as $month)
        @php
        echo "'".$month."', ";
        @endphp
             @endforeach];
aDatasets2 = [@foreach ($data['month_user_placed'] as $month)
        @php
        echo "'".$month."', ";
        @endphp
             @endforeach];
var ctx = document.getElementById("students_chart");
var myChart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: [@foreach ($data['month_year'] as $month)
        @php
        echo "'".$month."', ";
        @endphp
             @endforeach],
        
        datasets: [ {
              label: 'Registered',
              fill:false,
            data: aDatasets1,
            backgroundColor: '#E91E63',
            borderColor: [
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
            ],
            borderWidth: 1
        },
        
        {
            label: 'Placed',
              fill:false,
            data: aDatasets2,
            backgroundColor: 
                '#3F51B5'
            ,
            borderColor: [
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
                'rgba(255,99,132,1)',
            ],
            borderWidth: 1
        },
        
        ]
    },
    options: {
        scales: {
            yAxes: [{
                ticks: {
                    beginAtZero:true
                }
            }]
        },
        title: {
            display: true,
            text: 'Monthly Report of Students'
        },
        responsive: true,
        
       tooltips: {
            callbacks: {
                labelColor: function(tooltipItem, chart) {
                    return {
                        borderColor: 'rgb(255, 0, 20)',
                        backgroundColor: 'rgb(255,20, 0)'
                    }
                }
            }
        },
        legend: {
            labels: {
                // This more specific font property overrides the global property
                fontColor: 'red',
               
            }
        }
    }
});

</script>
@endif
@endsection