@extends('admin.layouts.app')
@section('title','Admin List')
@section('content') 

    <!-- Begin Page Content -->
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">New Candidate List from the Public Site  </h1>                  
        </div>
        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                     <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="dataTable">
                            <thead>                                
                             <!-- <tr><td colspan="6"> <h3>Candidate List</h3></td></tr> -->
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Candidate Name</th>
                                    <th>Email Id</th>
                                    <th>Contact Number</th>
                                    <th>Category</th>
                                  
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                        @if($data['candidates'])
                            @foreach($data['candidates'] as $candidate)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{$candidate->name}}</td>
                                    <td>{{$candidate->email}}</td>
                                    <td>{{$candidate->mobile_Number}}</td>
                                    <td>{{$candidate->category}}</td>
                                 
                                    <td> 
                                                    <a href="#" class="btn btn-danger btn-circle btn-sm deactivate-candidate" data-candidate-id="{{ base64_encode($candidate->id) }}" title="deactivate">
    <img src="{{ asset('img/CLOSE.svg') }}">
</a>

                                <a href="{{ url('admin/candidateListDet') }}/{!! base64_encode('candi')!!}/{!! base64_encode($candidate->id)!!}"  class="btn btn-info btn-circle btn-sm" title="View Details">  <i class="fas fa-eye"></i></a></td>
                                </tr>       
                                @php $i = $loop->iteration; @endphp
                            @endforeach 
                        @endif                          
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->  
                </div>
            </div>
            <!-- list -->
        </div>
    </div>
    <!-- /.container-fluid -->
<!--</div>-->
@endsection