@extends('admin.layouts.app')
@section('title','View Candidate')
@section('content')
<!-- Begin Page Content -->
<div class="container-fluid">        


 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $Candidate->name }}'s Details</h1>
     <a href="{{ route('candidatejoinedList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Candidates Joined List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">
             <div style="text-align: right;">
                    
                    <span class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-sm text-white-50"></i>Profile Status: 
                    @foreach($statuses as $val)
                                   @if($val['id'] == $Candidate->profile_status)
                                      {{ $val['name'] }}
                                   @endif
                               @endforeach
                    </span>
                    
</div><br/>
                 <!--form--> 
                 @if($type=='candi')
                    <form id="AssignCourse" action="{{ url('admin/deactivate_user') }}/{!! base64_encode('candi')!!}" method="post">
                 @else
                     <form id="AssignCourse" action="{{ url('admin/deactivate_user') }}/{!! base64_encode('user')!!}" method="post">
                  @endif

                 @csrf
                    <div class="row">
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Candidate Name</b></label><br>
                                 {{ $Candidate->name  }}<input type="hidden" name="cid" id="cid" value="{{ $Candidate->id  }}">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email ID</b></label><br>
                                 <input type="text" class="form-control"  onchange="liveValidateEmail()" id="email" value="{{ $Candidate->email }}" name="email" required>
                                 <span id="emailValidationMessage" style="color:red"></span>
                                 <span id="email_error" style="color:red;"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Mobile Number</b><span style="color:red">*</span></label><br>
                                 <input type="text" class="form-control" id="MobileNumber" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '');"  value="{{ $Candidate->mobile_number }}" name="MobileNumber" onkeyup="validateMobile_Number()" >
                                 <span id="mobValidationMessage"></span>
                                 <span id="mobile_number_error" style="color:red;"></span>
                             </div>
                         </div> 
                          <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Contact Number</b></label><br>
                                 <input type="text" class="form-control" id="Contact_Number" maxlength="12" oninput="this.value = this.value.replace(/[^0-9]/g, '');"" value="{{ $Candidate->phone_number }}" name="Contact_Number" oninput="this.value = this.value.replace(/[^0-9]/g, '');" >
                                 <span id="phValidationMessage"></span>
                                 <span id="contactno_error" style="color:red;"></span>
                             </div>
                         </div> 
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>DOB</b><span style="color:red">*</span></label><br>
                                 <input type="date" class="form-control" id="dob" value="{{date('Y-m-d', strtotime($Candidate->dob)) }}"  placeholder="" name="dob" max="{{ $defaultDate }}"  required>
                                
                                 <span id="dobValidationMessage"></span>
                                    <span style="color:red" id="dob_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
        <label for=""><b>Gender</b><span style="color:red">*</span></label><br>
       @php
        $chk=""; 
        $chk1="";
        $chk2="";
        if( $Candidate->gender =='Male'){
            $chk="selected";    
}    
        elseif( $Candidate->gender =='Female'){
            $chk1="selected";
        }
        else{
            $chk2="selected";  
        }        @endphp
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio"
                                          @if( $Candidate->gender =='Male')
                                          checked  @endif name="gender" id="male"  value="Male" required>
                                        <label class="form-check-label" for="gender1">Male</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio"    
                                           @if( $Candidate->gender =='Female')
                                           checked  @endif name="gender" id="female" value="Female">
                                        <label class="form-check-label" for="gender2">Female</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio"     
                                        @if( $Candidate->gender =='transgender')
                                          checked  @endif name="gender" id="transgender"  value="Transgender">
                                        <label class="form-check-label" for="gender3">Transgender</label>
                                    </div>

                                    <span id="gender_error_message" style="color:red;"></span>
                                    <span id="transgender_error" style="color:red;"></span>

                                    <span id="gender_error" style="color:red;"></span>
                
            </div> </div>
                        
                                          
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Highest Qualification</b></label><br>
                                 {{ $Candidate->Highest_Qualification }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Specify the courses completed.</b></label><br>
                                @if($Candidate->AdditionalCertificates) {{ $Candidate->AdditionalCertificates }} @else Nil @endif
                             </div>
                         </div>
                  
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>District</b></label><br>
                                 <div class="form-group">
                                    {{ $Candidate->District->name }}
                                 </div>
                                 
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Localbody Type</b></label><br>
                                 <div class="form-group">
                                    
                                 @if($Candidate->lbTypeid )  {{ $Candidate->localbodytypes->name_eng }} @elseif($Candidate->lbTypeid)  {{ $Candidate->localbodytypes->name_eng }}@else Nill @endif
                                 </div>
                                 
                             </div>
                         </div>
                         @if($Candidate->lbTypeid ==1)
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Block </b></label><br>
                                 <div class="form-group">
                                 @if($Candidate->Block)   {{ $Candidate->Block->name }} @else  Nil @endif
                                 </div>
                                 
                             </div>
                         </div>
                        @endif
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Localbody </b></label><br>
                                 <div class="form-group">
                                 @if($type=='candi')   {{ $Candidate->Localbody->name_eng }} @else  {{ $Candidate->LocalBodyGet->name_eng }} @endif
                                 </div>
                                 
                             </div>
                         </div>
</div><div class="row">
<div class="col-md-6">
                             <div class="form-group">
                                
                                 <div class="my-2">
        
        <label for="" class="form-label"><b>Building Name/Number</b><span style="color:red">*</span></label>
         <input type="text" class="form-control" id="BuildingName" maxlength="50"  value="{{ $Candidate->building_name }}" name="BuildingName" required>
         <span id="BuildingName_error" style="color:red;"></span>
        </div>
       
        
        <div class="my-2">
      
      <label for="" class="form-label"><b>Landmark</b><span style="color:red">*</span></label>
       <input type="text" class="form-control" id="Landmark" maxlength="50" value="{{ $Candidate->landmark }}" name="Landmark">
       <span id="Landmark_error" style="color:red;"></span>
</div></div></div>
<div class="col-md-6">
                             <div class="form-group">
<div class="my-2">
        <label for="" class="form-label"><b>Post Office</b><span style="color:red">*</span></label>
        <input type="text" class="form-control"maxlength="50"  id="PostOffice" value="{{ $Candidate->postOffice }}" name="PostOffice">
        <span id="PostOffice_error" style="color:red;"></span>                      
        </div>
        <div class="my-2">
        <label for="" class="form-label"><b>Pincode</b><span style="color:red">*</span></label>
        <input type="text" class="form-control" maxlength="6" id="PIN_Code" oninput="this.value = this.value.replace(/[^0-9]/g, '');" value="{{ $Candidate->pincode }}" name="PIN_Code"  >
       
        <span id="PIN_Code_error" style="color:red;"></span>
    </div>   
                             </div>
                         </div>   
            
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Religion</b></label><br>
                                 {{ $Candidate->religion }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Category</b></label><br>
                                 {{ $Candidate->category }}
                                <input type="hidden"  id="category" name="category" value="{{ $Candidate->category }}" >
                            
                             </div>
                         </div>
                         
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b> Do you belong to MGNREGA Family ?</b></label><br>
                                {{ $Candidate->MGNREGA }}
                             </div>
                         </div> 
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Program Implementation Agency</b></label><br>
                                                        <div class="form-check form-check-inline">
                                                       <label class="form-check-label" for="kudMember1"> @if($PIA) {{$PIA[0]}} @endif </label></br>
                                        </div>
                                        
                                                                    
                                                        
                             </div>
                         </div>
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Joined Training programme</b></label><br>
                                                        <div class="form-check form-check-inline">
                                                       <label class="form-check-label" for="kudMember1"> @if($Candidate->Training){{$Candidate->Training->training_name}} @endif </label></br>
                                        </div>
                                        
                                                                    
                                                        
                             </div>
                         </div>
                        
                  
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b> Willing to join for residential courses?</b></label><br>
                                {{ $Candidate->willingTojoin }}
                             </div>
                         </div> 
                         
                         @if($Candidate->document_upload)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=""><b>CV</b><span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                    <div>
                                    <a href="{{ asset('storage/cvupload/' . $Candidate->document_upload) }}" target="_blank">Click here to view the CV</a>
</div>

                                   
                                </div>
                            </div>
</div>
                            @endif

                            @if($Candidate->employer_id and $Candidate->profile_status!=4)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=""><b>Employer</b><span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                    <div>
                                    {{$empname->name}}
                                   </div>

                                   
                                </div>
                            </div>
</div>
                            @endif
                            @if($Candidate->employer_id and $Candidate->profile_status==4)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for=""><b>Former Employer</b><span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                    <div>
                                    {{$empname->name}}
                                   </div>

                                   
                                </div>
                            </div>
</div>
                            @endif
                            
                        </div>
                        <div class="row">
                            <div class="col-12 text-left">
                                <hr>
                                <span id="errorMessage" style="color:red;"></span>
                                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                              <button type="button" class="btn btn-primary submit mt-0 mb-3" id="submitBtn_CourseCandidate">Submit</button>
             
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 text-right">
                                <hr>
                                <span id="errorMessage" style="color:red;"></span>
                                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                              
 <button type="button" class="btn btn-primary submit mt-0 mb-3 deactivate-user" id="DeactivateBtn_Candidate">Deactivate</button>
            
                            </div>
                        </div>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->
<script>
 ('#submitBtn_CourseCandidate').click(function(event) {
           // Swal.fire('Form submitted!');
          
var Gender =$("input[name='gender']:checked").val();
var MasterCourse =$("input[name='MasterCourse']:checked").val();
var dobYear = $("#dob").val();
var maxYear = calculateMaxYear();

var email = $("#email").val();
var mobileNumber = $("#ContactNumber").val();
var BuildingName = $("#BuildingName").val();
var Landmark = $("#Landmark").val();
var PostOffice = $("#PostOffice").val();
var PIN_Code = $("#PIN_Code").val();

if (!MasterCourse||!Gender||!dobYear||!email||!mobileNumber||!BuildingName||!Landmark||!PostOffice||!PIN_Code)
{
        if(!MasterCourse)  {
            $("input[name='MasterCourse']").addClass("error");            
             $("#MasterCourse_error").html("Please enter the Master Course");
        }else{
            $("input[name='MasterCourse']").removeClass("error");            
            $("#MasterCourse_error").html("");
        }  
        
        if(!mobileNumber)  {
            $("input[name='ContactNumber']").addClass("error");            
             $("#mobile_number_error").html("Please enter the Contact Number");
        }else{
            $("input[name='ContactNumber']").removeClass("error");            
            $("#mobile_number_error").html("");
        }  

        if(!dobYear)  {
            $("input[name='dob']").addClass("error");            
             $("#dob_error").html("Please enter the DOB");
        }else{
            $("input[name='dob']").removeClass("error");            
            $("#dob_error").html("");
        } 
        if(!Gender)  {
            $("input[name='gender']").addClass("error");            
             $("#gender_error").html("Please enter the Gender");
        }else{
            $("input[name='gender']").removeClass("error");            
            $("#gender_error").html("");
        } 
        
        if(!email)  {
            $("input[name='email']").addClass("error");            
             $("#email_error").html("Please enter the Email ID");
        }else{
            $("input[name='email']").removeClass("error");            
            $("#email_error").html("");
        }   
        
        if(!BuildingName)  {
            $("input[name='BuildingName']").addClass("error");            
             $("#BuildingName_error").html("Please enter the Building Name/Number");
        }else{
            $("input[name='BuildingName']").removeClass("error");            
            $("#BuildingName_error").html("");
        } 
        
        if(!Landmark)  {
            $("input[name='Landmark']").addClass("error");            
             $("#Landmark_error").html("Please enter the Landmark");
        }else{
            $("input[name='Landmark']").removeClass("error");            
            $("#Landmark_error").html("");
        }

        if(!PostOffice)  {
            $("input[name='PostOffice']").addClass("error");            
             $("#PostOffice_error").html("Please enter the PostOffice");
        }else{
            $("input[name='PostOffice']").removeClass("error");            
            $("#PostOffice_error").html("");
        }
               
        if(!PIN_Code)  {
          //  alert(PIN_Code);
            $("input[name='PIN_Code']").addClass("error");            
             $("#PIN_Code_error").html("Please enter the PIN Code");
        }else{
            $("input[name='PIN_Code']").removeClass("error");            
            $("#PIN_Code_error").html("");
        }
                
                Swal.fire("Please fill in all required fields.");
                event.preventDefault();
                return false;
 }

            if (dobYear < maxYear) {
                $("input[name='dob']").addClass("error");
                displayValidationError('Maximum age limit exceeded for the selected gender.');
                return false;
            }
            if (MasterCourse=='other')
{
            var ExtraMasterId =  $("select[name='ExtraMasterId']").val();
            var trainings =  $("select[name='trainings']").val();
            if (ExtraMasterId==""||trainings=="")
            {

                     if (ExtraMasterId==""){       
                           $("select[name='ExtraMasterId']").addClass("error");
                           $("#ExtraMasterId_error").html("Please enter the Other Master Course");           
                           
                     }else{
                        $("select[name='ExtraMasterId']").removeClass("error");
                        $("#ExtraMasterId_error").html("");         
                     }

                     if (trainings==""){
                        
                        $("select[name='trainings']").addClass("error");
                        $("#trainings_error").html("Please enter the trainings");
                              
                                 
                     }else{

                        $("select[name='trainings']").removeClass("error");
                        $("#trainings_error").html("");
                           
                     }

                     Swal.fire("Please fill in all required fields.");         
                     return false;        
                      event.preventDefault();
            }
    

    }else
    {
        $("select[name='ExtraMasterId']").removeClass("error"); 
        var trainings =  $("select[name='trainings']").val();

            if(trainings=="")
            {
               
               $("select[name='trainings']").addClass("error");
               $("#trainings_error").html("Please enter the trainings");
               Swal.fire("Please fill in all required fields.");
         
         return false;  
          event.preventDefault();
                      
          }else{

            $("select[name='trainings']").removeClass("error");
             $("#trainings_error").html("");
               
          }
         
}
            // Reset error classes and hide validation message on successful validation
            $("input[name='dob']").removeClass("error");
            $("input[name='gender']").removeClass("error");

           
           // $("input[name='ExtraMasterId']").removeClass("error");
           // validationMessage.hide();

            // Prevent default form submission
            event.preventDefault();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($("#AssignCourse")[0]);
            console.log(formData);
            $("#ajax-loader").show();

            $.ajax({
                
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
    url: "{{ route('AssignCourse') }}",
    type: "POST",
    data: formData,
    dataType: "json",
    processData: false,
    contentType: false,
    success: function (response) {
        //alert(response.status);
        if (response.status == "success") {
        //     Swal.fire("Interest Submited",response.message,"success");
        //    $("#myForm")[0].reset();
        //     $("#ajax-loader").hide();
        //     window.location.href = response.redirect;
            Swal.fire({
                        title: "Course Assigned",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#AssignCourse")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#AssignCourse")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
        } else{

            var errorMessage = "Something went wrong";

            if (response && response.message) {
                errorMessage = response.message;

            }

            Swal.fire("Failed", errorMessage, "error");

            $("#ajax-loader").hide();


}
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);
        console.log(JSON.parse(xhr.responseText).message);
        Swal.fire("Error", JSON.parse(xhr.responseText).message, "error");
        $("#ajax-loader").hide();
    }



});
    });
 // Prevent form submission for testing
 /*document.getElementById('AssignCourse').addEventListener('submit', function (event) {
        event.preventDefault();
        alert('Form submitted successfully!');
    });*/
////////////////////Placed for Candidate


</script>
@endsection
