    
    @extends('admin.layouts.app')

@section('title','Admin List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Inactive Block Admin List </h1>
           
            <a href="{{ route('admin_create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Create New</a>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Admin Name</th>
                                        <th>Admin Role</th>
                                        <th>District</th>
                                        <th>Block</th>
                                        <th>Contact Number</th>
                                        <th>Email Id</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($block_admins as $key=>$block_admin )
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $block_admin ->user_name  }}</td>
                                        <td>{{ $block_admin ->role }}</td>
                                        <td>{{ $block_admin ->district_name }}</td>
                                        <td>@if (isset($block_admin->block_name)) {{ $block_admin->block_name  }} @endif</td>
                                        <td>{{ $block_admin ->mobile_number }}</td>
                                        <td>{{ $block_admin ->email }}</td>
                                        
                                        <td>



   
                                            
                                                <a href="{{ route('editAdminInactive',['id'=>base64_encode($block_admin->id)]) }}" class="btn btn-success btn-circle btn-sm" title="edit">
                                                    <i class="fas fa-pen"></i>
                                                </a>


                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection