   
   @extends('admin.layouts.app')


@section('title','Edit Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Edit Admin</h1>
     <a href="{{ route('admin_list') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Admin List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="update_admin_details" action="post" method="javascript:void(0)">
                     <div class="row text-dark">

                       @csrf

                       <input type="hidden" name="id" value="{{ $user->id }}">
                       <input type="hidden" name="user_role_id" value="{{ $user->user_role_id }}">

                         <div class="col-md-12">
                              Admin Name: {{ $user->name }}
                         </div>
                         <div class="col-md-12">
                              Admin Role: @if($user->user_role_id ==2)District Admin
                              @else
                              Block Admin
                              @endif
                         </div>   
                         <div class="col-md-12">
                             District : {{ $user->District->name }}
                         </div>
                         @if($user->user_role_id ==3)
                         <div class="col-md-12">
                             Block : {{ $user->Block->name }}
                         </div>
                         @endif
                         <div class="col-md-12">
                            
                             Mobile No : {{ $user->mobile_number }}
                         </div>
                         <div class="col-md-12">
                             Email Id : {{ $user->email }}
                         </div>
                         @if ($user->user_role_id == 2)
                                              
                         <div class="col-md-6 mt-5">
                            <label><strong>Change district: </strong></label>
                             <select name="district" class="form-control" id="adm_district" required>
                                         <option value="">---Choose District---</option>

                                         @foreach($districts as $district)
                                            @if($district->id==$user->district_id)
                                            <option selected="selected" value="{{ $district->id }}">{{ $district->name }}</option>
                                            @else
                                            <option value="{{ $district->id }}" data-admStatus = "{{ $district->user_status }}">{{ $district->name }}</option>
                                            @endif
                                         @endforeach

                                </select>
                         </div>
                         @elseif($user->user_role_id == 3)                     
                         <div class="col-md-6">
                         <label><strong>Change Block: </strong></label>
                         <select name="block" class="form-control" id="block" required>
                                         <option value="">---Choose Block---</option>

                                         @foreach($blocks as $block)
                                            @if($block->id==$user->block_id)
                                            <option selected="selected" value="{{ $block->id }}">{{ $block->name }}</option>
                                            @else
                                            <option value="{{ $block->id }}" data-admStatus = "{{ $block->user_status }}">{{ $block->name }}</option>
                                            @endif
                                         @endforeach

                                </select>
                         </div>
                         @endif

                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Update</button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection