    
    @extends('admin.layouts.app')

@section('title','Admin List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Admin List </h1>
           
            <a href="{{ route('admin_create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Create New</a>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                <div id="ajax-loader"  style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                    <!-- Card Body -->
                    <div class="card-body">
                 
                        <div class="table-responsive">

                        
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Admin Name</th>
                                        <th>Admin Role</th>
                                        <th>District</th>
                                        <th>Block</th>
                                        <th>Mobile Number</th>
                                        <th>Email Id</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($admins as $key=>$admin)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $admin->user_name  }}</td>
                                        <td>{{ $admin->role }}</td>
                                        <td>{{ $admin->district_name }}</td>
                                        <td>@if (isset($admin->block_name)) {{ $admin->block_name  }} @endif</td>
                                        <td>{{ $admin->mobile_number }}</td>
                                        <td>{{ $admin->email }}</td>
                                        
                                        <td>


                                          
                                                <a href="{{ route('EditAdmin',['id'=>base64_encode($admin->id)]) }}" class="btn btn-success btn-circle btn-sm" data-toggle="tooltip" title="edit">
                                                    <i class="fas fa-pen"></i>
                                                </a>



                                            <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-admin" data-admin="{{ base64_encode($admin->id) }}" title="Deactivate">
                                                <i class="fas fa-trash"></i>
                                            </a>


                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection