  


<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" />
    <meta name="description" content="Kudumbashree">
    <meta name="author" content="Kudumbashree">
    <title>@yield('title')</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Custom fonts for this template-->
    <link href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
    <link href="{{ asset('vendor/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Custom styles for this template-->
    <link href="{{ asset('css/kudumbashree.css') }}" rel="stylesheet">
    
     <!-- Page level plugins -->
     <script src="{{ asset('vendor/chart.js/Chart.min.js') }}"></script>

    
   <!-- <link rel="stylesheet" href="{{ asset('plugins/multiselect/dist/css/bootstrap-multiselect.css') }}" type="text/css"/>-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css" type="text/css"/>

    <script src="{{ asset('vendor/jquery/jquery.min.js') }}"></script>


</head>

<body id="page-top">



    <!-- Page Wrapper -->
    <div id="wrapper">

                     <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

            <!-- Sidebar - Brand -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{ route('dashboard') }}">
                <img src="{{ asset('img/logo.png') }}" title="Kudumbashree" class="img-responsive">
            </a>

            <!-- Divider -->
            <hr class="sidebar-divider my-0">

            <!-- Nav Item - Dashboard -->
            <li class="nav-item active">
                <a class="nav-link" href="{{ route('dashboard') }}">
                <i class="fas fa-fw fa-home"></i>
                    <span>Dashboard</span></a>
            </li>


            @if(auth()->user()->user_role_id==1 ||  auth()->user()->user_role_id==2 || auth()->user()->user_role_id==3)

                <li class="nav-item">
                    <a class="nav-link" href="{{ route('CourseMasterList') }}">
                <i class="fas fa-fw fa-file-alt"></i>
                    <span>Course Master</span></a>

                </li>

                <li class="nav-item">
                <a class="nav-link" href="{{ route('piaList') }}">
                <i class="fas fa-fw fa-user-cog"></i>
                    <span>PIA</span></a>
            </li>

               
               

            @endif

            @if(auth()->user()->user_role_id==1)

           <!-- <li class="nav-item">
                <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#reportsTwo"
                    aria-expanded="true" aria-controls="collapseTwo">
                    <i class="fas fa-fw fa-users"></i>
                    <span>Reports</span>
                </a>
                <div id="reportsTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('adminPiaReport')}}">PIA Reports</a>
                    </div>
                </div>
            </li>-->

            <li class="nav-item">
                    <a class="nav-link" href="{{ route('sectorList') }}">
                    <i class="fas fa-fw fa-layer-group"></i>
                        <span>Sector</span></a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="{{ route('SkillList') }}">
                <i class="fas fa-fw fa-hourglass-half"></i>
                    <span>Skills</span></a>
            </li>

         
            
            @endif

           
           

            @if(auth()->user()->user_role_id==1 || auth()->user()->user_role_id==2)
            </li>
              <!-- Nav Item - Pages Collapse Menu -->
              <li class="nav-item">
                <a class="nav-link {{  Route::is('admin_create', 'admin_list', 'EditAdmin') ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseTwo"
                    aria-expanded="{{  Route::is('admin_create', 'admin_list', 'EditAdmin') ? 'true' : 'false' }}" aria-controls="collapseTwo">
                    <i class="fas fa-fw fa-user-cog"></i>
                    <span>Manage Admins</span>
                </a>
                <div id="collapseTwo" class="collapse {{  Route::is('admin_create', 'admin_list', 'EditAdmin', 'admin_list_inactive', 'editAdminInactive') ? 'show' : '' }}" aria-labelledby="headingTwo" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('admin_create') }}">Create Admin</a>
                        <a class="collapse-item" href="{{ route('admin_list') }}">List Admins</a>
                        <a class="collapse-item" href="{{ route('admin_list_inactive') }}">List Inactive Admins</a>
                    </div>
                </div>
            </li>
            @endif

            @if(auth()->user()->user_role_id==4)
            <li class="nav-item">
                <a class="nav-link" href="{{ route('adminEmployerList') }}">
                <i class="fas fa-fw fa-clipboard-list"></i>
                    <span>Employer List</span></a>
            </li>

            @endif

            @if(auth()->user()->user_role_id==1 || auth()->user()->user_role_id==2 ||auth()->user()->user_role_id==3 )
            <li class="nav-item">
                <a class="nav-link" href="{{ route('adminEmployerList') }}">
                <i class="fas fa-fw fa-clipboard-list"></i>
                    <span>Employer List</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="{{ route('TrainingProgrammeList') }}">
                <i class="fas fa-fw fa-list-alt"></i>
                    <span>Training Program List</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="{{ route('candidateallist') }}">
                <i class="fas fa-fw fa-clone"></i>
                    <span>Candidate Interest List</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="{{ route('candidatejoinedList') }}">
                <i class="fas fa-fw fa-user"></i>
                    <span>Candidate List</span></a>
            </li>

            @endif

            @if(auth()->user()->user_role_id==1)
            <li class="nav-item">
                <a class="nav-link {{  Route::is('TrainingPrograms', 'adminPiaReport', 'CandidateReportView') ? '' : 'collapsed' }}" href="#" data-toggle="collapse" data-target="#collapseOne"
                    aria-expanded="{{  Route::is('TrainingPrograms', 'adminPiaReport', 'CandidateReportView') ? 'true' : 'false' }}" aria-controls="collapseOne">
                    <i class="fas fa-fw fa-briefcase"></i>
                    <span>Reports</span>
                </a>
                <div id="collapseOne" class="collapse {{  Route::is('TrainingPrograms', 'adminPiaReport', 'CandidateReportView') ? 'show' : '' }}" aria-labelledby="headingOne" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="{{ route('CandidatesReport') }}">Candidates</a>
                        <a class="collapse-item" href="{{ route('InterestedCandidatesReport') }}">Interested Candidates</a>
                        
                        <a class="collapse-item" href="{{ route('adminPiaReport') }}">PIA</a>
                        <a class="collapse-item" href="{{route('adminEmployerReport')}}">Employer</a>
                        <a class="collapse-item" href="{{ route('TrainingPrograms') }}">Training Programs</a>
                       
                        
                    </div>
                </div>
            </li>

            @endif

           
             @if(auth()->user()->user_role_id==4) 

            <li class="nav-item">
                <a class="nav-link" href="{{ route('candidateInterestList') }}">
                <i class="fas fa-fw fa-clone"></i>
                    <span>Course Interest List</span></a>
            </li>

            @endif 

            <!-- Nav Item - Pages Collapse Menu -->
           
           <!-- <li class="nav-item">
                <a class="nav-link" href="#">
                    <i class="fas fa-fw fa-user"></i>
                    <span>Candidates</span></a>
            </li>-->
            <!-- <li class="nav-item">
                <a class="nav-link" href="#">
                    <i class="fas fa-bell fa-fw"></i>
                    <span>Announcements</span></a>
            </li> -->

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>

        </ul>
            <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

                       <!-- Topbar -->

            <div id="content">
                    <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">
                                            <div>Welcome, {{ auth()->user()->name }}</div>                    

                                        <!-- Sidebar Toggle (Topbar) -->
                                        <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                                            <i class="fa fa-bars"></i>
                                        </button>

                                        <!-- Topbar Search -->
                                        <!--<form
                                            class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
                                            <div class="input-group">
                                                <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..."
                                                    aria-label="Search" aria-describedby="basic-addon2">
                                                <div class="input-group-append">
                                                    <button class="btn btn-primary" type="button">
                                                        <i class="fas fa-search fa-sm"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </form>-->

                                        <!-- Topbar Navbar -->
                                        <ul class="navbar-nav ml-auto">

                                            <!-- Nav Item - Search Dropdown (Visible Only XS) -->
                                            <li class="nav-item dropdown no-arrow d-sm-none">
                                                <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button"
                                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-search fa-fw"></i>
                                                </a>
                                                <!-- Dropdown - Messages -->
                                                <!--<div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
                                                    aria-labelledby="searchDropdown">
                                                    <form class="form-inline mr-auto w-100 navbar-search">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control bg-light border-0 small"
                                                                placeholder="Search for..." aria-label="Search"
                                                                aria-describedby="basic-addon2">
                                                            <div class="input-group-append">
                                                                <button class="btn btn-primary" type="button">
                                                                    <i class="fas fa-search fa-sm"></i>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>-->
                                            </li>

                                            <!-- Nav Item - Alerts -->
                                            <!--<li class="nav-item dropdown no-arrow mx-1">
                                                <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
                                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-bell fa-fw"></i>
                                                
                                                    <span class="badge badge-primary badge-counter">3+</span>
                                                </a>
                                            
                                                <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                                    aria-labelledby="alertsDropdown">
                                                    <h6 class="dropdown-header">
                                                        Alerts Center
                                                    </h6>
                                                    <a class="dropdown-item d-flex align-items-center" href="#">
                                                        <div class="mr-3">
                                                            <div class="icon-circle bg-primary">
                                                                <i class="fas fa-file-alt text-white"></i>
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="small text-gray-500">December 12, 2019</div>
                                                            <span class="font-weight-bold">A new monthly report is ready to download!</span>
                                                        </div>
                                                    </a>
                                                    <a class="dropdown-item d-flex align-items-center" href="#">
                                                        <div class="mr-3">
                                                            <div class="icon-circle bg-success">
                                                                <i class="fas fa-donate text-white"></i>
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="small text-gray-500">December 7, 2019</div>
                                                            $290.29 has been deposited into your account!
                                                        </div>
                                                    </a>
                                                    <a class="dropdown-item d-flex align-items-center" href="#">
                                                        <div class="mr-3">
                                                            <div class="icon-circle bg-warning">
                                                                <i class="fas fa-exclamation-triangle text-white"></i>
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <div class="small text-gray-500">December 2, 2019</div>
                                                            Spending Alert: We've noticed unusually high spending for your account.
                                                        </div>
                                                    </a>
                                                    <a class="dropdown-item text-center small text-gray-500" href="#">Show All Alerts</a>
                                                </div>
                                            </li>-->
                                            <!--alert-->

                                            <div class="topbar-divider d-none d-sm-block"></div>

                                            <!-- Nav Item - User Information -->
                                            <li class="nav-item dropdown no-arrow">
                                                <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <span class="mr-2 d-none d-lg-inline text-gray-600 small"> @if(auth()->user()->user_role_id==1)
                                                    Super Admin
                                                    @elseif(auth()->user()->user_role_id==2)
                                                    District Admin
                                                    @elseif(auth()->user()->user_role_id==3)
                                                    Block Admin
                                                    @elseif(auth()->user()->user_role_id==4)
                                                    PIA
                                                    @elseif(auth()->user()->user_role_id==5)
                                                    Employer
                                                    @elseif(auth()->user()->user_role_id==6)
                                                    Candidates
                                                    @endif

                                                    @if( isset(auth()->user()->district_id) && auth()->user()->user_role_id == 2)
                                                    ( DISTRICT: {{auth()->user()->District->name}})
                                                    @endif 
                                                    @if( isset(auth()->user()->district_id) && isset( auth()->user()->block_id ) && auth()->user()->user_role_id == 3 )
                                                    ( DISTRICT: {{ auth()->user()->District->name }}, BLOCK: {{ auth()->user()->Block->name }} )
                                                    @endif 
                                                    </span>
                                                    <img class="img-profile rounded-circle" src="{{ asset('img/undraw_profile.svg') }}">
                                                </a>
                                                <!-- Dropdown - User Information -->
                                                <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                                    aria-labelledby="userDropdown">
                                                <!--  <a class="dropdown-item" href="#">
                                                        <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                                        Profile
                                                    </a>
                                                    <a class="dropdown-item" href="#">
                                                        <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                                                        Settings
                                                    </a>
                                                    <div class="dropdown-divider"></div>-->
                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                                                        <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                                        Logout
                                                    </a>
                                                </div>
                                            </li>

                                        </ul>

                    </nav>  
        

                @yield('content')


            </div>

       

          <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Kudumbashree {{ date('Y') }}</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    

    

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">To continue to log out, please select the logout button.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="{{ url('/logout') }}">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->

   
    <script src="{{ asset('js/demo/datatables-demo.js') }}"></script>

    <script src="{{ asset('vendor/datatables/jquery.dataTables.js') }}"></script>

    <script>

       $(document).ready(function()
       {
           
       });


    </script>

    <script>

        $(document).ready(function()
        {
            $("#dataTable").DataTable();
        });

    </script>

    <script>

        $(document).ready(function()
        {
            $("dataTable").DataTable();

        });

    </script>

    <script src="{{ asset('vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ asset('vendor/jquery-easing/jquery.easing.min.js') }}"></script>

   <!-- <script type="text/javascript" src="{{ asset('plugins/multiselect/dist/js/bootstrap-multiselect.js') }}"></script>-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script>

    <script>

        
            function liveValidateEmail() {

               

                //$("#emailValidationMessage").show();
                var emailInput = document.getElementById('email');
                var email = emailInput.value;

                // Use a regular expression for basic email validation
                var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

                var validationMessage = document.getElementById('email_error_live');

                if(email)
                {

                    

                    if (emailPattern.test(email)) {

                

                        validationMessage.textContent = 'Email is valid';
                        validationMessage.style.color = 'green';
                    } else {
                        validationMessage.textContent = 'Invalid email address';
                        validationMessage.style.color = 'red';
                    }

                }


            }

    </script>
    <script>
        $(document).ready(function () {
            $('#sectordropdown').multiselect({
                nonSelectedText: 'Select Sector',
                enableFiltering: true,
                enableCaseInsensitiveFiltering: true,
                buttonWidth: '400px'
            });

        });
        $('#tradedropdown').multiselect({
            nonSelectedText: 'Select Trade',
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            buttonWidth: '400px'
        });
    </script>

   <!-- <script>

        $(document).ready(function()
        {
            $(".multiselect").multiselect();
        });

    </script>-->



    <!-- Custom scripts for all pages-->
    <script src="{{ asset('js/kudumbashree.js') }}"></script>

   

    <!-- Page level custom scripts -->
    <script src="{{ asset('js/demo/chart-area-demo.js') }}"></script>
    <script src="{{ asset('js/demo/chart-pie-demo.js') }}"></script>

    <script src="{{ asset('js/sweetalert.js') }}"></script>

    <script>

        $(document).ready(function()
        {

            ////////////////////Training Course Selection Based on Master Course for Candidate interest status change///////////////////////////////////
            $(document).on("change", "input[type=radio][name=MasterCourse]", function () {
                // Get the selected radio button value
                var radVal = $("input[type=radio][name=MasterCourse]:checked").val();
               
                if(radVal!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadTrainings') }}",
                        type:"POST",
                        data:{master:radVal},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var trainings=response.training;

                                $("#trainings").html("");

                                $("#trainings").append("<option value=''>Choose Trainings</option>");

                                trainings.forEach(function(trainings)
                                {
                                    $("#trainings").append("<option value='"+trainings.id+"'>"+trainings.training_name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            ///////////////////////////////////////////////////////
            

            $(".seats").each(function() {

                $(this).keyup(function(){
                    calculateSum();
                });
            });
            

           
            $('#trainingdropdown').change(function(){

                var idTraining=$('#trainingdropdown').val();
                $("#coursename").val(idTraining);
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-training-code/" + idTraining,
                    data: { idTraining: idTraining },
                    success: function (data) {
                        console.log(data);
                        $.each(data.data, function (index, value) {
                            $('#coursecode').val(value.tradecode);
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });

            });

            $(document).on("submit","#submit_course_master_details",function(e)
            { 

               $("#ajax-loader").show();
              
                var sectordropdown = $("#sectordropdown").val();
               

                var course_code = $("#course_code").val();

                if (!trade_name||!course_code||!sectordropdown || sectordropdown.length === 0)
                {

                    if(!trade_name)
                    {

                        $("#trade_name_error").html("Please enter the Trade Name");

                        $("#trade_name").addClass("error");

                    }

                    else{


                        $("#trade_name_error").html("");

                        $("#trade_name").removeClass("error");

                    }
                    if(!sectordropdown || sectordropdown.length === 0)
                    {

                        $("#sector_error").html("Please select the sector.");

                        $("#sectordropdown").addClass("error");

                    }

                    else{


                        $("#sector_error").html("");

                        $("#sectordropdown").removeClass("error");

                    }
                    if(!course_code)
                    {

                        $("#course_code_error").html("Please enter the Trade code");

                        $("#course_code").addClass("error");

                    }

                    else{


                        $("#course_code_error").html("");

                        $("#course_code").removeClass("error");

                    }
                }
                e.preventDefault();

                var form_data=new FormData($(this)[0]);
                console.log(form_data);
                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('submitCourseMasterDetails') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire({
                        title: "A new course master created successfully.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                         $("#submit_course_master_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_course_master_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });
            

            $(document).on("change","#country",function()
            {
                var country=$(this).val();
              

                if(country!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadStates') }}",
                        type:"POST",
                        data:{country:country},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var states=response.states;

                                $("#state").html("");

                                $("#state").append("<option value=''>Choose State</option>");

                                states.forEach(function(state)
                                {
                                    $("#state").append("<option value='"+state.id+"'>"+state.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#state",function()
            {
                var state=$(this).val();
                var stateDropdown = document.getElementById('state');
                var districtDropdown = document.getElementById('district');
                if (stateDropdown.value === '') {
                    $("#district").html("");

                    $("#district").append("<option value=''>Choose District</option>");
                }

                if(state!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadDistricts') }}",
                        type:"POST",
                        data:{state:state},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var districts=response.districts;

                                $("#district").html("");

                                $("#district").append("<option value=''>Choose District</option>");

                                districts.forEach(function(district)
                                {
                                    $("#district").append("<option value='"+district.id+"'>"+district.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#district",function()
            {
                var district=$(this).val();

                if(district!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadBlocks') }}",
                        type:"POST",
                        data:{district:district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var blocks=response.blocks;

                                $("#block").html("");

                                $("#block").append("<option value=''>Choose Block</option>");

                                blocks.forEach(function(block)
                                {
                                    $("#block").append("<option value='"+block.id+"'>"+block.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });
            $(document).on("submit","#submit_pia_details",function(e)
            {
                    var agency_name = $("#agency_name").val();
                    var building_number = $("#building_number").val();
                    var street_name = $("#street_name").val();
                    var sectordropdown = $("#sectordropdown").val();
                    var state = $("#state").val();
                    var district = $("#district").val();
                    var mobile_number = $("#mobile_number").val();
                    var pan_number = $("#pan_number").val();
                    var post_office = $("#post_office").val();
                    var pincode = $("#pincode").val();
                    var email = $("#email").val();

                    if (!email||!agency_name|| !building_number||!street_name||!sectordropdown || sectordropdown.length === 0 ||!state||!district||!mobile_number||!pan_number||!post_office||!pincode)
                    {

                        if(!agency_name)
                        {

                            $("#agency_name_error").html("Please enter the Agency Name");

                            $("#agency_name").addClass("error");

                        }

                        else{


                            $("#agency_name_error").html("");

                            $("#agency_name").removeClass("error");

                        }
                        if(!building_number)
                        {

                            $("#building_number_error").html("Please enter the building number/name");

                            $("#building_number").addClass("error");

                        }

                        else{


                            $("#building_number_error").html("");

                            $("#building_number").removeClass("error");

                        }
                        if(!street_name)
                        {

                            $("#street_name_error").html("Please enter the street name");

                            $("#street_name").addClass("error");

                        }

                        else{


                            $("#street_name_error").html("");

                            $("#street_name").removeClass("error");

                        }
                        if(!sectordropdown || sectordropdown.length === 0)
                        {

                            $("#sectordropdown_error").html("Please select atleast one sector");

                            $(".multiselect").addClass("error");
                        

                        }

                        else{


                            $("#sectordropdown_error").html("");

                            $(".multiselect").removeClass("error");

                        }
                        if(!state)
                        {

                            $("#state_error").html("Please select the state");

                            $("#state").addClass("error");

                        }

                        else{


                            $("#state_error").html("");

                            $("#state").removeClass("error");

                        }
                        if(!district)
                        {

                            $("#district_error").html("Please select the district");

                            $("#district").addClass("error");

                        }

                        else{


                            $("#district_error").html("");

                            $("#district").removeClass("error");

                        }
            
                        if(!mobile_number)
                            {

                                $("#mobile_number_error").html("Please enter the mobile number");

                                $("#mobile_number").addClass("error");

                            }

                            else{


                                $("#mobile_number_error").html("");

                                $("#mobile_number").removeClass("error");

                            }
                            if(!pan_number)
                            {

                                $("#pan_number_error").html("Please enter a valid PAN number");

                                $("#pan_number").addClass("error");

                            }

                            else{


                                $("#pan_number_error").html("");

                                $("#pan_number").removeClass("error");

                            }
                            if(!post_office)
                            {

                                $("#post_office_error").html("Please enter the post office name");

                                $("#post_office").addClass("error");

                            }

                            else{


                                $("#post_office_error").html("");

                                $("#post_office").removeClass("error");

                            }
                            if(!pincode)
                            {

                                $("#pincode_error").html("Please enter the pincode");

                                $("#pincode").addClass("error");

                            }

                            else{


                                $("#pincode_error").html("");

                                $("#pincode").removeClass("error");

                            }
                            if(!email)
                            {

                                $("#email_error").html("Please enter the email");

                                $("#email").addClass("error");

                            }

                            else{


                                $("#email_error").html("");

                                $("#email").removeClass("error");

                            }
                            Swal.fire("Please fill in all required fields.");
                            return false;
                        }


                
                        e.preventDefault();

                        $("#plwait").show();

                        var form_data=new FormData($(this)[0]);

                        form_data.append('attachment',$(this)[0].files);

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('submitPIADetails') }}",
                            type:"POST",
                            data:form_data,
                            dataType:"JSON",
                            processData:false,
                            contentType:false,
                            success:function(response)
                            {
                                if(response.status=="success")
                                {
                                    Swal.fire({
                                            title: "PIA Account was successfully created",
                                            icon: "success"
                                        }).then((result) => {
                                        if (result.isConfirmed) {
                                            // User clicked "OK" button
                                            $("#submit_pia_details")[0].reset();
                                            $("#plwait").hide();
                                            window.location.href = response.redirect;
                                        } else {
                            
                                            $("#submit_pia_details")[0].reset();
                                            $("#plwait").hide();
                                            window.location.href = response.redirect;
                                        }
                                        });
                                    
                                }

                                else{

                                    Swal.fire("Error",response.message,"error");

                                    $("#plwait").hide();

                                



                                }
                            },
                            error:function()
                            {
                                Swal.fire("wrong","something went wrong","error");
                                $("#plwait").hide();
                            }
                        });
    
            });


            $(document).on("submit","#update_course_master_details",function(e)
            {
               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('updateCourseMasterDetails') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire({
                        title: "Course Master was updated successfully.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#update_course_master_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#update_course_master_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                            
                        }

                        else{

                            Swal.fire("Error",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            $(document).on("submit", "#update_pia_details", function (e) {
    e.preventDefault();

    var agency_name = $("#agency_name").val();
    var building_number = $("#building_number").val();
    var street_name = $("#street_name").val();
    var sectordropdown = $("#sectordropdown").val();
    var tradedropdown = $("#tradedropdown").val();
    var state = $("#state").val();
    var district = $("#district").val();
    var mobile_number = $("#mobile_number").val();
    var pan_number = $("#pan_number").val();
    var post_office = $("#post_office").val();
    var pincode = $("#pincode").val();
    var email = $("#email").val();

    // Validation logic
    if (!building_number || !street_name || !sectordropdown || sectordropdown.length == 0 || 
        !tradedropdown || tradedropdown.length == 0 || !state || !district || 
        !mobile_number || !post_office || !pincode) {
        
        // Clear previous error messages
        $("#building_number_error").html("");
        $("#street_name_error").html("");
        $("#sectordropdown_error").html("");
        $("#tradedropdown_error").html(""); // Clear trade error
        $("#state_error").html("");
        $("#district_error").html("");
        $("#mobile_number_error").html("");
        $("#post_office_error").html("");
        $("#pincode_error").html("");

        // Check each field and display error messages as needed
        if (!building_number) {
            $("#building_number_error").html("Please enter the building number/name");
            $("#building_number").addClass("error");
        }
        if (!street_name) {
            $("#street_name_error").html("Please enter the street name");
            $("#street_name").addClass("error");
        }
        if (!sectordropdown || sectordropdown.length == 0) {
            $("#sectordropdown_error").html("Please select at least one sector");
            $(".multiselect").addClass("error");
        }
        if (!tradedropdown || tradedropdown.length == 0) {
            $("#tradedropdown_error").html("Please select at least one trade");
            $(".multiselect").addClass("error");
        }
        if (!state) {
            $("#state_error").html("Please select the state");
            $("#state").addClass("error");
        }
        if (!district) {
            $("#district_error").html("Please select the district");
            $("#district").addClass("error");
        }
        if (!mobile_number) {
            $("#mobile_number_error").html("Please enter the mobile number");
            $("#mobile_number").addClass("error");
        }
        if (!post_office) {
            $("#post_office_error").html("Please enter the post office name");
            $("#post_office").addClass("error");
        }
        if (!pincode) {
            $("#pincode_error").html("Please enter the pincode");
            $("#pincode").addClass("error");
        }

        Swal.fire("Please fill in all required fields.");
        return false;
    }

    $("#plwait").show();
    var form_data = new FormData($(this)[0]);

    $.ajax({
        headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
        url: "{{ route('updatePIADetails') }}",
        type: "POST",
        data: form_data,
        dataType: "JSON",
        processData: false,
        contentType: false,
        success: function(response) {
            if (response.status == "success") {
                Swal.fire({
                    title: "PIA account was updated successfully..",
                    icon: "success"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $("#update_pia_details")[0].reset();
                        $("#plwait").hide();
                        window.location.href = response.redirect;
                    }
                });
            } else {
                Swal.fire("Error", response.message, "error");
                $("#plwait").hide();
            }
        },
        error: function() {
            Swal.fire("wrong", "something went wrong", "error");
            $("#plwait").hide();
        }
    });
});

            $(document).on("click",".deactivate-pia",function()
            {
                var pia=$(this).data('pia-id');

                Swal.fire({
                    title: "Are you sure to deactivate agency?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivatePIA') }}",
                            type:"POST",
                            data:{pia:pia},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {

                                $("#plwait").hide();
                                Swal.fire({
                        title: "PIA account was deactivated successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                $("#plwait").hide();

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        $("#plwait").hide();
                        Swal.fire("Agency is safe", "", "info");
                    }
                });
            });

            $(document).on("click",".reactivate-pia",function()
            {
                var pia=$(this).data('pia-id');

                

                Swal.fire({
                    title: "Are you sure to reactivate agency?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('adminReactivatePia') }}",
                            type:"POST",
                            data:{pia:pia},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                               
                                Swal.fire({
                        title: "PIA account was reactivated successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                                $("#plwait").hide();
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Agency is still not reactivated", "", "info");
                        $("#plwait").hide();
                    }
                });
            });

            
            $(document).on("click",".deactivate-employer",function()
            {
                var employer=$(this).data('employer');

                Swal.fire({
                    title: "Are you sure to deactivate Employer",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('adminDeactivateEmployer') }}",
                            type:"POST",
                            data:{employer:employer},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {

                                $("#plwait").hide();
                                Swal.fire({
                        title: "The employer account has been deactivated successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                                $("#plwait").hide();
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Employer is safe", "", "info");
                        $("#plwait").hide();
                    }
                });
            });

            $(document).on("click",".reactivate-employer",function()
            {
                var employer=$(this).data('employer');

                Swal.fire({
                    title: "Are you sure to reactivate Employer",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('adminReactivateEmployer') }}",
                            type:"POST",
                            data:{employer:employer},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "The employer account has been reactivated successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                                $("#plwait").hide();
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Employer is still not reactivated", "", "info");
                        $("#plwait").show();
                    }
                });
            });


            $(document).on("click",".approve-employer",function()
            {

                
                var employer=$(this).data('employer');

                Swal.fire({
                    title: "Are you sure to approve employer",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('adminApproveEmployer') }}",
                            type:"POST",
                            data:{employer:employer},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "The employer account has been approved successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                                $("#plwait").hide();
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Employer is not approved", "", "info");
                    }
                });
            });

                        
            $(document).on("click",".reject-employer",function()
            {

                
                var employer=$(this).data('employer');

                Swal.fire({
                    title: "Are you sure to reject employer",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('adminRejectEmployer') }}",
                            type:"POST",
                            data:{employer:employer},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                               
                                    Swal.fire({
                                                title: "The employer account has been rejected successfully..",
                                                icon: "success"
                                            }).then((result) => {
                                            if (result.isConfirmed) {
                                                $("#plwait").hide();
                                                window.location.href = response.redirect;
                                            } else {
                                                $("#plwait").hide();
                                                window.location.href = response.redirect;
                                            }
                                    });
                               } 

                               else{

                                    Swal.fire("Error",response.message, "error");
                                    $("#plwait").hide();
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Employer is not rejected", "", "info");
                    }
                });
            });

            $(document).on("submit","#submit_employer_details",function(e)
            {

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                form_data.append('attachment',$(this)[0].files);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminSubmitEmployerDetails') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("Employer added",response.message,"success");

                            $("#submit_employer_details")[0].reset();

                           
                            $("#plwait").hide();
                            
                        }

                        else{

                            Swal.fire("Error",response.message,"error");

                            $("#plwait").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            
            $(document).on("submit","#update_employer_details",function(e)
            {

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminUpdateEmployerDetails') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("Employer updated",response.message,"success");

                           location.reload();

                           
                           $("#plwait").hide();
                            
                        }

                        else{

                            Swal.fire("Error",response.message,"error");

                            $("#plwait").hide();                      



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            $(document).on("click",".process-employer-update-request",function(e)
            {

                $("#plwait").show();

                var request_id=$(this).data('request-id');
                var approval_status=$(this).data('approval-status');

                Swal.fire({
                    title: "Are you sure",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('adminProcessEmployerUpdateRequest') }}",
                            type:"POST",
                            data:{request_id:request_id,approval_status:approval_status},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                                $("#plwait").hide();
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Request is not processed", "", "info");
                    }
                });

            });


            $(document).on("change","#block",function()
            {
                var block=$(this).val();
                var bockDropdown = document.getElementById('block');
                if($( this ).val()==='')
                {
                    
                }
                else{
                    $("#block_error").html("");
                $("#block").removeClass("error");
                }
            });

            $(document).on("change","#adm_district",function()
            {
                
                var district=$(this).val();
                var bockDropdown = document.getElementById('block');
                if($( this ).val()==='')
                {
                    $("#block").html("");
                    $("#block").append("<option value=''>Choose Block</option>");
                }
                else{
                    $("#adm_district_error").html("");
                $("#adm_district").removeClass("error");
                }

                if(district!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('admin_form_block_list') }}",
                        type:"POST",
                        data:{district:district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var blocks=response.blocks;

                                $("#block").html("");

                                $("#block").append("<option value=''>Choose Block</option>");

                                blocks.forEach(function(block)
                                {
                                    if(block.user_status == null){
                                        block.user_status = "";    
                                    }
                                    $("#block").append("<option value='"+block.id+"' data-admStatus = '"+block.user_status+"'>"+block.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#role",function(e){

                var districtDropdown = document.getElementById('adm_district');
                var bockDropdown = document.getElementById('block');
                if( $( this ).val() == 2){
                   // $('#block').prop('required',false);
                    $('#block').val('');
                    $('#block_wrap').hide();
                    $("#role_error").html("");
                $("#role").removeClass("error");
                    
                }else if($( this ).val()==='')
                { 
                    $("#adm_district").prop("selectedIndex", 0).val(); 
                    $("#block").html("");
                    $("#block").append("<option value=''>Choose Block</option>");
                    $('#block_wrap').hide();
                    //$('#block').val('');
                }
                else{
                    $('#block_wrap').show();
                   // $('#block').prop('required',true);
                   $("#role_error").html("");
                $("#role").removeClass("error");
                }

                

                });

                $(document).on("keyup","#admin_name",function(e)
                {
                        var length=$(this).val().length;
                        var message="";
                        if(length<1)
                        {
                            message+="Please enter the Admin Name";
                        }
                        else if(length>50){
                            message+="Maximum 50 characters will be allowed"
                        }
                        else{
                        message="";
                        $("#admin_name").removeClass("error");
                        }
                        $("#admin_name_error").html(message);

                });
            $(document).on("keyup","#mobile_number",function(e)
            {
                var length=$(this).val().length;
                var message="";
                if(length<1)
                {
                    message+="Please enter the Mobile Number";
                }
                else if(length>50){
                    message+="Maximum 50 characters will be allowed"
                }
                else{
                        message="";
                        $("#mobile_number").removeClass("error");
                    }
                $("#mobile_number_error").html(message);

            });
    $(document).on("keyup","#email",function(e)
    {

            var emailInput = $(this).val();
            var emailError = $("#email_error");

            var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            if (!emailRegex.test(emailInput)) {
            emailError.text('Please enter a valid email address.');
            emailError.show();
            } else {
            emailError.hide();

                $("#email").removeClass("error");
            }

    });


            $(document).on("submit","#submit_admin_details",function(e)
            {

                
                var admin_name = $("#admin_name").val();
                var role = $("#role").val();
                var adm_district = $("#adm_district").val();
                var block = $("#block").val();
                var mobile_number = $("#mobile_number").val();
                var email = $("#email").val();
                var roleDropdown = document.getElementById('role');
                e.preventDefault();



                if(!admin_name||!role||role.length==0||!adm_district||adm_district.length==0||!email||!mobile_number)
                {
                    if(!admin_name)
                    {
                    $("#admin_name_error").html("Please enter the Admin Name");
                    $("#admin_name").addClass("error");
                    }
                else{
                    $("#admin_name_error").html("");
                    $("#admin_name").removeClass("error");
                    }

                    if(!role||role.length===0)
                    {
                    $("#role_error").html("Please select the admin role");
                    $("#role").addClass("error");
                    }
                else{
                    $("#role_error").html("");
                    $("#role").removeClass("error");
                    }

                    if(!adm_district||adm_district.length===0)
                    {
                    $("#adm_district_error").html("Please select the district");
                    $("#adm_district").addClass("error");
                    }
                else{
                    $("#adm_district_error").html("");
                    $("#adm_district").removeClass("error");
                    }

                    if(!email)
                    {
                    $("#email_error").html("Please enter the Email ID");
                    $("#email").addClass("error");
                    }
                else{
                    $("#email_error").html("");
                    $("#email").removeClass("error");
                    }

                    if(!mobile_number)
                    {
                    $("#mobile_number_error").html("Please enter the mobile number");
                    $("#mobile_number").addClass("error");
                    }
                else{
                    $("#mobile_number_error").html("");
                    $("#mobile_number").removeClass("error");
                    }
                    if (roleDropdown.value == 3|| roleDropdown.value ==='') {
                        if(!block||block.lengthe===0)
                        {
                            $("#block_error").html("Please select the block");
                            $("#block").addClass("error");
                        }
                        else
                        {
                            $("#block_error").html("");
                            $("#block").removeClass("error");
                        }
                        return false;
                    }
                    Swal.fire("Please fill in all required fields.");
                    return false;
                 }



            if (roleDropdown.value == 3) {
                    if(!block||block.lengthe===0)
                    {
                        $("#block_error").html("Please select the block");
                        $("#block").addClass("error");
                    }
                    else
                    {
                        $("#block_error").html("");
                        $("#block").removeClass("error");
                    }
                }

                
                
                if($('#role').val() == 2 && $('#adm_district').val() && $('#adm_district').find(':selected').data('admstatus') == 1)
                {
                    Swal.fire({
                        title: "Are you sure to deacivate the current admin?",
                        text: 'An Admin already exist for the selected district. Your action will deacivate the current admin.', 
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: "Yes",
                        denyButtonText: `No`
                        }).then((result) => {
                            
                    if (result.isConfirmed) {
                        $("#ajax-loader").show();
                        var form_data=new FormData($(this)[0]);

                        $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('admin_create_submit') }}",
                        type:"POST",
                        data:form_data,
                        dataType:"JSON",
                        processData:false,
                        contentType:false,
                        success:function(response)
                        {
                            if(response.status=="success")
                            {
                                Swal.fire({
                        title: "Admin Account was successfully created",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_admin_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_admin_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                            }

                            else{

                                Swal.fire("failed",response.message,"error");

                                $("#ajax-loader").hide();



                            }
                        },
                        error:function()
                        {
                            Swal.fire("wrong","something went wrong","error")
                        }
                    });

                    }  
                }); 
           
               } else if($('#role').val()== 3 && $('#block').val() && $('#block').find(':selected').data('admstatus') == 1)
                {


                    Swal.fire({
                        title: "Are you sure to deacivate the current admin?",
                        text: 'An Admin already exist for the selected Block. Your action will deacivate the current admin.', 
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: "Yes",
                        denyButtonText: `No`
                        }).then((result) => {
                            
                        if (result.isConfirmed) {
                            
                            

                            $("#ajax-loader").show();
                        var form_data=new FormData($(this)[0]);

                        $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('admin_create_submit') }}",
                        type:"POST",
                        data:form_data,
                        dataType:"JSON",
                        processData:false,
                        contentType:false,
                        success:function(response)
                        {
                            if(response.status=="success")
                            {
                                Swal.fire({
                        title: "Admin Account was successfully created",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_admin_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_admin_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                                
                            }

                            else{

                                Swal.fire("failed",response.message,"error");

                                $("#ajax-loader").hide();



                            }
                        },
                        error:function()
                        {
                            Swal.fire("wrong","something went wrong","error")
                        }
                    });



                            }
                        });  

                } else {         

                    $("#ajax-loader").show();
                      

                        var form_data=new FormData($(this)[0]);

                     $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('admin_create_submit') }}",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire({
                        title: "Admin Account was successfully created",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_admin_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_admin_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });

            }  
                
            }); 
            $(document).on("click",".deactivate-admin",function()
            {
                var admin=$(this).data('admin');
                $("#ajax-loader").show();

                Swal.fire({
                    title: "Are you sure to deactivate this Admin",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivateAdmin') }}",
                            type:"POST",
                            data:{admin:admin},
                            dataType:"JSON",
                            success:function(response)
                            { 
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "Admin Account was deactivated successfully",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
                         window.location.href = response.redirect;
                     }
                    });


                               // Swal.fire("Deactivated",response.message, "success");
                              // location.reload();
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Admin is not deleted", "", "info");
                    }
                });
            });  



            $('#district_admin').change(function(){
                if($(this).val() == 2){
                    $('#block').val('');
                    $('#block').prop('required',false);
                    $('#block_wrap').hide();
                    $("#role_error").html("");
                $("#role").removeClass("error");
                }
            });
            $('#block_admin').change(function(){
                if($(this).val() == 3){
                    $('#block_wrap').show();
                    $('#block').prop('required',true);
                    $("#role_error").html("");
                }
            });

            $(document).on("submit","#update_admin_details",function(e)
            {
                e.preventDefault();
                $("#mobile_number_error").val("");
                $("#email_error").val("");
                $("#district_error").val("");
                $("#block_error").val("");
                var error = false;
                if($("#mobile_number").val()==""){
                    $("#mobile_number_error").html('Please enter the Mobile Number');
                    error = true;
                }
                if($("#email").val()==""){
                    $("#email_error").html('Please enter the Email Id');
                    error = true;
                }
                if($("#adm_district").val()==""){
                    $("#district_error").html('Please select the a district');
                    error = true;
                }
                if($('#block_admin').prop('checked') && $("#block").val()==""){
                    $("#block_error").html('Please choose a block');
                    error = true;
                }
                if(error){
                    return false;
                }
                if( !$('#block_admin').prop('checked') && $('#district_admin').prop('checked') && $('#adm_district').val() && $('#adm_district').find(':selected').data('admstatus') == 1)
                {
               
                    Swal.fire({
                        title: "Are you sure to deacivate the current admin?",
                        text: 'An Admin already exist for the selected district. Your action will deacivate the current admin.', 
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: "Yes",
                        denyButtonText: `No`
                        }).then((result) => {
                            
                        if (result.isConfirmed) {
                            
                            

                            $("#ajax-loader").show();
                            var form_data=new FormData($(this)[0]);

                                $.ajax({
                                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                                    url:"{{ route('UpdateAdminDetails') }}",
                                    type:"POST",
                                    data:form_data,
                                    dataType:"JSON",
                                    processData:false,
                                    contentType:false,
                                    success:function(response)
                                    {
                                        if(response.status=="success")
                                        {
                                            Swal.fire({
                        title: "Admin account was updated successfully",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {

                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                                            
                                        }

                                        else{

                                            Swal.fire("failed",response.message,"error");

                                            $("#ajax-loader").hide();



                                        }
                                    },
                                    error:function()
                                    {
                                        Swal.fire("wrong","something went wrong","error")
                                    }
                                });



                            }
                        });  
                }
                else if( $('#block').val() && $('#block').find(':selected').data('admstatus') == 1)
                {
  
                    Swal.fire({
                        title: "Are you sure to deacivate the current admin?",
                        text: 'An Admin already exist for the selected Block. Your action will deacivate the current admin.', 
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: "Yes",
                        denyButtonText: `No`
                        }).then((result) => {
                            
                        if (result.isConfirmed) {
                            
                            

                            $("#ajax-loader").show();
                            var form_data=new FormData($(this)[0]);

                                $.ajax({
                                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                                    url:"{{ route('UpdateAdminDetails') }}",
                                    type:"POST",
                                    data:form_data,
                                    dataType:"JSON",
                                    processData:false,
                                    contentType:false,
                                    success:function(response)
                                    {
                                        if(response.status=="success")
                                        {
                                            Swal.fire({
                        title: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {

                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                                            
                                        }

                                        else{

                                            Swal.fire("failed",response.message,"error");

                                            $("#ajax-loader").hide();



                                        }
                                    },
                                    error:function()
                                    {
                                        Swal.fire("wrong","something went wrong","error")
                                    }
                                });



                            }
                        });  

                } else {
                                    $("#ajax-loader").show();
                                    var form_data=new FormData($(this)[0]);
                                    $.ajax({
                                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                                    url:"{{ route('UpdateAdminDetails') }}",
                                    type:"POST",
                                    data:form_data,
                                    dataType:"JSON",
                                    processData:false,
                                    contentType:false,
                                    success:function(response)
                                    {
                                        if(response.status=="success")
                                        {
                                            Swal.fire({
                        title: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {

                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                                        }

                                        else{

                                            Swal.fire("failed",response.message,"error");

                                            $("#ajax-loader").hide();



                                        }
                                    },
                                    error:function()
                                    {
                                        Swal.fire("wrong","something went wrong","error")
                                    }
                                });
                }
                
            }); 



            $(document).on("submit","#update_inactive_admin_details",function(e)
            {

      
                e.preventDefault();
                $("#mobile_number_error").val("");
                $("#email_error").val("");
                $("#district_error").val("");
                $("#block_error").val("");
                var error = false;
                if($("#mobile_number").val()==""){
                    $("#mobile_number_error").html('Please enter the Mobile Number');
                    error = true;
                }
                if($("#email").val()==""){
                    $("#email_error").html('Please enter the Email Id');
                    error = true;
                }
                if($("#adm_district").val()==""){
                    $("#district_error").html('Please select the a district');
                    error = true;
                }
                if($('#block_admin').prop('checked') && $("#block").val()==""){
                    $("#block_error").html('Please choose a block');
                    error = true;
                }
                if(error){
                    return false;
                }
                
                if(!$('#block_admin').prop('checked') && $('#district_admin').prop('checked') && $('#adm_district').val() && $('#adm_district').find(':selected').data('admstatus') == 1)
                {

                    Swal.fire({
                        title: "Are you sure to deacivate the current admin?",
                        text: 'An Admin already exist for the selected district. Your action will deacivate the current admin.', 
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: "Yes",
                        denyButtonText: `No`
                        }).then((result) => {
                            
                        if (result.isConfirmed) {
                            
                            

                            $("#ajax-loader").show();
                            var form_data=new FormData($(this)[0]);

                                $.ajax({
                                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                                    url:"{{ route('UpdateInactiveAdminDetails') }}",
                                    type:"POST",
                                    data:form_data,
                                    dataType:"JSON",
                                    processData:false,
                                    contentType:false,
                                    success:function(response)
                                    {
                                        if(response.status=="success")
                                        {
                                            Swal.fire({
                                                    title: "updated", 
                                                    icon: "success",
                                                    text: response.developer_message, 
                                                    type: "success"
                                                }).then(function() {
                                                    window.location.href = "{{ route('admin_list_inactive')}}";
                                                })

                                        
                                            $("#ajax-loader").hide();
                                            
                                        }

                                        else{

                                            Swal.fire("failed",response.developer_message,"error");

                                            $("#ajax-loader").hide();



                                        }
                                    },
                                    error:function()
                                    {
                                        Swal.fire("wrong","something went wrong","error")
                                    }
                                });



                            }
                        });  
                }
                else if( $('#block').val() && $('#block').find(':selected').data('admstatus') == 1)
                {


                    Swal.fire({
                        title: "Are you sure to deacivate the current admin?",
                        text: 'An Admin already exist for the selected Block. Your action will deacivate the current admin.', 
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: "Yes",
                        denyButtonText: `No`
                        }).then((result) => {
                            
                        if (result.isConfirmed) {
                            
                            

                            $("#ajax-loader").show();
                            var form_data=new FormData($(this)[0]);

                                $.ajax({
                                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                                    url:"{{ route('UpdateInactiveAdminDetails') }}",
                                    type:"POST",
                                    data:form_data,
                                    dataType:"JSON",
                                    processData:false,
                                    contentType:false,
                                    success:function(response)
                                    {
                                        if(response.status=="success")
                                        {
                                            Swal.fire({
                                                    title: "updated", 
                                                    icon: "success",
                                                    text: response.message, 
                                                    type: "success"
                                                }).then(function() {
                                                    window.location.href = "{{ route('admin_list_inactive')}}";
                                                })

                                        
                                            $("#ajax-loader").hide();
                                            
                                        }

                                        else{

                                            Swal.fire("failed",response.developer_message,"error");

                                            $("#ajax-loader").hide();



                                        }
                                    },
                                    error:function()
                                    {
                                        Swal.fire("wrong","something went wrong","error")
                                    }
                                });



                            }
                        });  

                } else {
                                    $("#ajax-loader").show();
                                    var form_data=new FormData($(this)[0]);
                                    $.ajax({
                                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                                    url:"{{ route('UpdateInactiveAdminDetails') }}",
                                    type:"POST",
                                    data:form_data,
                                    dataType:"JSON",
                                    processData:false,
                                    contentType:false,
                                    success:function(response)
                                    {
                                        if(response.status=="success")
                                        {
                                            Swal.fire({
                                                    title: "updated", 
                                                    icon: "success",
                                                    text: response.message, 
                                                    type: "success"
                                                }).then(function() {
                                                    window.location.href = "{{ route('admin_list_inactive')}}";
                                                })

                                        
                                            $("#ajax-loader").hide();
                                            
                                        }

                                        else{

                                            Swal.fire("failed",response.developer_message,"error");

                                            $("#ajax-loader").hide();



                                        }
                                    },
                                    error:function()
                                    {
                                        Swal.fire("wrong","something went wrong","error")
                                    }
                                });
                }
                
            }); 



            $(document).on("click",".deactivate-course",function()
            {
                var course=$(this).data('course-id');

                Swal.fire({
                    title: "Are you sure to delete Course?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivateCourseFromList') }}",
                            type:"POST",
                            data:{course:course},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "The course master was removed successfully.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("The Course master is safe", "", "info");
                    }
                });
            });

            $('#districtdropdown').change(function(){

                var idDistrict=$('#districtdropdown').val();
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-localbody/" + idDistrict,
                    data: { idDistrict: idDistrict },
                    success: function (data) {
                        console.log(data);
                        $('#lbdropdown').html('<option value="">-- Select Local Body --</option>');
                        $.each(data.data, function (index, value) {
                            $('#lbdropdown').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            });
        });

        function calculateSum() {

            var sum = 0;
            //iterate through each textboxes and add the values
            $(".seats").each(function() {
                //add only if the value is number
                if(!isNaN(this.value) && this.value.length!=0) {
                    sum += parseInt(this.value);
                }

            });
            $('#total').val(sum);
        }

    </script>

    <script>

    $(document).ready(function()
    {
        document.getElementById('pia_doc').addEventListener('keyup', function() {
  var fileInput = this;
  var errorMessage = document.getElementById('errorMessage');

  // Check if a file is selected
  if (fileInput.files.length > 0) {
    var fileSize = fileInput.files[0].size; // Size in bytes
    var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

    if (fileSize > maxSize) {
      errorMessage.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
      errorMessage.style.color = 'red';
      // Clear the selected file
      fileInput.value = '';
    } else {
      errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
      errorMessage.style.color = '#858796'; // Reset to default color
    }
  } else {
    errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
    errorMessage.style.color = '#858796'; // Reset to default color if no file selected
  }
});
    });


    </script>

<script>

$(document).ready(function()
{
    $(document).on("change","#employer_doc",function()
    {
        var file_size=$(this)[0].files[0].size/(1024*1024);
        var file_type=$(this)[0].files[0].type;

       

        if(file_type!="application/pdf")
        {
            Swal.fire("Error","Only pdf allowed","error");

            $("#employer_doc").val("");
        }

        else if(file_size>2)
        {
            Swal.fire("Error","Maximun 2MB allowed","error");

            $("#employer_doc").val("");

        }
    });
});


</script>

<script>

    $(document).ready(function()
    {
        document.getElementById('pia_doc').addEventListener('change', function() {
  var fileInput = this;
  var errorMessage = document.getElementById('errorMessage');

  // Check if a file is selected
  if (fileInput.files.length > 0) {
    var fileSize = fileInput.files[0].size; // Size in bytes
    var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

    if (fileSize > maxSize) {
      errorMessage.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
      errorMessage.style.color = 'red';
      // Clear the selected file
      fileInput.value = '';
    } else {
      errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
      errorMessage.style.color = '#858796'; // Reset to default color
    }
  } else {
    errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
    errorMessage.style.color = '#858796'; // Reset to default color if no file selected
  }
});

        $(document).on("keyup","#agency_name",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Agency Name.";
            }

            else if(length>50){

                message+="Maximum 50 characters will be allowed"

            }
            else{
                message="";

                $("#agency_name").removeClass("error");
            }


            $("#agency_name_error").html(message);



        });
        

        $(document).on("keyup","#employer_name",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Employer Name";
            }

            else if(length>50){

                message+="Maximum 50 characters will be allowed"

            }
            else{
                message="";

                $("#employer_name").removeClass("error");
            }

            $("#employer_name_error").html(message);



        });

        $(document).on("keyup","#building_number",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Building Number/Name";
            }

            else if(length>50){

                message+="Maximum 50 characters will be allowed"

            }
            else{
                message="";

                $("#building_number").removeClass("error");
            }

            $("#building_number_error").html(message);



        });

        $(document).on("keyup","#street_name",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Street, Landmark";
            }

            else if(length>50){

                message+="Maximum 50 characters will be allowed"

            }
            else{
                message="";
                $("#street_name").removeClass("error");
            }

            $("#street_name_error").html(message);



        });

        $(document).on("keyup","#landmark",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Landmark";
            }

            else if(length>50){

                message+="Maximum 50 characters will be allowed"

            }
            else{
                message="";
                $("#landmark").removeClass("error");
            }

            $("#landmark_error").html(message);



        });

        $(document).on("keyup","#phone_number",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length>0 && length<10)
            {
                message+="Please enter a valid phone number";
            }

            else if(length>12){

                message+="Maximum 12 numbers will be allowed for Phone Number"

            }
            else{
                message="";
                $("#phone_number").removeClass("error");
            }

            $("#phone_number_error").html(message);



        });

        $(document).on("keyup","#contact_number",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length>0 && length<10)
            {
                message+="Please enter a valid Contact Number";
            }

            else if(length>12){

                message+="Maximum 12 numbers will be allowed for Contact Number"

            }
            else{
                message="";
                $("#contact_number").removeClass("error");
            }

            $("#contact_number_error").html(message);



        });

        $(document).on("keyup","#mobile_number",function(e)
        { 

            var length=$(this).val().length;

            var message="";

            if(length!=10)
            {
                message+="Please provide a valid Mobile Number";
            }
            else{
                message="";
                $("#mobile_number").removeClass("error");
            }

            
            $("#mobile_number_error").html(message);



        });

        $(document).on("keyup","#pan_number",function(e)
        {

            var length=$(this).val().length;

            var panNum = $("#pan_number").val();

            var regpan = /^([A-Z]){5}([0-9]){4}([A-Z]){1}?$/;

            var message="";

            if((regpan.test(panNum) == false))
            {
                message+="Pan Number critera not met!";
            }
            else{
                message="";
                $("#pan_number").removeClass("error");
            }

            
            $("#pan_number_error").html(message);



        });

        $(document).on("keyup","#post_office",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length==0)
            {
                message+="Please enter the Post Office Name";
            }

            else if(length>25){

                message+="Post office name should not exceed 25 letters";
            }
            else{
                message="";
                $("#post_office").removeClass("error");
            }

            
            
            $("#post_office_error").html(message);



        });

        $(document).on("keyup","#pincode",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length!=6)
            {
                message+="Please enter the Pincode";
            }
            else{
                message="";
                $("#pincode").removeClass("error");
            }

            
            $("#pincode_error").html(message);



        });
        
        $("#email").on("keyup", function() {
    var emailInput = $(this).val();
    var emailError = $("#email_error");

    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

    if (!emailRegex.test(emailInput)) {
      emailError.text('Please enter a valid email address.');
      emailError.show();
    } else {
      emailError.hide();

$("#email").removeClass("error");
    }
  });
  $("#sectordropdown").on("change blur", function() {
    var selectedOptions = $(this).find(":selected");

    if (selectedOptions.length > 0) {
        // Option selected
        $("#sectordropdown_error").html('');
        $(".multiselect").removeClass("error");
    } else {
        // No option selected
        $("#sectordropdown_error").html('Please select the sector');
        $(".multiselect").addClass("error");
    }
});
$("#tradedropdown").on("change blur", function() {
    var selectedOptions = $(this).find(":selected");

    if (selectedOptions.length > 0) {
        // Option selected
        $("#tradedropdown_error").html(''); // Clear error message
        $(".multiselect").removeClass("error"); // Remove error class
    } else {
        // No option selected
        $("#tradedropdown_error").html('Please select at least one trade');
        $(".multiselect").addClass("error"); // Add error class
    }
});


$("#district").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#district_error").html('Please select the District');
    } else {
        $("#district_error").html('');
        $("#district").removeClass("error");
    }
  });
$("#state").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#state_error").html('Please select the State');
    } else {
        $("#state_error").html('');
        $("#state").removeClass("error");
    }
  });
    });


</script>

<script>

$(document).ready(function()
{
    $(document).on("keyup","#trade_name",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the Trade Name";
        }

        else if(length>80){

            message+="Maximum of 80 characters allowed"

        }

        $("#trade_name_error").html(message);



    });

    $(document).on("keyup","#course_code",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the course code";
        }

        else if(length>10){

            message+="Maximum of 10 characters allowed"

        }

        $("#course_code_error").html(message);



    });

    $(document).on("keyup","#skill",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the skill name";
        }

        else if(length>20){

            message+="Maximum of 20 characters allowed"

        }
        else{
            message="";

            $("#skill").removeClass("error");

        }

        $("#skill_error").html(message);

    });

    // $(document).on("keyup","#duration",function(e)
    // {

    //     var length=$(this).val().length;

    //     var message="";

    //     if(length<1)
    //     {
    //         message+="Provide atleast one character for Course Duration";
    //     }

    //     else if(length>20){

    //         message+="Maximum of 20 characters allowed"

    //     }

    //     $("#duration_error").html(message);

    // });

});


</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#submit_skill_details",function(e) {
            var skill = $("#skill").val();

            if (!skill)
            {
                
                if(!skill)
                {
                    $("#skill_error").html("Please enter the skill name.");
                    $("#skill").addClass("error");
                }
                else{
                    $("#skill_error").html("");
                    $("#skill").removeClass("error");
                } 

                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#plwait").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);

            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('submitSkillDetails') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Skill was successfully created.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_skill_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_skill_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#plwait").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#plwait").hide();
                }
            });
        });
    });
    
</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#update_skill_details",function(e) {
            var skill = $("#skill").val();

            if (!skill)
            {
                
                if(!skill)
                {
                    $("#skill_error").html("Please enter a valid skill");
                    $("#skill").addClass("error");
                }
                else{
                    $("#skill_error").html("");
                    $("#skill").removeClass("error");
                } 

                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#plwait").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);

            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
                url: "{{ route('updateSkillDetails') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "Skill was successfully updated.",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#update_skill_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#update_skill_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#plwait").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#plwait").hide();
                }
            });
        });
    });
        </script>

        <script>

            $(document).ready(function()
            {

                $(document).on("submit","#submit_sector_details",function(e)
                {
                    e.preventDefault();

                    $("#response_message").html("");
                   
                    var sector_name=$("#sector_name").val();
                    var sector_code=$("#sector_code").val();

                    if(!sector_name || !sector_code)
                    {

                        if(!sector_name)
                        {
                            $("#sector_name_error").html("Please enter sector name");
                            $("#sector_name").addClass("error");

                        }

                        if(!sector_code)
                        {
                            $("#sector_code_error").html("Please enter code");
                            $("#sector_code").addClass("error");
                        }
                        


                        Swal.fire("Please fill in all required fields.");
                        return false;
                    }

                    else{

                        $("#plwait").show();

                        var form_data=new FormData($(this)[0]);

                        $.ajax({

                            url:"{{ route('adminSubmitSector') }}",
                            type:"POST",
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            data:form_data,
                            dataType:"JSON",
                            processData:false,
                            contentType:false,
                            success:function(response)
                            {
                                $("#plwait").hide();

                                if(response.status=="success")
                                {
                                    Swal.fire("success",response.message,"success").then(function(result)
                                    {
                                        if(result.isConfirmed)
                                        {
                                            window.location.href="{{ route('sectorList') }}";
                                        }
                                    });
                                }

                                else
                                {

                                    Swal.fire("error",response.message,"error");
                                
                                }


                            }
                        });
                    }


                });

                $(document).on("submit","#update_sector_details",function(e)
                {
                    e.preventDefault();

                    $("#response_message").html("");
                   
                    var sector_name=$("#sector_name").val();
                    var sector_code=$("#sector_code").val();

                    if(!sector_name || !sector_code)
                    {

                        if(!sector_name)
                        {
                            $("#sector_name_error").html("Please enter sector name");
                            $("#sector_name").addClass("error");

                        }


                        if(!sector_code)
                        {
                            $("#sector_code_error").html("Please enter code");
                            $("#sector_code").addClass("error");
                        }
                        


                        Swal.fire("Please fill in all required fields.");
                        return false;
                    }

                    else{

                        $("#plwait").show();

                        var form_data=new FormData($(this)[0]);

                        $.ajax({

                            url:"{{ route('adminUpdateSector') }}",
                            type:"POST",
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            data:form_data,
                            dataType:"JSON",
                            processData:false,
                            contentType:false,
                            success:function(response)
                            {
                                $("#plwait").hide();

                                if(response.status=="success")
                                {
                                    Swal.fire("success",response.message,"success").then(function(result)
                                    {
                                        if(result.isConfirmed)
                                        {
                                            window.location.href="{{ route('sectorList') }}";
                                        }
                                    });
                                }

                                else
                                {
                                    $("#response_message").html(response.message);
                                }


                            }
                        });
                    }


                });

                $(document).on("keyup","#sector_name",function()
                {
                    $("#sector_name_error").html("");
                    $("#sector_name").removeClass("error");
                });

                $(document).on("keyup","#sector_code",function()
                {
                    $("#sector_code_error").html("");
                    $("#sector_code").removeClass("error");
                });
              
            });

        
        </script>

<script>
    $(document).on("click",".deactivate-user",function(){
        $("#ajax-loader").show();
                var candidate = $('#cid').val(); 
              
                if (typeof candidate === 'undefined') {
                // Get the candidate ID from the data-candidate-id attribute
                var candidateID = $(this).data('user-id');
                var candidate = decodeURIComponent(atob(candidateID));


        // Now you can use the candidateId as needed
             }
                
                Swal.fire({
                    title: "Are you sure to deactivate Candidate?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivateUser') }}",
                            type:"POST",
                            data:{candidate:candidate},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {

                                $("#ajax-loader").hide();
                                Swal.fire({
                        title: "Candidate was deactivated successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                $("#ajax-loader").hide();

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        $("#ajax-loader").hide();
                        Swal.fire("candidate is safe", "", "info");
                    }
                    else{
                        
                        $("#ajax-loader").hide();
                    }
                });
            });
            $(document).on("click",".deactivate-candidate",function(){
    $("#ajax-loader").show();
                var candidate = $('#cid').val(); 
              
                if (typeof candidate === 'undefined') {
                // Get the candidate ID from the data-candidate-id attribute
                var candidateID = $(this).data('candidate-id');
                var candidate = decodeURIComponent(atob(candidateID));


        // Now you can use the candidateId as needed
             }
                
                Swal.fire({
                    title: "Are you sure to deactivate Candidate?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $("#plwait").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                            url:"{{ route('deactivateCandidate') }}",
                            type:"POST",
                            data:{candidate:candidate},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {

                                $("#ajax-loader").hide();
                                Swal.fire({
                        title: "Candidate was deactivated successfully..",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                $("#ajax-loader").hide();

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        $("#ajax-loader").hide();
                        Swal.fire("candidate is safe", "", "info");
                    }else{
                        
                        $("#ajax-loader").hide();
                    }
                });
            });
   </script> 

   <script>

       $(document).ready(function()
       {
           $(document).on("click",".generate-report",function()
           {
               var report_type=$(this).attr('id');

               $("input[name='report_type']").val(report_type);
           });

           $(document).on("submit","#generate_report",function(e)
           {

               $(this).submit();
           });
       });


   </script>

   <script>

       $(document).ready(function()
       {
           $(document).on("change","#generate_report #pia_filter",function()
           {
              var pia_filter=$(this).val();
              var sector_filter=$("#sector_filter").val();

              $.ajax({
                headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                url:"{{ route('adminPiaReportResetCoursesPiaReport') }}",
                type:"POST",
                data:{pia_filter:pia_filter,sector_filter:sector_filter},
                dataType:"JSON",
                success:function(response)
                {
                    if(response.status=="success")
                    {
                        $("#course_filter").html("<option value=''>All Courses</option>");

                        var filter_status=false;

                        response.course_masters.forEach(function(course_master)
                        {

                            if(course_master.encoded_id==course_filter)
                            {
                                

                                filter_status=true;
                            }

                            $("#course_filter").append("<option value='"+course_master.encoded_id+"'>"+course_master.tradename+"</option>");
                        });

                        if(filter_status)
                        {
                            $("#course_filter").val(course_filter);
                        }
                    }
                }
              });

              var course_filter=$("#course_filter").val();
                var pia_filter=$(this).val();

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminPiaReportResetSectors') }}",
                    type:"POST",
                    data:{pia_filter:pia_filter,course_filter:course_filter},
                    dataType:"JSON",
                    success:function(response)
                    {
                        $("#sector_filter").html("<option value=''>All Sectors</option>");

                        var filter_status=false;

                        response.sectors.forEach(function(sector)
                        {

                            if(sector.encoded_id==sector_filter)
                            {
                                $("#sector_filter").val(sector.encoded_id);

                                filter_status=true;
                            }
                            $("#sector_filter").append("<option value='"+sector.encoded_id+"'>"+sector.name+"</option>");
                        });

                        if(filter_status)
                        {
                            $("#sector_filter").val(sector_filter);

                            filter_status=true;
                        }


                    }
                });

              
           });

        $(document).on("change","#generate_report #sector_filter",function()
           {
              var pia_filter=$("#pia_filter").val();
              var sector_filter=$(this).val();
              var course_filter=$("#course_filter").val();

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminPiaReportResetCoursesPiaReport') }}",
                    type:"POST",
                    data:{pia_filter:pia_filter,sector_filter:sector_filter},
                    dataType:"JSON",
                    success:function(response)
                    {

                        var filter_status=false;

                        if(response.status=="success")
                        {
                            $("#course_filter").html("<option value=''>All Courses</option>");

                            response.course_masters.forEach(function(course_master)
                            {

                                if(course_master.encoded_id==course_filter)
                                {
                                    

                                    filter_status=true;
                                }

            
                                $("#course_filter").append("<option value='"+course_master.encoded_id+"'>"+course_master.tradename+"</option>");
                            });

                            if(filter_status)
                            {
                                $("#course_filter").val(course_filter);
                            }
                        }
                    }
                });

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminPiaReportResetPias') }}",
                    type:"POST",
                    data:{course_filter:course_filter,sector_filter:sector_filter},
                    dataType:"JSON",
                    success:function(response)
                    {
                        if(response.status=="success")
                        {

                            var filter_status=false;
                            $("#pia_filter").html("<option value=''>All Pias</option>");

                            response.pias.forEach(function(pia)
                            {

                                if(pia.encoded_id==pia_filter)
                                {
                                    filter_status=true;
                                }
                                $("#pia_filter").append("<option value='"+pia.encoded_id+"'>"+pia.agency_name+"</option>");
                            });

                            if(filter_status)
                            {
                                $("#pia_filter").val(pia_filter);
                            }
                        }
                    }
                });

              
           });

           $(document).on("change","#generate_report #course_filter",function()
           {
                var course_filter=$(this).val();
                var pia_filter=$("#pia_filter").val();
                var sector_filter=$("#sector_filter").val();

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminPiaReportResetSectors') }}",
                    type:"POST",
                    data:{pia_filter:pia_filter,course_filter:course_filter},
                    dataType:"JSON",
                    success:function(response)
                    {
                        $("#sector_filter").html("<option value=''>All Sectors</option>");

                        var filter_status=false;

                        response.sectors.forEach(function(sector)
                        {

                            if(sector.encoded_id==sector_filter)
                            {
                                filter_status=true;
                            }
                            $("#sector_filter").append("<option value='"+sector.encoded_id+"'>"+sector.name+"</option>");
                        });

                        if(filter_status)
                        {
                            $("#sector_filter"),val(sector_filter);
                        }
                    }
                });

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                    url:"{{ route('adminPiaReportResetPias') }}",
                    type:"POST",
                    data:{course_filter:course_filter,sector_filter:sector_filter},
                    dataType:"JSON",
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            $("#pia_filter").html("<option value=''>All Pias</option>");

                            var filter_status=false;

                            response.pias.forEach(function(pia)
                            {

                                if(pia.encoded_id==pia_filter)
                                {
                                    filter_status=true;
                                }
                                $("#pia_filter").append("<option value='"+pia.encoded_id+"'>"+pia.agency_name+"</option>");
                            });

                            if(filter_status)
                            {
                                $("#pia_filter").val(pia_filter);
                            }
                        }
                    }
                });
           });


       });

   </script>



   <script>

      $(document).ready(function()
      {
           $(document).on("change","#district_filter",function()
           {
               var district=$(this).val();

               if(district!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('loadBlocksReport') }}",
                        type:"POST",
                        data:{district:district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var blocks=response.blocks;

                                $("#block_filter").html("");

                                $("#block_filter").append("<option value=''>All Blocks</option>");

                                blocks.forEach(function(block)
                                {
                                    $("#block_filter").append("<option value='"+block.encoded_id+"'>"+block.name+"</option>");
                                });
                           }
                        }
                    });

                }

                else{

                    $("#block_filter").html("");



                }
           });
      });


    </script>

   

</body>

</html>