    
@extends('employer.layouts.app')

@section('title','Job Vacancy List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Job Vacancy List </h1>
            <a href="{{ route('createJobVacancy') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Create New</a>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                    <!-- Card Body -->
                    <div class="card-body">
                    
                        <div class="table-responsive">
                        
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Job Vacancy Name</th>
                                        <th>Job Code</th>
                                        <th>Description</th>                                       
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($job_list as $job)
                                    <tr>
                                        <td>{{ $job->name  }}</td>
                                        <td>{{ $job->code }}</td>
                                        <td>{{ $job->description }}</td>

                                        <td>
                                            @if(auth()->user()->user_role_id==5)
                                                <a href="{{ route('viewJobVacancy',['job'=>base64_encode($job->id)]) }}" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            @endif

                        
                                            @if(auth()->user()->user_role_id==5 and auth()->user()->id == $job->employer_id )
                                                <a href="{{ route('editJobVacancy',['job'=>base64_encode($job->id)]) }}" class="btn btn-success btn-circle btn-sm" title="Edit">
                                                    <i class="fas fa-pen"></i>
                                                </a>
                                           <!--     <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-job" data-job-id="{{ base64_encode($job->id ) }}">
                                                    <i class="fas fa-trash"></i>
                                                </a>-->
                                            @endif
                                    
                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection