   
   @extends('employer.layouts.app')


@section('title','edit Job Vacancy')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Edit the Job Vacancy</h1>
     <a href="{{ route('JobVacanciesList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Job Vacancy List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="update_job_details" action="post" method="{{ route('updateJobVacancyDetails') }}">
                     <div class="row">

                       @csrf

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Job Vacancy Name<span style="color:red">*</span></label>
                                 <input id="vacancy_name" type="text" class="form-control" maxlength="80" name="vacancy_name"
                                     placeholder="Job Vacancy Name" value="{{ $job->name }}">
                                     <span id="vacancy_name_error" style="color:red;"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Job Code<span style="color:red">*</span></label>
                                 <input id="vacancy_code" type="text" name="job_code" maxlength="10" class="form-control" value="{{ $job->code }}" >
                                 <span id="code_error" style="color:red;"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Location<span style="color:red">*</span></label>
                                 <input id="location" type="text" name="job_location" 
                                    class="form-control" placeholder="Job Location" maxlength="50" value="{{ $job->location }}" >
                                 <span id="location_error" style="color:red;"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Qualification<span style="color:red">*</span></label>
                                 <input id="qualification" type="text" name="qualification" 
                                    class="form-control" placeholder="Qualification" value="{{ $job->qualification }}" >
                                 <span id="qualification_error" style="color:red;"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Salary<span style="color:red">*</span></label>
                                 <input id="salary" type="text" name="salary" 
                                    class="form-control" placeholder="Salary" maxlength="50" value="{{ $job->salary }}">
                                 <span id="salary_error" style="color:red;"></span>
                             </div>
                         </div>

                         <input type="hidden" name="id" value="{{ $job->id }}">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Skill<span style="color:red;">*</span></label><br>
                                <div class="form-group">
                                    <select id="skill" name="Skill[]" id="Skill" class="chosen-select" multiple >
                                                       
                                        @foreach($skills as $skill)
                                            <option  value="{{ $skill->id }}" 
                                                @foreach($job->SkillList as $course_skill)
                                                    @if($course_skill->skill_id==$skill->id)
                                                        selected="selected"
                                                    @endif
                                                @endforeach
                                                />
                                                {{ $skill->name  }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <span id="skill_error" style="color:red;"></span>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Description<span style="color:red">*</span></label>
                                <input id="description" type="text" name="description" maxlength="200" class="form-control" value="{{ $job->description }}">
                                <span id="description_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Upload Image</label>
                                <input type="file" class="form-control" id="job_doc" name="attachment"accept=".jpeg" >
                                    <small>(Max size: 2 MB)</small>
                                    <br>
                                     <span id="errorMessage"  style="color:red;">Only Jpeg images of maximum size of 2MB and Max 1600 x 1600 pixels allowed</span>

                                     @if($job->attachment) 

                                     <img src="{{ asset('storage/job_vacancy_docs/'.$job->attachment) }}" class="img-fluid" >

                                    @endif <br>
                             </div>
                        </div>

                      
                        
                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="plwait" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Update</button>
                             <button type="reset" class="btn btn-default"><a href="{{ route('JobVacanciesList')}}">Cancel</a></button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection