   
   @extends('admin.layouts.app')


@section('title','View Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $employer->name }} Details</h1>
     <a href="{{ url('/admin/employer-list') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>
    
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                
                     <div class="row">
                     <div class="col-md-12">
                             <div class="form-group">
                             <a href="{{ url()->previous() }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Back to List</a>
</div>
</div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Employer Name</b></label><br>
                                 {{ $employer->name  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Building Number</b></label><br>
                                {{ $employer->building_name }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Landmark</b></label><br>
                                {{ $employer->landmark  }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Country</b></label><br>
                                 <div class="form-group">
                                    {{ $employer->Country->name }}
                                 </div>
                                 
                             </div>
                         </div>

                         

                       

                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>State</b></label><br>
                                 <div class="form-group">
                                    {{ $employer->State->name }}
                                 </div>
                                 
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>District</b></label><br>
                                 <div class="form-group">
                                    {{ $employer->District->name }}
                                 </div>
                                 
                             </div>
                         </div>

                        
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Contact Number</b></label><br>
                                {{$employer->phone_number }}
                             </div>
                         </div>

                         

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>PAN Number</b></label><br>
                                 {{ $employer->pan_number }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Post Office</b></label><br>
                                 {{ $employer->postOffice }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Pincode</b></label><br>
                                 {{ $employer->pincode }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email Id</b></label><br>
                                {{ $employer->email }}
                               

                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Prefered location</b></label><br>
                                {{ $employer->prefered_location  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Cover Area</b></label><br>
                                {{ $employer->cover_area  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Agency Name</b></label><br>
                                {{  $agency[0] }}
                               

                             </div>
                         </div>
                        

                         @if($employer->document_upload)

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Supporting Document</b></label><br>
                                
                                    
                                   
                                     <a href="{{ asset('storage/employer_docs/'.$employer->document_upload)}}" target="_blank" >Click Here to view document</a>
                                    

                             </div>
                         </div>

                         @endif

                         <div class="col-md-6">

                            <div class="form-group">

                         
                         @if($employer->approval_status==11 && (is_null($employer->approved_by) && is_null($employer->rejected_by)))

                            @if(auth()->user()->user_role_id==1)

                                <a href="#" class="btn btn-success  approve-employer" data-employer="{{ base64_encode($employer->id) }}" title="Approve">
                                Approve</a>

                                <a href="#" class="btn btn-danger  reject-employer" data-employer="{{ base64_encode($employer->id) }}" title="Reject">
                                               Reject </a>

                            @elseif(auth()->user()->user_role_id==2 && (auth()->user()->district_id==$employer->district_id))

                            <a href="#" class="btn btn-success  approve-employer" data-employer="{{ base64_encode($employer->id) }}" title="Approve">Approve </a>

                            <a href="#" class="btn btn-danger  reject-employer" data-employer="{{ base64_encode($employer->id) }}" title="Reject">
                            Reject
                            </a>

                            @endif

                        @endif

                            </div>

                       </div>

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>





                     </div>
                    
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection