@extends('admin.layouts.app')

@section('title','Employer details updation requests')

@section('content')




<!-- Begin Page Content -->
<div class="container-fluid">


    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h4 mb-0 text-gray-800">Requests for employer details updation </h1>

        <a href="{{ route('adminEmployerList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                class="fas fa-add fa-sm text-white-50"></i> Employer List</a>


    </div>

    <div class="row">
        <!-- list -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in
                            progress</div>
                        <table class="table table-striped table-hover" id="dataTable">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Employer Name</th>
                                    <th>Agency</th>
                                    <th>View</th>
                                </tr>
                            </thead>
                            <tbody>


                                @foreach($requests as $key=>$update)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{ $update->Employer->name }}</td>
                                    <td>{{ $update->Pia->Piaid->agency_name }}</td>

                                    <td>

                                        <a href="{{ route('adminEmployerUpdationRequest',['id'=>base64_encode($update->id)]) }}"
                                            class="btn btn-info btn-circle btn-sm" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>

                                @endforeach



                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->
            </div>
        </div>
        <!-- list -->
    </div>

</div>
<!-- /.container-fluid -->

<!--</div>-->

@endsection