   
@extends('admin.layouts.app')


@section('title','View Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $update_request->Employer->name }} Update request</h1>
     <a href="{{ url('/admin/employer-list') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>
    
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                
                     <div class="row">

                    

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Employer Name</b></label><br>
                                 {{ $update_request->Employer->name  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Building Number</b></label><br>
                                {{ $update_request->building_name }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Landmark</b></label><br>
                                {{ $update_request->landmark  }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Country</b></label><br>
                                 <div class="form-group">
                                    {{ $update_request->Country->name }}
                                 </div>
                                 
                             </div>
                         </div>

                         

                       

                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>State</b></label><br>
                                 <div class="form-group">
                                    {{ $update_request->State->name }}
                                 </div>
                                 
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>District</b></label><br>
                                 <div class="form-group">
                                    {{ $update_request->District->name }}
                                 </div>
                                 
                             </div>
                         </div>

                        
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Contact Number</b></label><br>
                                {{ $update_request->phone_number }}
                             </div>
                         </div>


                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Post Office</b></label><br>
                                 {{ $update_request->postOffice }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Pincode</b></label><br>
                                 {{ $update_request->pincode }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Prefered location</b></label><br>
                                 {{ $update_request->prefered_location }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Cover area</b></label><br>
                                 {{ $update_request->cover_area }}
                             </div>
                         </div>

                         @if(auth()->user()->user_role_id==1 && $update_request->approval_status==11 && is_null($update_request->processed_by))

                         <div class="col-md-6">
                             <div class="form-group">
                                <a href="javascript:void(0)" data-approval-status="1" data-request-id="{{ base64_encode($update_request->id) }}" class="process-employer-update-request btn btn-primary">Approve</a>
                                <a href="javascript:void(0)" data-approval-status="11" data-request-id="{{ base64_encode($update_request->id) }}" class="process-employer-update-request btn btn-danger">Reject</a>
                                
                             </div>
                         </div>

                         @elseif(auth()->user()->user_role_id==2 && ($update_request->Employer->district_id==auth()->user()->district_id) && $update_request->approval_status==11 && is_null($update_request->processed_by))

                         <div class="col-md-6">
                             <div class="form-group">
                                <a href="javascript:void(0)" data-approval-status="1" data-request-id="{{ base64_encode($update_request->id) }}" class="process-employer-update-request btn btn-primary">Approve</a>
                                <a href="javascript:void(0)" data-approval-status="11" data-request-id="{{ base64_encode($update_request->id) }}" class="process-employer-update-request btn btn-danger">Reject</a>
                                
                             </div>
                         </div>

                         @endif

                         <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>

                     </div>
                    
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection