   
   @extends('admin.layouts.app')


@section('title','Edit Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Edit Employer</h1>
     <a href="{{ url('/admin/employer-list') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="update_employer_details" action="post" method="javascript:void(0)">
                     <div class="row">

                       @csrf

                       <input type="hidden" name="id" value="{{ $user->id }}">

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Employer Name<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="employer_name"
                                     placeholder="Employer Name" value="{{ $user->name }}" readonly>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Building Number<span style="color:red">*</span></label>
                                 <input type="text" name="building_number" class="form-control" value="{{ $user->building_name }}" placeholder="Building Number">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Landmark<span style="color:red">*</span></label>
                                 <input type="text" name="landmark" class="form-control" placeholder="Landmark" value="{{ $user->landmark }}">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Country<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="country" class="form-control" id="country" required>
                                         <option value="">Choose Country</option>

                                         @foreach($countries as $country)
                                            @if($country->id==$user->country_id)
                                            <option selected="selected" value="{{ $country->id }}">{{ $country->name }}</option>
                                            @else
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endif
                                         @endforeach

                                     </select>
                                 </div>
                                 
                             </div>
                         </div>
                         
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">State<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="state" class="form-control" id="state" required>
                                         <option value="">Choose State</option>

                                         @foreach($states as $state)
                                            @if($state->id==$user->state_id)
                                            <option selected="selected" value="{{ $state->id }}">{{ $state->name }}</option>
                                            @else
                                            <option value="{{ $state->id }}">{{ $state->name }}</option>
                                            @endif
                                         @endforeach

                                     </select>
                                 </div>
                                 
                             </div>
                         </div>
                         
                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">District<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="district" class="form-control" id="district" required>
                                         <option value="">Choose District</option>

                                         @foreach($districts as $district)
                                            @if($district->id==$user->district_id)
                                            <option selected="selected" value="{{ $district->id }}">{{ $district->name }}</option>
                                            @else
                                            <option value="{{ $district->id }}">{{ $district->name }}</option>
                                            @endif
                                         @endforeach

                                     </select>
                                 </div>
                                 
                             </div>
                         </div>

                         

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Contact Number<span style="color:red;">*</span></label>
                                 <input type="text" class="form-control" name="contact_number"
                                     placeholder="Contact Number" value="{{ $user->phone_number }}">
                             </div>
                         </div>

                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">PAN Number<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pan_number"
                                     placeholder="PAN Number" value="{{ $user->pan_number}}" readonly>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Post Office<span style="color:red">*</span></label>
                                 <input type="text" name="post_office" class="form-control" placeholder="Post Office" value="{{ $user->postOffice }}" >
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Pincode<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pincode"
                                     placeholder="PINCODE" value="{{ $user->pincode }}">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Email Id<span style="color:red">*</span></label>
                                 <input type="email" class="form-control" name="email"
                                     placeholder="Email Id" value="{{ $user->email }}" readonly>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Prefered location<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="prefered_location"
                                     placeholder="Prefered location" value="{{ $user->prefered_location }}">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Cover Area<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="cover_area"
                                     placeholder="Cover Area" value="{{ $user->cover_area }}">
                             </div>
                         </div>

                         @if($user->Document_Upload)


                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Supporting Document</label>
                                 

                                    
                                        <a href="{{ asset('storage/employer_docs/'.$user->document_upload) }}" target="_blank">Click Here to view the document</a>

                                    
                             </div>
                         </div>

                         @endif

                         



                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Update</button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection