    
    @extends('admin.layouts.app')

@section('title','Employer List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Employer List </h1>
           
            <a href="{{ route('adminEmployerList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Active Employers</a>
           
        
        </div>

        <div class="row">

        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in
                            progress</div>

       

            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                    <div style="text-align: right;">
                    <a href="{{ route('adminApprovalPendingEmployersList') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Approval Pending</a> <a href="{{ route('adminDeactivatedEmployersList') }}" class="d-none d-sm-inline-block btn btn-sm btn-warning shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Deactivated Employers</a>
</div><br/>
                    
                        <div class="table-responsive">

                     
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Employer Name</th>
                                        <th>District</th>
                                        <th>Contact Number</th>
                                        <th>Email Id</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($employers as $key=>$employer)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $employer->name  }}</td>
                                        <td>{{ $employer->District->name }}</td>
                                        <td>{{ $employer->phone_number }}</td>
                                        <td>{{ $employer->email }}</td>

                                        <td>

                                           <div class="alert alert-danger">Deactivated</div>
                                        </td>
                                        
                                        <td>

                                            <a href="{{ route('adminViewEmployer',['id'=>base64_encode($employer->id)]) }}" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                            @if(auth()->user()->user_role_id==1)


                                               

                                               
                                               
                                                <a href="#" class="reactivate-employer" data-employer="{{ base64_encode($employer->id) }}" title="reactivate">
                                                <img src="{{ asset('img/ACTIVATE.svg') }}">
                                                    </a>


                                               


                                               

                                            @endif
                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection