   
   @extends('admin.layouts.app')


@section('title','Add Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Add Employer</h1>
    

                    
                     <a href="{{ route('adminEmployerList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>

           
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="submit_employer_details" action="post" method="javascript:void(0)">
                     <div class="row">

                       @csrf

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Employer Name<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="employer_name"
                                     placeholder="Employer Name">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Building Number<span style="color:red">*</span></label>
                                 <input type="text" name="building_number" class="form-control" placeholder="Building Number">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Landmark<span style="color:red">*</span></label>
                                 <input type="text" name="landmark" class="form-control" placeholder="Landmark">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Country<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="country" class="form-control" id="country" required>
                                         <option value="">Choose Country</option>

                                         @foreach($countries as $country)

                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                         @endforeach

                                     </select>
                                 </div>
                                 
                             </div>
                         </div>
                         
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">State<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="state" class="form-control" id="state" required>
                                         <option value="">Choose State</option>

                                     </select>
                                 </div>
                                 
                             </div>
                         </div>
                         
                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">District<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="district" class="form-control" id="district" required>
                                         <option value="">Choose District</option>
                                     </select>
                                 </div>
                                 
                             </div>
                         </div>

                         

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Contact Number<span style="color:red;">*</span></label>
                                 <input type="text" class="form-control" name="contact_number"
                                     placeholder="Contact Number">
                             </div>
                         </div>

                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">PAN Number<span style="color:red">*</span></label>
                                 <input id="pan_number" type="text" class="form-control" name="pan_number"
                                     placeholder="PAN Number">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Post Office<span style="color:red">*</span></label>
                                 <input type="text" name="post_office" class="form-control" placeholder="Post Office" >
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Pincode<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pincode"
                                     placeholder="PINCODE">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Email Id<span style="color:red">*</span></label>
                                 <input type="email" class="form-control" name="email"
                                     placeholder="Email Id">
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Supporting Document</label>
                                 <input type="file" class="form-control" name="attachment"
                                     >
                                     <span>Only Pdf documents of maximum size of 2MB allowed</span>
                             </div>
                         </div>

                         



                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Submit</button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection