   
@if(auth()->user()->user_role_id==4)
    @extends('pia.layouts.app')
@endif


@section('title','View Course')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $course->training_name }} Details</h1>
   @if(auth()->user()->user_role_id==4)
        <a href="{{ route('courseList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
            class="fas fa-add fa-sm text-white-50"></i> Training programme list</a>
    @elseif(auth()->user()->user_role_id==5)
        <a href="{{ route('employercourseList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
            class="fas fa-add fa-sm text-white-50"></i>Training programme list</a>
        </a>
    @endif
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <!-- <div class="row">
                     <div class="col-md-12">
                             <div class="form-group">
                             <a href="{{ url()->previous() }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i>Back to List</a>
</div>
</div> -->
                
                     <div class="row">

                        <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Sector</b></label><br>
                                 <div class="form-group">
                                    {{ $course->GetSector->name }}
                                 </div>                               
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Trade Name</b></label><br>
                                 <div class="form-group">
                                    {{ $course->GetCourseMaster->tradename }}
                                 </div>                               
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Trade Code</b></label><br>
                                 <div class="form-group">
                                    {{ $course->GetCourseMaster->tradecode }}
                                 </div>                               
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Residential or Not?</b></label><br>
                                 {{ $course->training_location  }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Name</b></label><br>
                                 {{ $course->training_name  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Description</b></label><br>
                                 {{ $course->description  }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                <label for=""><b>Skills</b></label><br>
                                <div class="form-group">
                                     @foreach($course->SkillList as $key=>$skill)
                                     @if($key==0)
                                     {{ $skill->Skill->name }}
                                     @else
                                     ,{{ $skill->Skill->name }}
                                     @endif
                                     @endforeach
                                 </div>                                
                             </div>
                         </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for=""><b>District</b></label><br>
                                <div class="form-group">
                                    {{ $course->GetDistrict->name }}
                                </div>                                
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for=""><b>Local Body</b></label><br>
                                <div class="form-group">
                                    {{ $course->GetLocalBody->name_eng }}
                                </div>                                
                            </div>
                        </div>

                        <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Venue</b></label><br>
                                 <div class="form-group">
                                 {!! $course->venue !!}
                                 </div>                                
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Start Date</b></label><br>
                                 {{ date('d-m-Y', strtotime($course->start_date)) }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>End Date</b></label><br>
                                 {{ date('d-m-Y', strtotime($course->end_date)) }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Duration</b></label><br>
                                {{ $course->duration }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>General Seats Remaining</b></label><br>
                                 <div class="form-group">
                                     {{ $rcgs }}
                                 </div>                         
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>SC/ST Seats Remaining</b></label><br>
                                 <div class="form-group">
                                     {{ $rcss }}
                                 </div>                         
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Minority Seats Remaining</b></label><br>
                                 <div class="form-group">
                                     {{ $rcms }}
                                 </div>                         
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Total Number of Seats</b></label><br>
                                 <div class="form-group">
                                     {{ $course->no_of_seats }}
                                 </div>
                                 
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Total Seats Remaining</b></label><br>
                                 <div class="form-group">
                                     {{ $rcts }}
                                 </div>                         
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Potential Employers</b></label><br>
                                 <div class="form-group">
                                    {{ $course->future_possibilities }}
                                 </div>                               
                             </div>
                         </div>


                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Status</b></label><br>
                                 <div class="form-group">
                                    @if($course->course_status==7)
                                        <td><span class="badge badge-info">In Progress</span></td>

                                    @elseif($course->course_status==3)
                                        <td><span class="badge badge-info">Completed</span></td>
                                    @elseif($course->course_status==1)
                                        <td><span class="badge badge-info">Active</span></td>
                                    @elseif($course->course_status==23)
                                        <td><span class="badge badge-info">Featured</span></td>

                                    @elseif($course->course_status==22)
                                        <td><span class="badge badge-info">Course Pending</span></td>

                                    @elseif($course->course_status==9)
                                        <td><span class="badge badge-info">Canceled</span></td>

                                    @elseif($course->course_status==10)
                                        <td><span class="badge badge-info">Postponed</span></td>
                                    @endif
                                 </div>                               
                             </div>
                         </div>
                         <div class="col-md-12">
                             <div class="form-group">
                                <label for=""><b>Skills</b></label><br>
                                <div class="form-group">
                                     @foreach($course->SkillList as $key=>$skill)
                                     @if($key==0)
                                     {{ $skill->Skill->name }}
                                     @else
                                     ,{{ $skill->Skill->name }}
                                     @endif
                                     @endforeach
                                 </div>                                
                             </div>
                         </div>



                     </div>
                    
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection