
<div class="card-body">
    <div class="table-responsive">
        <table class="table table-striped table-hover" id="dataTable">
            <thead>
                <tr>
                <th>Sl.No</th>
                    <th>Name of Training Programme</th>
                    <th width="15%">Start Date- End Date </th>
                    <th>Training Venue</th>
                    <th>District</th>
                    <th>No. of Seats</th>
                    <th>Training Programme Status</th>
                    <th width="10%">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($courses as $key=>$course)
                <tr>
                <td>{{ ($key+1) }}</td>
                    <td>{!! $course->training_name !!}</td>

                    <td> {{ date('d-m-Y', strtotime($course->start_date)) }} <br/>to <br/>{{ date('d-m-Y', strtotime($course->end_date )) }}
                        </td>

                    

                    <td>{!! $course->venue !!}</td>

                    <td>{!! $course->GetDistrict->name !!}</td>

                    <td>{!! $course->no_of_seats !!}</td>

                    <td>
                        @if($course->course_status==3)
                            <span class="badge badge-info">Completed</span>

                        
                        @elseif($course->course_status==1)
                            <span class="badge badge-info">Active</span>
                        @elseif($course->course_status==23)
                            <span class="badge badge-info">Featured</span>

                        @elseif($course->course_status==9)
                            <span class="badge badge-info">Canceled</span>

                        @elseif($course->course_status==10)
                            <span class="badge badge-info">Postponed</span></td>
                        @endif
                    </td>

                    <td>
                        @if(auth()->user()->user_role_id==4)

                            <a href="{{ route('viewCourse',['course'=>base64_encode($course->id)]) }}" class='btn btn-info btn-circle btn-sm'>
                                <i class="fas fa-eye"></i>
                            </a>
                        @elseif(auth()->user()->user_role_id==5)
                            <a href="{{ route('employerviewCourse',['course'=>base64_encode($course->id)]) }}" class='btn btn-info btn-circle btn-sm'>
                                <i class="fas fa-eye"></i>
                            </a>
                        @endif

                        @if(auth()->user()->user_role_id==4 and auth()->user()->Piaid->id== $course->pia_id)
                            <a href="{{ route('editcourse',['course'=>base64_encode($course->id)]) }}" class='btn btn-success btn-circle btn-sm'>
                                <i class="fas fa-pen"></i>
                            </a>
                            <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-course" data-course-id="{{ base64_encode($course->id ) }}">
                                <i class="fas fa-trash"></i>
                            </a>
                        @endif
                 
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

