@extends('pia.layouts.app')

@section('title','Add Course')

@section('content')

<!-- Form inputs -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h4 mb-0 text-gray-800">Add Training Programme</h1>
        <a href="{{ route('courseList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                        class="fas fa-add fa-sm text-white-50"></i>Training programme list</a>
    </div>

    <div class="row">

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">
                <div class="card-body">
                <form id="submit_course_details" method="post" action="{{ route('submitCourseDetails') }}" >

                @csrf
                    <div class="row">
            <!--left-->

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Sector<span style="color:red;">*</span></label><br>
                                <div class="form-group">
                                    <select id ="sectordropdown" name="SectorID" class="form-control">
                                        <option value="">Choose Sector</option>
                                        @foreach($Sector as $sector)
                                        <option value="{{ $sector->Sector->id }}">{{ $sector->Sector->name }}</option>
                                        @endforeach
                                    </select>
                                    <span id="sector_error" style="color:red"></span>
                                </div>    
                            </div>
                        </div>


                        <div class="col-md-6">
                        <label for="">Trade Name<span style="color:red;">*</span></label><br>
                            <div class="form-group">
                                <input name = "CourseMasterID" id = "coursename" type="hidden" class="form-control" >
                                
                                <select id="trainingdropdown" class="form-control" name="trainingdropdown">
                                    <option value="">Select Trade</option>
                                </select>
                                <span id="course_error" style="color:red"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                        <label for="">Trade Code<span style="color:red;"></span></label><br>
                            <div class="form-group">
                                <input type="text" id="coursecode" class="form-control" name="CourseCode" readonly="readonly">
                                </select>
                            </div>
                        </div>
                      
                                
                            
                                <input type="hidden" id="duration" name="duration" value="">

                              
                  
                        <div class="col-md-6 d-none ">
                            <div class="form-group">
                                <label for="">Training Programme Name <span style="color:red">*</span></label>
                                <input id="training_name" type="text" class="form-control" maxlength="50" name="TrainingName" value="{{ auth()->user()->Piaid->id }}" placeholder="Training Programme Name">
                                <span id="training_name_error" style="color:red;"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Training Programme Description<span style="color:red">*</span></label>
                                <input id="description" type="text" class="form-control" maxlength="150" name="Description">
                                <span id="description_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
    <div class="form-group">
        <label for="training_location">Training location <span style="color:red">*</span></label>
        <div class="d-flex align-items-center">
            <div class="form-check me-3">
                <input class="form-check-input" type="radio" name="training_location" id="residential" value="residential" required>
                <label class="form-check-label" for="residential">Residential</label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="training_location" id="non_residential" value="non_residential" required>
                <label class="form-check-label" for="non_residential">Non-Residential</label>
            </div>
        </div>
        <span id="training_type_error" style="color:red;"></span>
    </div>
</div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Skills<span style="color:red;">*</span></label><br>
                                <div class="form-group">
                                    <select id="skill" name="Skill[]" class="chosen-select" multiple>
                                            <!--<option value="">Choose Sector</option>-->
                                        @foreach($Skill as $skill)
                                            <option value="{{ $skill->id }}">{{ $skill->name }}</option>
                                        @endforeach
                                    </select>
                                    <span id="skill_error" style="color:red"></span>
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6 d-none" >
                            <div class="form-group">
                                <label for="">Agency Name<span style="color:red">*</span></label>
                                <input id="PIA" type="text" class="form-control" name="PIA" value="{{ auth()->user()->Piaid->id }}">
                            </div>
                        </div>
                        

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">District<span style="color:red;">*</span></label><br>
                                <div class="form-group">
                                    <select id = "districtdropdown" name="DistrictID" class="form-control">
                                        <option value="">Choose District</option>
                                        @foreach($District as $district)
                                        <option value="{{ $district->id }}">{{ $district->name }}</option>
                                        @endforeach
                                    </select>
                                    <span id="district_error" style="color:red"></span>
                                </div>    
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="">Local Body<span style="color:red;">*</span></label><br>
                            <div class="form-group">
                                <input name = "LocalBodyID" id = "localbodydropdown" type="hidden" class="form-control">
                                <select id="lbdropdown" class="form-control" name="LocalBodyID">
                                    <option value="">Select Local Body</option>
                                </select>
                                <span id="local_body_error" style="color:red"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Venue<span style="color:red">*</span></label>
                                <input id="venue" type="text" class="form-control" maxlength="100" name="Venue">
                                <span id="venue_error" style="color:red;"></span>
                            </div>
                        </div>
                       
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Start Date<span style="color:red">*</span></label>
                                <input id="start_date" type="date" class="form-control" name="start_date" onchange="validateDates()">
                                <span id="start_date_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">End Date<span style="color:red">*</span></label>
                                <input id="end_date" type="date" class="form-control" name="end_date" onchange="validateDates()">
                                <span id="end_date_error" style="color:red;"></span>
                            </div>
                        </div>

                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Duration<span style="color:red">*</span></label>
                                <input id="duration_new" type="text" class="form-control" maxlength="15" name="Duration">
                                <span id="duration_new_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">General Seats<span style="color:red">*</span></label>
                                <input id = "gen_seats" type="text" class="seats form-control" name="GeneralSeats" maxlength="5" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                <span id="gen_seats_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">SC/ST Seats<span style="color:red">*</span></label>
                                <input id = "sc_seats" type="text" class="seats form-control" name="SCSTSeats" maxlength="5" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                <span id="sc_seats_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Minority Seats<span style="color:red">*</span></label>
                                <input id = "min_seats" type="text" class="seats form-control" name="MinoritySeats" maxlength="5" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                <span id="min_seats_error" style="color:red;"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Total Number of seats<span style="color:red">*(Total of the above mentioned seats)</span></label>
                                <input id = "total" type="text" class="form-control" name="TotSeats" readonly="readonly">
                            </div>
                        </div>

            <!--left-->
            <!--right-->
                       

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Potential Employers</label>
                                <input id="futurepossibilities" type="text" class="form-control" maxlength="150" name="FuturePosssibilities" >
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Remarks</label>
                                <input id="remarks" type="text" class="form-control" maxlength="150" name="Remarks" >
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-12 text-right">
                            <hr>
                            <div id="plwait" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                                <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>

                </form>

                </div>
            </div>
        </div>       
    </div>
</div>




<script>







document.addEventListener('DOMContentLoaded', function () {
    const durationInput = document.getElementById('duration');  // Original duration
    const durationNewInput = document.getElementById('duration_new');  // Read-only new duration
    const startDateInput = document.getElementById('start_date');  // Start date input
    const endDateInput = document.getElementById('end_date');  // End date input

    // Set today's date as the minimum for the start date
    const today = new Date().toISOString().split('T')[0];
    startDateInput.setAttribute('min', today);

    // Function to calculate the end date based on start date and duration (in days)
    function calculateEndDate(startDate, duration) {
        const endDate = new Date(startDate);
        endDate.setDate(endDate.getDate() + duration);  // Add duration in days
        return endDate.toISOString().split('T')[0];  // Return in 'YYYY-MM-DD' format
    }

    // Function to calculate the duration in days between two dates
    function calculateDurationInDays(startDate, endDate) {
        const timeDiff = endDate - startDate;  // Difference in milliseconds
        return Math.ceil(timeDiff / (1000 * 60 * 60 * 24));  // Convert milliseconds to days
    }

    // Event listener for start date change
    startDateInput.addEventListener('change', function () {
        const startDate = new Date(this.value);

        if (isNaN(startDate)) {
            console.warn('Invalid start date.');
            return;
        }

        const duration = parseInt(durationInput.value || 1);  // Default to 1 day if empty
        const calculatedEndDate = calculateEndDate(startDate, duration);

        // Set the minimum and value for the end date field
        endDateInput.setAttribute('min', calculatedEndDate);
        endDateInput.value = calculatedEndDate;  // Automatically set the end date

        // Populate the new duration field with the initial duration
        durationNewInput.value = duration;
    });

    // Event listener for end date change (user modifies the end date)
    endDateInput.addEventListener('change', function () {
        const startDate = new Date(startDateInput.value);
        const endDate = new Date(this.value);

        if (isNaN(startDate) || isNaN(endDate)) {
            console.warn('Invalid date input.');
            return;
        }

        const newDuration = calculateDurationInDays(startDate, endDate);

        // Update the readonly new duration field
        durationNewInput.value = newDuration > 0 ? newDuration : 0;

        if (newDuration < 1) {
            alert('End date must be at least 1 day after the start date.');
            this.value = '';  // Clear invalid end date
            durationNewInput.value = '';  // Clear new duration
        }
    });
});




       /* $(document).ready(function(){
            alert("hi");

        });*/
          
            /*------------------------------------------
            --------------------------------------------
            Sector Dropdown Change Event
            --------------------------------------------
            --------------------------------------------*/
      /*      $('#sector-dropdown').on('change', function () {
                var idSector = this.value;
                $("#training-dropdown").html('');
                $.ajax({
                    url: "{{url('api/fetch-training')}}",
                    type: "GET",
                    data: {
                        sector_id: idSector,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        $('#training-dropdown').html('<option value="">-- Select Training Programme Name --</option>');
                        $.each(result.trainings, function (key, value) {
                            $("#training-dropdown").append('<option value="' + value
                                .id + '">' + value.course_name + '</option>');
                        });
                    }
                });
            }); */

          /*    $('#sector-dropdown').change(function(){
                var idSector=$('#sector-dropdown').val();
                alert ("Hi") ;
                    $.ajax({
                        method: "GET",
                        url: "/api/fetch-training/" + idSector,
                        data: { idSector: idSector },
                        success: function (data) {
                            console.log(data);
                            $('#localbody').html('<option value="">-- Select Training Programme Name --</option>');
                            $.each(data.data, function (index, value) {
                                $('#training-dropdown').append('<option value="' + value.id + '">' + value.course_name + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            console.error(xhr.responseText);
                        }
                    });
            });
  
            /*------------------------------------------
            --------------------------------------------
            Training Programme Name Dropdown Change Event
            --------------------------------------------
            --------------------------------------------*/
         /*   $('#training-dropdown').on('change', function () {
                var idTraining = this.value;
                $("#code-dropdown").html('');
                $.ajax({
                    url: "{{url('api/fetch-codes')}}",
                    type: "POST",
                    data: {
                        course_id: idTraining,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (res) {
                        $("#code_text").val($("#code_text").val()+' - '+res.Code);
                    }
                });
            }); */
  
    </script>


@endsection