@extends('admin.layouts.app')

@section('title','Course Master List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Course Master List </h1>
            <a href="{{ route('createCourseMaster') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> New Course Master</a>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Sector Name</th>
                                        <th>Trade Code</th>
                                        <th>Trade Name</th>
                                        <th>Duration</th>
                                        <th>Qualification</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($courseMaster_details as $key=>$Course)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $Course->Sector->name  }}</td>
                                        <td>{{ $Course->tradecode  }}</td>
                                        <td>{{ $Course->tradename  }}</td>
                                        <td>{{ $Course->duration  }}</td>
                                        <td>{{ $Course->qualification  }}</td>
                                        <td>
            <span class="description">
                {{ Str::limit($Course->description, 50) }}
                <span class="more-text d-none">{{ substr($Course->description, 50) }}</span>
            </span>
            @if(strlen($Course->description) > 50)
                <a href="javascript:void(0)" class="view-more-btn">View More</a>
            @endif
        </td>
                                        <td>

                                            <a href="{{ route('viewCourseMaster',['Course'=>base64_encode($Course->id)]) }}" class="btn btn-info btn-circle btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                               
                                                   @if($Course->is_active==1)
                                                        <a href="{{ route('editCourseMaster',['Course'=>base64_encode($Course->id)]) }}" class="btn btn-success btn-circle btn-sm"  title="Edit">
                                                            <i class="fas fa-pen"></i>
                                                        </a>

                                                    @endif
                                                @if($Course->is_active==1)
                                                    <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-course" data-course-id="{{ base64_encode($Course->id ) }}"  title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </a>

                                                @elseif($Course->is_active==11)

                                                    <a href="#" class="reactivate-pia" data-pia-id="{{ base64_encode($Course->id ) }}"  title="Reactivate">
                                        
                                                    </a>

                                                @endif

                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->
<script>
    document.addEventListener('DOMContentLoaded', function () {
    const viewMoreButtons = document.querySelectorAll('.view-more-btn');

    viewMoreButtons.forEach(button => {
        button.addEventListener('click', function () {
            const moreText = this.previousElementSibling.querySelector('.more-text');
            moreText.classList.toggle('d-none');

            this.textContent = moreText.classList.contains('d-none') ? 'View More' : 'View Less';
        });
    });
});

</script>
@endsection