   
   @extends('admin.layouts.app')


@section('title','edit Course Master')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Edit {{ $courseMaster->tradename }}</h1>
     <a href="{{ route('CourseMasterList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Course Master List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="update_course_master_details" action="post" method="{{ route('updateCourseMasterDetails') }}">
                     <div class="row">

                       @csrf

                       <input type="hidden" name="id" value="{{ $courseMaster->id }}">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Sector<span style="color:red;">*</span></label><br>
                                        <div class="form-group">
                                            <select id = "sectordropdown" name="Sector" class="form-control" required>
                                                <option value="">Choose Sector</option>
                                                    @foreach($Sector as $sector)

                                                        @if($sector->id==$courseMaster->sector_id)
                                                            <option selected="selected" value="{{ $sector->id }}">{{ $sector->name }}</option>
                                                        @else
                                                            <option  value="{{ $sector->id }}">{{ $sector->name }}</option>
                                                        @endif
                                                    @endforeach
                                            </select>
                                        </div>                                
                                </div>
                            </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Trade Name<span style="color:red">*</span></label>
                                 <input id="trade_name" type="text" class="form-control" name="trade_name"
                                     placeholder="Course Name" value="{{ $courseMaster->tradename }}" required>
                                     <span id="trade_name_error" style="color:red;"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Trade Code<span style="color:red">*</span></label>
                                 <input id="course_code" type="text" name="trade_code" class="form-control" value="{{ $courseMaster->tradecode }}" required>
                                 <span id="course_code_error" style="color:red;"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Duration<span style="color:red">*</span></label>
                                 <input id="duration" type="text" name="duration" class="form-control" value="{{ $courseMaster->duration }}" required>
                                 <span id="duration_error" style="color:red;"></span>
                             </div>
                         </div> 
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Qualification<span style="color:red">*</span></label>
                                 <input id="qualification" type="text" name="qualification" class="form-control" value="{{ $courseMaster->qualification }} "required>
                                 <span id="qualification_error" style="color:red;"></span>
                             </div>
                         </div>
                         
                         <div class="col-md-6">
                            <div class="form-group">
                                <label for="description">Description <span style="color:red">*</span></label>
                                <textarea id="description" name="description" class="form-control" rows="5"  required>{{ $courseMaster->description }}</textarea>
                                <span id="description_error" style="color:red;"></span>
                     </div>
</div>                   

                        
                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Update</button>
                             <button type="reset" class="btn btn-default"><a href="{{route('CourseMasterList')}}">Cancel</a></button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection