@if ($data['course']->isEmpty())
    <script>
        window.location.href = "{{ route('CourseList') }}"; 
    </script>
@endif
@extends('Public_site.layouts.app')
@extends('Public_site.layouts.header')
@extends('Public_site.layouts.banner')
@section('titleh2','Request Interest')
@section('titleh3','the courses that you like')
@section('content')


<div id="content">

@if ($errors->any())
    <div class="alert alert-danger" id="errorMessage">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<div class="content-kud request-interest">
<form  id="myForm" method="post">
                @csrf
<div class="card">
    <div class="card-body">

        <!--personal info-->
        <h3><span>Personal Details</span></h3>
        <div class="row">
            <div class="col-md-4 my-1">
            <label for="" class="form-label">Name<span style="color:red">*</span></label>
            <input type="text" class="form-control" id="candidatename"  placeholder="" maxlength="50" name="candidatename" required>
            <span id="candidate_name_error" style="color:red"></span>
            
            </div>
            <div class="col-md-4 my-1">
            <label for="" class="form-label">Gender<span style="color:red">*</span></label>
           
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="male"  value="Male" required>
                                        <label class="form-check-label" for="gender1">Male</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="female" value="Female">
                                        <label class="form-check-label" for="gender2">Female</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="transgender"  value="Transgender">
                                        <label class="form-check-label" for="gender3">Transgender</label>
                                    </div>

                                    <span id="gender_error_message" style="color:red;"></span>

                       
                
            </div>
            <div class="col-md-4 my-1">
            <label for="" class="form-label">Date of Birth<span style="color:red">*</span></label>
                                    <input type="date" class="form-control" id="dob" placeholder="" name="dob" max="{{ $formattedDefaultDate }}"  required>
                                    <span id="dobValidationMessage"></span>
                                    <span style="color:red" id="dob_error"></span>
                                    
            </div>
            <div class="col-md-4 my-1">
                             <label for="" class="form-label">Religion</label>
                                    <select class="form-select" id="religion" name="religion">
                                        <option value="">select</option>
                                        <option value="Buddhists">Buddhists</option>
                                        <option value="Christian">Christian</option>
                                        <option value="Hindu">Hindu</option>
                                        <option value="Jains">Jains</option>
                                        <option value="Muslims">Muslims</option>
                                        
                                        <option value="Sikhs">Sikhs</option>
                                        <option value="Other religions">Other religions</option>

                                    </select>
                                    
            </div>
            <div class="col-md-4 my-1">
            <label for="" class="form-label">Category<span style="color:red">*</span></label>
                                    <select class="form-select" id="category" name="category" required>
                                        <option value="">select</option>
                                        <option value="General">General</option>
                                        <option value="SC">SC</option>
                                        <option value="ST">ST</option>
                                        <option value="Minority">Minority</option>
                                    </select>
                                    <span id="category_error" style="color:red;"></span>
            </div>
            <div class="col-md-4 my-1">
            <label for="" class="form-label">Email Id<span style="color:red">*</span></label>
                                    <input type="email" class="form-control" id="email" placeholder="" name="email" maxlength="50"  onchange="liveValidateEmail()" required>
                                    <span id="emailValidationMessage"></span>
                                    <span id="email_error" style="color:red;"></span>
            </div>
            <div class="col-md-4 my-1">
            <label for="" class="form-label">Mobile Number<span style="color:red">*</span></label>
                                  <!--  <input type="text" maxlength="10" oninput="this.value = this.value.replace(/[^0-9]/g,'');" class="form-control" id="mobileNumber" placeholder="" maxlength="10"   onchange="validateMobileNumber()" required>-->
                                    <input type="text" maxlength="10"  name="mobileNumber" class="form-control" id="mobileNumber"  oninput="this.value = this.value.replace(/[^0-9]/g,'');"   onkeyup="validateMobileNumber()" required>
                                 <!--   <input type="number"   class="form-control" id="mobileNumber" placeholder="" maxlength="10"  onchange="validateMobileNumber()" required>-->
                                    <span id="mobValidationMessage"></span>
                                    <span id="mobile_number_error" style="color:red;"></span>
            </div>
        </div>
        <!--personal info-->

        <!--Qualifications-->
        <h3><span>Qualifications</span></h3>
        <div class="row">
            <div class="col-md-6 my-1">
            <label for="" class="form-label">Highest Qualification<span style="color:red">*</span></label>
            
                                    <select class="form-select" id="hQualification" name="hQualification" required>
                                        <option value="">select</option>
                                        <option value=" 8th">8th</option>
                                        <option value="SSLC">SSLC</option>
                                        <option value="12th">12th</option>
                                        <option value="Diploma">Diploma</option>
                                        <option value="UG">UG</option>
                                        <option value="PG">PG</option>
                                        <option value="PG Diploma">PG Diploma</option>
                                    </select>  
                                    
                <span id="highest_qualification_error" style="color:red"></span>
                                           
            </div>
            <div class="col-md-6 my-1">
            <label for="" class="form-label">Specify the courses completed.</label>
             <input type="text" class="form-control" id="certificate" placeholder="" maxlength="200" name="certificate" value="{{ old('certificate') }}">
             
            </div>
        </div>
        <!--Qualifications-->

        <!--address info-->
        <h3><span>Address</span></h3>
        <div class="row">
        <div class="col-md-6">
            <div class="my-2">
        
            <label for="" class="form-label">Building Name/Number<span style="color:red">*</span></label>
             <input type="text" class="form-control" id="BuildingName" placeholder="" maxlength="50" name="BuildingName" required>
             <span id="building_name_error" style="color:red;"></span>
</div>
           
            
<div class="my-2">
          
            <label for="" class="form-label">Landmark<span style="color:red">*</span></label>
             <input type="text" class="form-control" id="Landmark" placeholder="" maxlength="50" name="Landmark" required>
             <span id="landmark_error" style="color:red;"></span>
            
</div>
<div class="my-2">
            <label for="" class="form-label">Post Office<span style="color:red">*</span></label>
            <input type="text" class="form-control" id="PostOffice" placeholder="" maxlength="25" name="PostOffice"  required>
            <span id="post_office_error" style="color:red;"></span>
                                   
            </div>
            <div class="my-2">
            <label for="" class="form-label">Pincode<span style="color:red">*</span></label>
            <input type="text" class="form-control" id="PIN_Code" placeholder="" maxlength="6" name="PIN_Code" oninput="this.value = this.value.replace(/[^0-9]/g,'');" pattern="\d{6}" title="Please enter a 6-digit PIN code"  required>
            <span id="pincode_error" style="color:red;"></span>
</div>               
           
</div>
            <div class="col-md-6">
                <div class="my-2">
                <label for="" class="form-label">District<span style="color:red">*</span></label>
                                        <select class="form-select" id="district" name="district" required>
                                            <option value="">Select District</option>
                                        @if ($data['district']->isNotEmpty())

                                            @foreach ($data['district'] as $district)
                                        
                                           <option value="{{$district->id}}">{{$district->name}}</option>
                                           @endforeach
                                           @else
                                           <option value="0">District List is empty</option>
                                           @endif
                                        </select>
                                        <span id="district_error" style="color:red;"></span>
                </div>
                <div class="my-2">
                <label for="" class="form-label">Local Body Type</label>
                                        <select class="form-select" id="lbt" name="lbt" >
                                            <option value="0">Select Local Body Type</option>
                                        @if ($data['LocalBodyTypes']->isNotEmpty())

                                            @foreach ($data['LocalBodyTypes'] as $LBT)
                                        
                                           <option value="{{$LBT->id}}">{{$LBT->name_eng}}</option>
                                           @endforeach
                                           @else
                                           <option value="0">Local Body Type List is empty</option>
                                           @endif
                                        </select>

                                        <span id="#gender_error" style="color:red;"></span>
                </div>
                <div class="my-2" id="block_div" style="display: none;">
                                        <label for="" class="form-label">Block</label>
                                        <select class="form-select" id="block_list" name="block_list">
                                            <option value="0">select Block</option>
                                        </select>

                                        <span id="#gender_error" style="color:red;"></span>
                                    </div>
                <div class="my-2">
                <label for="" class="form-label">Local Body Name </label>
                                        <select class="form-select" id="localbody" name="localbody" >
                                            <option value="0">select Local Body</option>
                                        </select>

                                        <span id="#gender_error" style="color:red;"></span>
                </div>
                
        </div>
        
        <!--address info-->

        <!--other info-->
        <h3><span>Other Informations</span></h3>
                        <div class="row">
                            <div class="col-md-4 my-1">
                                <label for="" class="form-label">PWD<span style="color:red">*</span></label>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="pwd" id="pwd1" value="Yes" required>
                                    <label class="form-check-label" for="pwd1">Yes</label>

                                   
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="pwd" id="pwd2" value="No">
                                    <label class="form-check-label" for="pwd2">No</label>
                                </div>

                                <span id="pwd_error" style="color:red;"></span>
                            </div>
                            <div class="col-md-4 my-1">
                                <label for="" class="form-label">Ration card Type<span style="color:red">*</span></label>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="rationCard" id="rationCard1" value="APL" required >
                                    <label class="form-check-label" for="rationCard1">APL</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="rationCard" id="rationCard2" value='BPL'>
                                    <label class="form-check-label" for="rationCard2">BPL</label>
                                </div>

                                <span id="ration_card_error" style="color:red;"></span>
                            </div>
                            <div class="col-md-4 my-1">
                                <label for="" class="form-label">Do you belong to MGNREGA Family ?<span style="color:red">*</span></label>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="mgnrega" id="mgnrega1" value="Yes" required>
                                    <label class="form-check-label" for="kudMember1">Yes</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="mgnrega" id="mgnrega2" value="No">
                                    <label class="form-check-label" for="kudMember2">No</label>
                                </div>

                                <span id="mgnrega_error" style="color:red;"></span>
                            </div>
                            <div class="col-md-4 my-1">
                                <label for="" class="form-label">Kudumbashree Member<span style="color:red">*</span></label>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="kudMember" id="kudMember1" value="Yes" required>
                                    <label class="form-check-label" for="kudMember1">Yes</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="kudMember" id="kudMember2" value="No">
                                    <label class="form-check-label" for="kudMember2">No</label>
                                </div>

                                <span id="kudumbashree_member_error" style="color:red;"></span>
                            </div>
                            <div class="col-md-4 my-1">
                                <label for="" class="form-label">Willing to join for residential courses<span style="color:red">*</span></label>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="JoiTocourse" id="JoiTocourse1" value="Yes" required >
                                    <label class="form-check-label" for="kudMember1">Yes</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="JoiTocourse" id="JoiTocours2" value="No">
                                    <label class="form-check-label" for="kudMember2">No</label>
                                </div>

                                <span id="join_to_course_error" style="color:red;"></span>
                            </div>
                        </div>
        <!--other info-->

        <!--course info-->
        <h3><span>Selected Courses</span></h3>
        <div class="row">
            <div class="col-md-12 col-12 my-1">
                <label for="" class="form-label">The courses that you prefer</label>
                @if ($data['course']->isNotEmpty())
                            @foreach ($data['course'] as $key => $course)
                <div class="form-check">
                <input type="hidden" name="courses[]" value="{{ $course->id }}">
                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault" checked disabled>
                    <label class="form-check-label" for="flexCheckDefault">
                    {{ $course->tradename }}
                    </label>
                </div>
                
                @endforeach
                @else
                <div class="form-check">
                <input type="hidden" name="courses[]" >
                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault"
                        checked disabled>
                    <label class="form-check-label" for="flexCheckDefault">
                   No course Selected
                    </label>
                </div>
                @endif
                
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <p class="purple">Maximum 3 courses are allowed to select.</p>
            </div>
        </div>
        <!--course info-->

        <!--submit btn-->

        <div class="form-group">
        <div class="g-recaptcha" data-sitekey="{{ env('GOOGLE_RECAPTCHA_KEY') }}"></div>
        </div>
        <div class="row">
            <div class="col-12 text-center">
            <button type="button" class="btn btn-primary submit mt-0 mb-3" id="submitBtn">Submit</button>
                
            </div>
        </div>
        <!--submit btn-->

    </div>
</div>

</form>

</div>
        </div>

       
@endsection
