@extends('Public_site.layouts.app')
@extends('Public_site.layouts.header')
@extends('Public_site.layouts.banner')

@section('titleh2','Talento Connect')
@section('titleh3','Active Training Programs Courses List')
@section('content')
  <!--content part-->
      
  <div class="content-kud">
       
       <form method="post"  action="{{ url('/CourseRegistration') }}">
       <!-- <form method="post" onsubmit="return checkpro()" action="{{ url('/CourseRegistration') }}">-->
    <!-- Your form fields go here -->
    @csrf
                <!--list of courses-->
                <div class="mt-5">
                    <!--Submit Button-->
                    <div class="text-end mb-3">

    @if(count($selected_course_masters_list)>0)

   
   <b>Courses:</b>

    @foreach($selected_course_masters_list as $key=>$list)

        @if($key==0)

        {{ $list->tradename }}

        @else

        ,{{ $list->tradename }}

        @endif

    @endforeach

   

    @endif

    <span style="color:red;" id="course_count_error"></span>
                        
    <input type="submit"  class="btn btn-primary" id="submitButton"  value="Submit">
                    <!--<button class="btn btn-primary" id="submitButton"  type="submit">Submit</button>
-->  <!--Submit Button-->
</div>  @if ($errors->any())
    <div class="alert alert-danger" id="errorMessage">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
       
<div id="error_limit" style="color: red;"></div>      
        
<table id="customTable" class="table-tbox col-12 mt-2 mr-2" style="margin-bottom: 15px !important;">
    <thead     style="border-radius: 6px !important;
    opacity: 0.75 !important;
    background: var(--purple) !important;
    color: white !important;">
                        <tr>
                            <th>Sl.No</th>
                            <th>Name of course</th>
                            <th>View course Details</th>
                            <th>Tick if interested</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(isset($Course) && count($Course) > 0)
                        @foreach($Course as $Courselist)
                        <tr style="
    border-radius: 6px;
    background: var(--white-color);
    opacity: 1;
    box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.10), 0px 8px 8px 0px rgba(0, 0, 0, 0.09), 0px 18px 11px 0px rgba(0, 0, 0, 0.05), 0px 31px 12px 0px rgba(0, 0, 0, 0.01), 0px 49px 14px 0px rgba(0, 0, 0, 0.00);
">
                            <td>{{ $loop->iteration }}</td>
                            <td>{!! $Courselist->tradename !!}</td>
                            <td><a href="{{ url('/CourseDetails') }}/{!! base64_encode($Courselist->id) !!}" >View</a></td>
                            <td>


                                @if(in_array($Courselist->id,$selected_course_masters))

                                <input type="checkbox" data-course-master-id="{{ $Courselist->id }}"
                                    class="select-course-master form-check-input checkbox" name="Course[]"
                                    id="courseid{{ $loop->iteration }}" value="{!! $Courselist->id !!}"
                                    checked="checked">


                                @else

                                @if($course_selectable)

                                <input type="checkbox" data-course-master-id="{{ $Courselist->id }}"
                                    class="select-course-master form-check-input checkbox" name="Course[]"
                                    id="courseid{{ $loop->iteration }}" value="{!! $Courselist->id !!}">

                                @endif

                                @endif





                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="4">No courses available.</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
                <input type="hidden" id="masterIds" name="arrayValue">



            </div>
            <!--list of courses-->


    </div>
</div>
<!--content part-->





</div>
<style>.dataTables_length{
        margin-bottom: 15px !important;
}
  
  @media screen and (max-width: 640px){
.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter {
    float: none;
    text-align: left !important;
}
  }
  
  </style>

<script>
    $(document).ready(function () {
        let lt = $('#customTable').DataTable();

       var no=parseInt("{{ $page }}");

        lt.page(no).draw('page');


        $(document).on("click",".select-course-master",function(e)
    {

        

       
        var course_master_id=$(this).data('course-master-id');

        
       

        var page_info=lt.page.info();

        
       

        if($(this).prop('checked')==true)
        {

            $.ajax({
                headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                url:"{{ route('addCourseMasterToSession') }}",
                type:"POST",
                data:{course_master_id:course_master_id},
                dataType:"JSON",
                success:function(response)
                {

                    if(response.status=="success")
                    {
                       // location.reload();

                       window.location.href="{{ url('/CourseList') }}?page="+page_info.page;
                    }

                }
            });

        }

        else{

            $.ajax({
                headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                url:"{{ route('removeCourseMasterFromSession') }}",
                type:"POST",
                data:{course_master_id:course_master_id},
                dataType:"JSON",
                success:function(response)
                {

                    if(response.status=="success")
                    {
                       // location.reload();

                       window.location.href="{{ url('/CourseList') }}?page="+page_info.page;
                    }

                }
            });



        }

       
    });
        var selectedCheckboxValues = []; // Array to store selected checkbox values

        // Event listener for checkbox changes
        $('#customTable tbody').on('change', 'input.checkbox', function () {
            var checkboxValue = $(this).val();

            // Update the array based on checkbox state
            if ($(this).prop('checked')) {
                selectedCheckboxValues.push(checkboxValue);
            } else {
                selectedCheckboxValues = selectedCheckboxValues.filter(function (value) {
                    return value !== checkboxValue;
                });
            }
            $('#masterIds').val(selectedCheckboxValues);
            // Log or use the array of selected checkbox values
            console.log('Selected Checkbox Values:', selectedCheckboxValues);

            // Display an error message if more than 3 checkboxes are selected
            if (selectedCheckboxValues.length > 3) {
                $('#error_limit').html("We are not supposed to select more than 3 courses");
                $('#customTable tbody input.checkbox:not(:checked)').attr('disabled', true);
                $('#submitButton').attr('disabled', true);
            } else {
                $('#error_limit').html("");
                // Enable all checkboxes
                $('#customTable tbody input.checkbox').attr('disabled', false);
                $('#submitButton').attr('disabled', false);
            }
        });
        function validateForm(event) {
            // Your condition goes here
           // var hiddenArrayValue = document.getElementById('masterIds').value;
            // alert(hiddenArrayValue);

            alert("Hello");

            var cousres_count="{{ count($selected_course_masters_list) }}";

            alert(courses_count);

            if (courses_count>0) {

                $('#error_limit').html("");
                return true;
            }
            else {
                $('#error_limit').html("Please select checkboxes, not more than three");

                var errorMessage = document.getElementById('error_limit');
                errorMessage.textContent = "Condition not met. Form submission canceled.";
                event.preventDefault();

            }
        }

       




    });
</script>

<script>

    function checkpro()
    {

        var courses_count="{{ count($selected_course_masters_list) }}";

        if(courses_count==0)
        {
            $('#course_count_error').html("Please choose atleast one course");
            return false;
        }
        
    }


</script>




</div>
@endsection