@extends('Public_site.layouts.app')
@extends('Public_site.layouts.header')
@extends('Public_site.layouts.banner')

@section('titleh2','Talento Connect')
@section('titleh3','Active Training Programs Courses List')
@section('content')
  <!--content part-->
      
  <div class="content-kud">

<!--list of courses-->
<div class="mt-1">
    <div class="row justify-content-between">
        <div class="col-md-9">
            
        </div>
        <div class="col-md-3 text-end mb-3">
       
        
        </div>
    </div>

    <div class="row mt-2 justify-content-between">
        <!--left-->
        <div class="col-md-8">
            <div class="table-responsive card">
                <div class="card-body">
                    <table id="customTable"  class="table table-hover table-dt" style="width:100%">
                        <thead>
                            <>
                                <th>Sl. No</th>
                                <th>Name of the Course</th>
                                
                                <th>Duration</th>
                                <th>Qualification</th>
                                
                                <th>Tick if Interested</th>
                            </tr>
                        </thead>
                        <tbody>
                        @if(isset($Course) && count($Course) > 0)
                        @foreach($Course as $Courselist)
                            <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                <a href="{{ url('/CourseDetails') }}/{!! base64_encode($Courselist->id) !!}">{!! $Courselist->tradename !!}</a>
                            </td>

                            
                            <td>
                                {{ $Courselist->duration }}</a>
                            </td>
                            <td>
                                {{ $Courselist->qualification }}</a>
                            </td>
                            
                           
    
                            <td>


                                @if(in_array($Courselist->id,$selected_course_masters))

                                <input type="checkbox" data-course-master-id="{{ $Courselist->id }}"
                                    class="select-course-master form-check-input checkbox" name="Course[]"
                                    id="courseid{{ $loop->iteration }}" value="{!! $Courselist->id !!}"
                                    checked="checked">


                                @else

                                @if($course_selectable)

                                <input type="checkbox" data-course-master-id="{{ $Courselist->id }}"
                                    class="select-course-master form-check-input checkbox" name="Course[]"
                                    id="courseid{{ $loop->iteration }}" value="{!! $Courselist->id !!}">

                                @endif

                                @endif





                            </td>
                        </tr>

                            @endforeach
                            @else
                            <tr>
                                <td colspan="4">No courses available.</td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!--left-->
        <!--right-->
        <div class="col-md-4">
            <div class="table-responsive card">
                <form method="post" onsubmit="return checkpro()" action="{{ url('/CourseRegistration') }}">
                    @csrf
                    <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger" id="errorMessage">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                        
                    <div id="error_limit" style="color: red;"></div>     
                        <p class="mb-3"><b>Note:</b> Click on the courses to view details of the training programs. You can select a maximum of 3 courses. </p>
                        <p>Submit your interest for the courses and we will get back to you shortly.</p>
                        <p class="purple mb-3"><b>You have selected the following list of courses</p>
                        <span style="color:red;" id="course_count_error"></span>
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name of the Course</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($selected_course_masters_list as $list)
                                <tr>
                                    
                                    <td> <input type="checkbox" data-course-master-id="{{ $list->id }}"
                                            class="select-course-master form-check-input checkbox" name="Course[]"
                                            value="{!! $list->id !!}"
                                            checked="checked"> {{ $list->tradename }}</td>
                                </tr>
                               

                                @endforeach
                            </tbody>
                        </table>

                        <input type="submit"  class="btn btn-primary" id="submitButton"  value="Submit">
                    </div>
                </div>

                    
              </form>
            </div>
        </div>
        <!--right-->
    </div>
    

</div>
<!--list of courses-->

</div>
<!--content part-->





</div>
<style>.dataTables_length{
        margin-bottom: 15px !important;
}
  
  @media screen and (max-width: 640px){
.dataTables_wrapper .dataTables_length, .dataTables_wrapper .dataTables_filter {
    float: none;
    text-align: left !important;
}
  }
  
  </style>

<script>
    $(document).ready(function () {
        let lt = $('#customTable').DataTable();

       var no=parseInt("{{ $page }}");

        lt.page(no).draw('page');


        $(document).on("click",".select-course-master",function(e)
    {

        

       
        var course_master_id=$(this).data('course-master-id');

        
       

        var page_info=lt.page.info();

        
       

        if($(this).prop('checked')==true)
        {

            $.ajax({
                headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                url:"{{ route('addCourseMasterToSession') }}",
                type:"POST",
                data:{course_master_id:course_master_id},
                dataType:"JSON",
                success:function(response)
                {

                    if(response.status=="success")
                    {
                       // location.reload();

                       window.location.href="{{ url('/CourseList') }}?page="+page_info.page;
                    }

                }
            });

        }

        else{

            $.ajax({
                headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                url:"{{ route('removeCourseMasterFromSession') }}",
                type:"POST",
                data:{course_master_id:course_master_id},
                dataType:"JSON",
                success:function(response)
                {

                    if(response.status=="success")
                    {
                       // location.reload();

                       window.location.href="{{ url('/CourseList') }}?page="+page_info.page;
                    }

                }
            });



        }

       
    });
        var selectedCheckboxValues = []; // Array to store selected checkbox values

        // Event listener for checkbox changes
        $('#customTable tbody').on('change', 'input.checkbox', function () {
            var checkboxValue = $(this).val();

            // Update the array based on checkbox state
            if ($(this).prop('checked')) {
                selectedCheckboxValues.push(checkboxValue);
            } else {
                selectedCheckboxValues = selectedCheckboxValues.filter(function (value) {
                    return value !== checkboxValue;
                });
            }
            $('#masterIds').val(selectedCheckboxValues);
            // Log or use the array of selected checkbox values
            console.log('Selected Checkbox Values:', selectedCheckboxValues);

            // Display an error message if more than 3 checkboxes are selected
            if (selectedCheckboxValues.length > 3) {
                $('#error_limit').html("We are not supposed to select more than 3 courses");
                $('#customTable tbody input.checkbox:not(:checked)').attr('disabled', true);
                $('#submitButton').attr('disabled', true);
            } else {
                $('#error_limit').html("");
                // Enable all checkboxes
                $('#customTable tbody input.checkbox').attr('disabled', false);
                $('#submitButton').attr('disabled', false);
            }
        });
        function validateForm(event) {
            // Your condition goes here
           // var hiddenArrayValue = document.getElementById('masterIds').value;
            // alert(hiddenArrayValue);

            alert("Hello");

            var cousres_count="{{ count($selected_course_masters_list) }}";

            alert(courses_count);

            if (courses_count>0) {

                $('#error_limit').html("");
                return true;
            }
            else {
                $('#error_limit').html("Please select checkboxes, not more than three");

                var errorMessage = document.getElementById('error_limit');
                errorMessage.textContent = "Condition not met. Form submission canceled.";
                event.preventDefault();

            }
        }

       




    });
</script>

<script>

    function checkpro()
    {

        var courses_count="{{ count($selected_course_masters_list) }}";

        if(courses_count==0)
        {
            $('#course_count_error').html("Please choose atleast one course");
            return false;
        }
        
    }


</script>




</div>
@endsection