@extends('Public_site.layouts.header')
@extends('Public_site.layouts.banner')
@extends('Public_site.layouts.footer')
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" />
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v6.0.0-beta3/css/all.css">
    <link href="{{asset('public_site/css/custom-kud-training.css')}}" rel="stylesheet">
    <!-- Include SweetAlert2 CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<!-- Include SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>

    <script>

        $(document).ready(function()
        {
            

            $(document).on("click",".select-training",function()
            {

                
                var training_id=$(this).data('training-id');

                if($(this).prop('checked')==true)
                {

                    
                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('addTrainingsToSession') }}",
                        type:"POST",
                        data:{training_id:training_id},
                        dataType:"JSON",
                        success:function(response)
                        {

                            if(response.status=="success")
                            {
                                location.reload();
                            }

                        }
                    });
                    
                }

                else{

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
                        url:"{{ route('removeTrainingsFromSession') }}",
                        type:"POST",
                        data:{training_id:training_id},
                        dataType:"JSON",
                        success:function(response)
                        {

                            if(response.status=="success")
                            {
                                location.reload();
                            }

                        }
                    });


                }

                
            });

        });

    </script>


 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
   
</script>
    <title>Kudumbashree Training</title>
</head>

<body>

    <div class="container-fluid">

        <!--header nav-->
        
        @yield('header')
    
        <!--header nav-->

        <!--banner-->
        @yield('banner')
        
        <!--banner-->

        <!--content part-->
        <div class="container">
        @yield('content')
       </div>
        
        <!--content part-->
        

    </div>
    <!--Bootstrap Bundle with Popper -->
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
 
    
    <script>
        $(document).ready(function() {
            // On page load, check the initial selected value
    
    // Get the current date
    var currentDate = new Date();

    // Calculate the date 18 years ago
    var eighteenYearsAgo = new Date(currentDate.getFullYear() - 18, currentDate.getMonth(), currentDate.getDate());

    // Format the date to YYYY-MM-DD (required by the date input type)
    var formattedDate = eighteenYearsAgo.toISOString().split('T')[0];

    // Set the default value of the input element
    document.getElementById('dob').value = formattedDate;
    document.getElementById('dob').max = formattedDate;
  
            
            toggleDivVisibility();

            // When the dropdown value changes
            $('#block_id').change(function(){
                LBTID=$('#lbt').val();
                DistrictID=$('#district').val();
                blockID=$('#blocl_list').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-localbodywithBlock/" + DistrictID+ "?LBT=" + LBTID+"?blockID="+blockID,
                        data: { DistrictID: DistrictID ,LBTID: LBTID,blockID:blockID }, // Pass data as an object
                        success: function (data) {
                            //console.log(data);
                            //Clear and populate options in the block_list element
                            $('#localbody').html('<option value="0">Choose Block</option>');
                            $.each(data.data, function (index, value) {
                                $('#localbody').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });
            });
            $('#lbt').change(function() {
                toggleDivVisibility();

                LBTID=$('#lbt').val();
                DistrictID=$('#district').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-localbody/" + DistrictID+ "?LBT=" + LBTID,
                        data: { DistrictID: DistrictID ,LBTID: LBTID }, // Pass data as an object
                        success: function (data) {
                            //console.log(data);
                            //Clear and populate options in the block_list element
                            $('#localbody').html('<option value="0">Choose Local Body</option>');
                            $.each(data.data, function (index, value) {
                                $('#localbody').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });
                
            });

            function toggleDivVisibility() {
                var selectedValue = $('#lbt').val();

                // Show or hide the div based on the selected value
                if (selectedValue === '1') {
                    $('#block_div').show();

                    DistrictID=$('#district').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-blocks/" + DistrictID,
                        data: { DistrictID: DistrictID }, // Pass data as an object
                        success: function (data) {
                            // Clear and populate options in the block_list element
                            $('#block_list').html('<option value="0">Choose Block</option>');
                            $.each(data.data, function (index, value) {
                                $('#block_list').append('<option value="' + value.id + '">' + value.name + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });
                  
                } else {
                    $('#block_div').hide();
                }
            }
        });
        
    </script>


<script>
    function calculateMaxYear() {
        var currentDate = new Date();
        var defaultMaxYear = currentDate.getFullYear() - 35;
        
        var genderElements = document.getElementsByName('gender');
        var selectedGender;

        for (var i = 0; i < genderElements.length; i++) {
            if (genderElements[i].checked) {
                selectedGender = genderElements[i].value;
                break;
            }
        }

        var maxYear;

        if (selectedGender === 'male') {
            maxYear = currentDate.getFullYear() - 35;
        } else if (selectedGender === 'female' || selectedGender === 'transgender') {
            maxYear = currentDate.getFullYear() - 45;
        } else {
            maxYear = defaultMaxYear;
        }

        return maxYear;
    }

    document.getElementById('dob').addEventListener('change', function() {
        var validationMessagedob = document.getElementById('dobValidationMessage');
        var maxYear = calculateMaxYear();
        var dobYear = new Date(this.value).getFullYear();

        if (dobYear < maxYear) {
            this.setCustomValidity('Maximum age limit exceeded for the selected gender.');
            validationMessagedob.textContent = 'Maximum age limit exceeded for the selected gender';
            validationMessagedob.style.color = 'red';
        } else {
            this.setCustomValidity('');
            validationMessagedob.textContent = 'DOB matched';
            validationMessagedob.style.color = 'green';
        }
    });

    var genderRadios = document.getElementsByName('gender');
    for (var i = 0; i < genderRadios.length; i++) {
        genderRadios[i].addEventListener('change', function() {
            var maxYear = calculateMaxYear();
            var dobYear = new Date(document.getElementById('dob').value).getFullYear();
            var validationMessagedob = document.getElementById('dobValidationMessage');

            if (dobYear < maxYear) {
            this.setCustomValidity('Maximum age limit exceeded for the selected gender.');
            validationMessagedob.textContent = 'Maximum age limit exceeded for the selected gender';
            validationMessagedob.style.color = 'red';
        } else {
            this.setCustomValidity('');
            validationMessagedob.textContent = 'DOB matched';
            validationMessagedob.style.color = 'green';
        }
        });
    }
</script>
<script>
        function validateMobileNumber() {
            var mobileNumber = document.getElementById('mobileNumber').value;

            // Define a regular expression for a typical international mobile number format
            //var mobileNumberPattern = /^[+]?[0-9]{1,4}[-\s]?[0-9]{6,}$/;
            var mobileNumberPattern = /^[0-9]{10}$/;
            var mobvalidationMessage = document.getElementById('mobValidationMessage');

            $("#mobile_number_error").html("");
                $("input[name='mobileNumber']").removeClass("text-error");

           

            if (mobileNumberPattern.test(mobileNumber)) {

                //var mob_no=parseInt(mobilNumber);

                    mobvalidationMessage.textContent = 'Mobile number is valid!';
                    mobvalidationMessage.style.color = 'green';

/*
                if(mob_no>1000000000)
                {

                    mobvalidationMessage.textContent = 'Mobile number is valid!';
                    mobvalidationMessage.style.color = 'green';

                }

                else{

                    mobvalidationMessage.textContent = 'Invalid mobile number!';
                    mobvalidationMessage.style.color = 'red';


                }*/
               
            } else {
                mobvalidationMessage.textContent = 'Invalid mobile number!';
                mobvalidationMessage.style.color = 'red';
            }
        }
    </script>
    <script>
        function liveValidateEmail() {
            var emailInput = document.getElementById('email');
            var email = emailInput.value;

            // Use a regular expression for basic email validation
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            var validationMessage = document.getElementById('emailValidationMessage');

            if (emailPattern.test(email)) {
                validationMessage.textContent = 'Email is valid';
                validationMessage.style.color = 'green';
            } else {
                validationMessage.textContent = 'Invalid email address';
                validationMessage.style.color = 'red';
            }
        }
    </script>


<script>
        $(document).ready(function () {
            // Fade out the error message div after 5 seconds (5000 milliseconds)
            setTimeout(function () {
                $('#errorMessage').fadeOut('slow');
                $('#errorMessage1').fadeOut('slow');
            }, 10000);
        });
    </script>

@if(isset($max_year))
<script>

    $(document).ready(function()
    {
        $(document).on("change","#hQualification",function()
        {

            var highest_qualification=$(this).val();

            if(highest_qualification!="")
            {

                $("#hQualification").removeClass("error");

                $("#highest_qualification_error").html("");

            }
            
        });

        $(document).on("keyup","#dob",function()
        {


            var dob=$(this).val();
           
            let [year,month,day]=dob.split("-");

          

            if(!dob)
            {
                $("#dob_error").html("Date of birth required");
                $("#dobValidationMessage").hide();
                $("#dob").addClass("text-error");
            }

            else{

                var maxYear = calculateMaxYear();
               

                maxYear=parseInt(maxYear);
                year=parseInt(year);

                var max_year="{{ $max_year }}";
               

                if(max_year<year)
                {

                    $("#dob_error").html("Minimum age condition violated for selected gender");
                    $("#dobValidationMessage").hide();
                    $("#dob").addClass("text-error");
                    
                }

               else{


                    $("#dob_error").html("");
                    $("#dobValidationMessage").show();
                    $("#dob").removeClass("text-error");

                }
                

               
            }
        });

        $(document).on("change","#dob",function()
        {

            
            var dob=$(this).val();

           

            if(!dob)
            {
                $("#dob_error").html("Date of birth required");
                $("#dobValidationMessage").hide();
                $("#dob").addClass("text-error");
            }
            

            else{

                $("#dob_error").html("");
                $("#dobValidationMessage").show();
                $("#dob").removeClass("text-error");
            }
        });

        $(document).on("change","#category",function() 
        {

            var category=$(this).val();

            if(category!="")
            {

                $("#category_error").html("");
                $("#category").removeClass("error");


            }
            
        });

        
        $(document).on("change","#district",function() 
        {

            var district=$(this).val();

            if(district!="")
            {

                $("#district_error").html("");
                $("#district").removeClass("error");


            }
            
        });

        $(document).on("keyup","#candidatename",function()
        {
            var candidatename=$(this).val();

            if(candidatename!="")
            {
                $("#candidate_name_error").html("");

                $("#candidatename").removeClass("text-error");


            }
        });

        $(document).on("click","input[name='gender']",function()
        {
            var gender=$(this).val();

            if(gender!="")
            {
                $("#gender_error_message").html("");
                $("input[name='gender']").removeClass("error");


            }
        });

        $(document).on("keyup","#dob",function()
        {
            var dob=$(this).val();

            if(dob!="")
            {
                $("#errorMessage1").html("");
                $("input[name='dob']").removeClass("error");


            }
        });

        $(document).on("keyup","input[name='email']",function()
        {
            var email=$(this).val();

            if(email!="")
            {
                $("#email_error").html("");
                $("input[name='email']").removeClass("text-error");


            }
        });

                
        $(document).on("keyup","input[name='mobileNumber']",function()
        {
            var mobile_number=$(this).val();

            if(mobile_number!="")
            {
                $("#mobile_number_error").html("");
                $("input[name='mobileNumber']").removeClass("text-error");


            }
        });

        $(document).on("keyup","input[name='BuildingName']",function()
        {
            var building_name=$(this).val();

            if(building_name!="")
            {
                $("#building_name_error").html("");
                $("input[name='BuildingName']").removeClass("text-error");


            }
        });
        
        $(document).on("keyup","input[name='Landmark']",function()
        {
            var landmark=$(this).val();

            if(landmark!="")
            {
                $("#landmark_error").html("");
                $("input[name='Landmark']").removeClass("text-error");


            }
        });

        $(document).on("keyup","input[name='PostOffice']",function()
        {
            var postoffice=$(this).val();

            if(postoffice!="")
            {
                $("#post_office_error").html("");
                $("input[name='PostOffice']").removeClass("text-error");


            }
        });

        $(document).on("keyup","input[name='PIN_Code']",function()
        {
            var pincode=$(this).val();

            if(pincode!="")
            {

                if(pincode.length<6)
                {

                    $("#pincode_error").html("Pincode must be 6 digits");
                    $("input[name='PIN_Code']").addClass("text-error");


                }

                else{

                    $("#pincode_error").html("");
                    $("input[name='PIN_Code']").removeClass("text-error");

                }
                

            }
        });

        $(document).on("click","input[name='pwd']",function()
        {
            var pwd=$(this).val();

            if(pwd!="")
            {
                $("#pwd_error").html("");
                $("input[name='pwd']").removeClass("text-error");


            }
        });

        $(document).on("click","input[name='pwd']",function()
        {
            var pwd=$(this).val();

            if(pwd!="")
            {
                $("#pwd_error").html("");
                $("input[name='pwd']").removeClass("text-error");


            }
        });

        $(document).on("click","input[name='rationCard']",function()
        {
            var rationCard=$(this).val();

            if(rationCard!="")
            {
                $("#ration_card_error").html("");
                $("input[name='rationCard']").removeClass("text-error");


            }
        });

        $(document).on("click","input[name='mgnrega']",function()
        {
            var mgnrega=$(this).val();

            if(mgnrega!="")
            {
                $("#mgnrega_error").html("");
                $("input[name='mgnrega']").removeClass("text-error");


            }
        });

        $(document).on("click","input[name='kudMember']",function()
        {
            var kudMember=$(this).val();

            if(kudMember!="")
            {
                $("#kudumbashree_member_error").html("");
                $("input[name='kudMember']").removeClass("text-error");


            }
        });

        $(document).on("click","input[name='JoiTocourse']",function()
        {
            var JoiTocourse=$(this).val();

            if(JoiTocourse!="")
            {
                $("#join_to_course_error").html("");
                $("input[name='JoiTocourse']").removeClass("text-error");


            }
        });



    });



</script>

@endif



<script>
        $(document).ready(function() {
       // Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {

    
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }

        $('#submitBtn').click(function(event) {
           // Swal.fire('Form submitted!');
           var candidatename = $("#candidatename").val();
var Gender =$("input[name='gender']:checked").val();
var dobYear = $("#dob").val();
var maxYear = calculateMaxYear();
var category = $("#category").val();
var email = $("#email").val();
var mobileNumber = $("#mobileNumber").val();
var BuildingName = $("#BuildingName").val();
var Landmark = $("#Landmark").val();
var PostOffice = $("#PostOffice").val();
var PIN_Code = $("#PIN_Code").val();
var district = $("#district").val();
var pwd = $("input[name='pwd']:checked").val();
var rationCard = $("input[name='rationCard']:checked").val();
var mgnrega = $("input[name='mgnrega']:checked").val();
var kudMember = $("input[name='kudMember']:checked").val();
var JoiTocourse = $("input[name='JoiTocourse']:checked").val();
var hq=$("#hQualification").val();



if (!hq || !candidatename||!Gender||!dobYear||!category||!email||!mobileNumber||!BuildingName||!Landmark||!PostOffice||!PIN_Code||!district||!pwd||!rationCard||!mgnrega||!kudMember||!JoiTocourse)
{

                if(!dobYear)
                {
                    $("#dob_error").html("Date of birth required");
                    $("#dob").addClass('text-error');
                    $("#dobValidationMessage").hide();
                }

                else{

                    $("#dob_error").html("");
                    $("#dob").removeClass('text-error');
                    $("#dobValidationMessage").show();


                }

                if(!hq)
                {

                    $("#highest_qualification_error").html("Highest Qualification required");

                    $("#hQualification").addClass("error");

                }

                else{


                    $("#highest_qualification_error").html("");

                    $("#hQualification").removeClass("error");

                }
                
                if(!candidatename)
                {
                    $("#candidate_name_error").html("Candidate name required");

                    $("#candidatename").addClass("text-error");

                }

                else{

                    $("#candidate_name_error").html("");

                    $("#candidatename").removeClass("text-error");


                }

                if(!Gender)
                {
                
                
                    $("#gender_error_message").html("Gender required");

                    $("input[name='gender']").addClass("error");
                }

                else{

                   

                    $("#gender_error_message").html("");

                    $("input[name='gender']").removeClass("error");
                }

                if(!dobYear)
                {
                    $("#errorMessage1").html("Gender required");
                    $("input[name='dob']").addClass("error");
                }

                else{

                    $("#errorMessage1").html("");
                    $("input[name='dob']").removeClass("error");


                }

                if(!category)
                {

                    $("#category_error").html("Category required");
                    $("#category").addClass("error");
                }

                else{

            

                    $("#category_error").html("");
                    $("#category").removeClass("error");

    
                }

                if(!email)
                {
                    $("#email_error").html("Email required");
                    $("input[name='email']").addClass("text-error");

                }

                else{

                    $("#email_error").html("");
                    $("input[name='email']").removeClass("text-error");



                }

                if(!mobileNumber)
                {
                    $("#mobile_number_error").html("Mobile Number required");
                    $("input[name='mobileNumber']").addClass("text-error");
                }

                else{

                    $("#mobile_number_error").html("");
                    $("input[name='mobileNumber']").removeClass("text-error");


                }

                if(!BuildingName)
                {
                    $("#building_name_error").html("Building Name required");
                    $("input[name='BuildingName']").addClass("text-error");
                }

                else{

                    $("#building_name_error").html("");
                    $("input[name='BuildingName']").removeClass("text-error");


                }

                if(!Landmark)
                {
                    $("#landmark_error").html("Landmark required");
                    $("input[name='Landmark']").addClass("text-error");
                   
                }

                else{

                    $("#landmark_error").html("");
                    $("input[name='Landmark']").removeClass("text-error");
                }

                if(!PostOffice)
                {
                    $("#post_office_error").html("Post office required");
                    $("input[name='PostOffice']").addClass("text-error");
                }

                else{

                    $("#post_office_error").html("");
                    $("input[name='PostOffice']").removeClass("text-error");
                }


                if(!PIN_Code)
                {
                    $("#pincode_error").html("Pincode required");
                    $("input[name='PIN_Code']").addClass("text-error");
                }

                else{

                    if(PIN_Code.length<6)
                    {

                        $("#pincode_error").html("Pincode must be 6 digits");
                        $("input[name='PIN_Code']").addClass("text-error");

                    }

                    else{

                        $("#pincode_error").html("");
                        $("input[name='PIN_Code']").removeClass("text-error");
                    }

                   
                }

                if(!district)
                {
                    $("#district_error").html("District required");
                    $("#district").addClass("error");
                }

                else{

                    $("#district_error").html("");
                    $("#district").removeClass("error");
                }

                if(!pwd)
                {
                    $("#pwd_error").html("Pwd required");
                    $("input[name='pwd']").addClass("text-error");
                }

                else{

                    $("#pwd_error").html("");
                    $("input[name='pwd']").removeClass("text-error");
                }

                if(!rationCard)
                {
                    $("#ration_card_error").html("Ration card required");
                    $("input[name='rationCard']").addClass("text-error");
                }

                else{

                    $("#ration_card_error").html("");
                    $("input[name='rationCard']").removeClass("text-error");
                }

                if(!mgnrega)
                {
                    $("#mgnrega_error").html("mgnrega required");
                    $("input[name='mgnrega']").addClass("text-error");
                }

                else{

                    $("#mgnrega_error").html("");
                    $("input[name='mgnrega']").removeClass("text-error");
                }

                if(!kudMember)
                {
                    $("#kudumbashree_member_error").html(" whether Kudumbashree Member");
                    $("input[name='kudMember']").addClass("text-error");
                }

                else{

                    $("#kudumbashree_member_error").html("");
                    $("input[name='kudMember']").removeClass("text-error");
                }

                
                if(!JoiTocourse)
                {
                    $("#join_to_course_error").html("Willingness status required");
                    $("input[name='JoiTocourse']").addClass("text-error");
                }

                else{

                    $("#join_to_course_error").html("");
                    $("input[name='JoiTocourse']").removeClass("text-error");
                }
                
                Swal.fire("Please fill in all required fields in the Personal Details tab.");
                return false;
            }

            if (dobYear < maxYear) {
                $("input[name='dob']").addClass("error");
                displayValidationError('Maximum age limit exceeded for the selected gender.');
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            $("input[name='dob']").removeClass("error");
            $("input[name='gender']").removeClass("error");
            validationMessage.hide();

            // Prevent default form submission
            event.preventDefault();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($("#myForm")[0]);
            console.log(formData);
            

            $.ajax({
                
                headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
    url: "{{ route('SubmitInterest') }}",
    type: "POST",
    data: formData,
    dataType: "json",
    processData: false,
    contentType: false,
    success: function (response) {
        if (response.status == "success") {
        //     Swal.fire("Interest Submited",response.message,"success");
        //    $("#myForm")[0].reset();
        //     $("#ajax-loader").hide();
        //     window.location.href = response.redirect;
            Swal.fire({
                        title: "Interest Submitted",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#myForm")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#myForm")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
        } else{

            var errorMessage = "Something went wrong";

            if (response && response.message) {
                errorMessage = response.message;

            }

            Swal.fire("Failed", errorMessage, "error");

            $("#ajax-loader").hide();


}
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);
        console.log(JSON.parse(xhr.responseText).message);
        Swal.fire("Error", JSON.parse(xhr.responseText).message, "error");
        $("#ajax-loader").hide();
    }



});
    });
});


    
</script>



</body>

</html>