<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employer_details_updation_requests', function (Blueprint $table) {
            $table->string('prefered_location')->nullable();
            $table->string('cover_area')->nullable();
        });
        Schema::table('users', function (Blueprint $table) {
            $table->string('prefered_location')->nullable();
            $table->string('cover_area')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employer_details_updation_requests', function (Blueprint $table) {
            $table->dropColumn('prefered_location')->nullable();
            $table->dropColumn('cover_area')->nullable();
        });
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('prefered_location')->nullable();
            $table->dropColumn('cover_area')->nullable();
        });
    }
};
