<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pia_trades', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('pia_id');
            $table->unsignedBigInteger('sector_id');
            $table->unsignedBigInteger('trade_id');  // Assuming code is a string(10) in course_masters

            $table->timestamps();

            // Foreign Key Constraints
            $table->foreign('pia_id')->references('id')->on('program_implementation_agencies')->onDelete('cascade');
            $table->foreign('sector_id')->references('id')->on('sectors')->onDelete('cascade');
            $table->foreign('trade_id')->references('id')->on('course_masters')->onDelete('cascade');
        });

            
        

    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pia_trades');
    }
};
