<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('title',30);
            $table->longText('description');
            $table->foreignId('job_application_id')->nullable()->constrained('job_applications');
            $table->foreignId('candidate_id')->nullable()->constrained('users');
            $table->string('notification_type',30);
            $table->integer('status')->length(2)->default(1);
            $table->dateTime('seen_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
